<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2018 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:cdm="http://cdm-fr.fr/2013/CDM"
    xmlns:cdmfr="http://cdm-fr.fr/2013/CDM-frSchema"
    xmlns:ametys-cdm="http://www.ametys.org/cdm/1.0"
    xmlns:exsl="http://exslt.org/common"
    exclude-result-prefixes="cdm cdmfr ametys-cdm exsl">
    
    <!-- Langue -->
    <xsl:template name="program-educationLanguage">
        <educationLanguage>
            <xsl:for-each select="cdm:instructionLanguage">
                <item><xsl:value-of select="@teachingLang"/></item>
            </xsl:for-each>
        </educationLanguage>
    </xsl:template>
    
    <!-- Site(s) du diplôme -->
    <xsl:template name="program-website">
        <programWebSite>
            <xsl:for-each select="cdmfr:webLink">
                <entry name="{position()}">
                    <programWebSiteUrl><xsl:value-of select="cdm:href"/></programWebSiteUrl>
                    <programWebSiteLabel><xsl:value-of select="cdmfr:linkName"/></programWebSiteLabel>
                </entry>
            </xsl:for-each>
        </programWebSite>
    </xsl:template>
    
    <!-- Contacts -->
    <xsl:template name="program-contacts">
        <xsl:if test="cdm:contacts/cdm:refPerson">
            <xsl:variable name="contacts">
                <contacts>
                    <xsl:for-each select="cdm:contacts/cdm:refPerson[not(preceding-sibling::*/@role = @role)]">
                        <xsl:variable name="role" select="@role"/>
                        <entry>
                            <role><xsl:value-of select="$role"/></role>
                            <persons>
                                <xsl:for-each select="../cdm:refPerson[@role = $role]">
                                    <item><xsl:value-of select="@idRef"/></item>
                                </xsl:for-each>
                            </persons>
                        </entry>
                    </xsl:for-each>
                </contacts>
            </xsl:variable>
            
            <contacts>
                <xsl:for-each select="exsl:node-set($contacts)/contacts/entry">
                    <entry name="{position()}">
                        <xsl:copy-of select="*"/>
                    </entry>
                </xsl:for-each>
            </contacts>
        </xsl:if>
    </xsl:template>
    
    <!-- Nombre d'étudiants -->
    <xsl:template name="program-numberOfStudents">
        <numberOfStudents>
            <xsl:apply-templates select="cdm:admissionInfo/cdm:studentPlaces/cdm:infoBlock[*]" mode="infoblock"/>
        </numberOfStudents>
    </xsl:template>
    
    <!-- Ouvert aux stages -->
    <xsl:template name="program-internshipOpen">
        <internshipOpen><xsl:value-of select="count(cdm:infoBlock[@userDefined = 'ametys-extension']/cdm:extension/ametys-cdm:internshipOpen) > 0"/></internshipOpen>
    </xsl:template>
    
    <!-- Description des stages -->
    <xsl:template name="program-internshipDescription">
        <internshipDescription>
            <xsl:for-each select="cdm:infoBlock[@userDefined = 'ametys-extension']/cdm:extension/ametys-cdm:training/ametys-cdm:trainingDetails/ametys-cdm:trainingDetail">
                <entry name="{position()}">
                    <title><xsl:value-of select="ametys-cdm:title"/></title>
                    <duration><xsl:value-of select="ametys-cdm:duration"/></duration>
                    <period>
                        <xsl:for-each select="ametys-cdm:period">
                            <item><xsl:value-of select="@code"/></item>
                        </xsl:for-each>
                    </period>
                    <kind>
                        <xsl:apply-templates select="ametys-cdm:kind[*]" mode="infoblock"/>
                    </kind>
                </entry>
            </xsl:for-each>
        </internshipDescription>
    </xsl:template>
    
    <!-- Niveau d'entrée -->
    <xsl:template name="program-educationEntryLevel">
        <educationEntryLevel>
            <xsl:for-each select="cdm:infoBlock[@userDefined = 'ametys-extension']/cdm:extension/ametys-cdm:educationEntryLevel">
                <item><xsl:value-of select="@code"/></item>
            </xsl:for-each>
        </educationEntryLevel>
    </xsl:template>
    
    <!-- Campus -->
    <xsl:template name="program-campus">
        <campus>
            <xsl:for-each select="cdm:infoBlock[@userDefined = 'ametys-extension']/cdm:extension/ametys-cdm:campus">
                <item><xsl:value-of select="@code"/></item>
            </xsl:for-each>
        </campus>
    </xsl:template>
    
    <!-- Lieux à l'étranger -->
    <xsl:template name="program-foreignPlace">
        <foreignPlace>
            <xsl:for-each select="cdm:infoBlock[@userDefined = 'ametys-extension']/cdm:extension/ametys-cdm:foreignPlace">
                <item><xsl:value-of select="@code"/></item>
            </xsl:for-each>
        </foreignPlace>
    </xsl:template>
    
    <!-- Champs de la formation -->
    <xsl:template name="program-programField">
        <programField>
            <xsl:for-each select="cdm:infoBlock[@userDefined = 'ametys-extension']/cdm:extension/ametys-cdm:programField">
                <item><xsl:value-of select="@code"/></item>
            </xsl:for-each>
        </programField>
    </xsl:template>
    
    <!-- Disciplines -->
    <xsl:template name="program-disciplines">
        <disciplines>
            <xsl:for-each select="cdm:infoBlock[@userDefined = 'ametys-extension']/cdm:extension/ametys-cdm:disciplines">
                <item><xsl:value-of select="@code"/></item>
            </xsl:for-each>
        </disciplines>
    </xsl:template>
    
    <!-- Poursuite d'études dans l'établissement -->
    <xsl:template name="program-furtherStudyPrograms">
        <!-- FIXME ODF-1691 BiM Quid du sax des programmes associés ? -->
        <furtherStudyPrograms>
            <xsl:for-each select="cdm:infoBlock[@userDefined = 'ametys-extension']/cdm:extension/ametys-cdm:furtherStudyPrograms">
                <item><xsl:value-of select="@code"/></item>
            </xsl:for-each>
        </furtherStudyPrograms>
    </xsl:template>
    
    <!-- Secteurs d'activité -->
    <xsl:template name="program-sectors">
        <sectors>
            <xsl:for-each select="cdm:infoBlock[@userDefined = 'ametys-extension']/cdm:extension/ametys-cdm:sectors">
                <item><xsl:value-of select="@code"/></item>
            </xsl:for-each>
        </sectors>
    </xsl:template>
    
    <!-- Ouvert à l'alternance -->
    <xsl:template name="program-apprenticeshipOpen">
        <apprenticeshipOpen><xsl:value-of select="count(cdm:infoBlock[@userDefined = 'ametys-extension']/cdm:extension/ametys-cdm:apprenticeshipOpen) > 0"/></apprenticeshipOpen>
    </xsl:template>
    
    <!-- Rythme d'alternance -->
    <xsl:template name="program-apprenticeshipPeriod">
        <apprenticeshipPeriod>
            <xsl:apply-templates select="cdm:infoBlock[@userDefined = 'ametys-extension']/cdm:extension/ametys-cdm:apprenticeshipPeriod/cdm:infoBlock[*]" mode="infoblock"/>
        </apprenticeshipPeriod>
    </xsl:template>
    
    <!-- Modalités d'alternance -->
    <xsl:template name="program-apprenticeshipModalities">
        <apprenticeshipModalities>
            <xsl:apply-templates select="cdm:infoBlock[@userDefined = 'ametys-extension']/cdm:extension/ametys-cdm:apprenticeshipModalities/cdm:infoBlock[*]" mode="infoblock"/>
        </apprenticeshipModalities>
    </xsl:template>
    
    <!-- Type de contrat d'alternance -->
    <xsl:template name="program-apprenticeshipContract">
        <apprenticeshipContract>
            <xsl:for-each select="cdm:infoBlock[@userDefined = 'ametys-extension']/cdm:extension/ametys-cdm:apprenticeshipContract">
                <item><xsl:value-of select="@code"/></item>
            </xsl:for-each>
        </apprenticeshipContract>
    </xsl:template>
    
    <!-- Formation internationale -->
    <xsl:template name="program-internationalEducation">
        <internationalEducation>
            <xsl:for-each select="cdm:infoBlock[@userDefined = 'ametys-extension']/cdm:extension/ametys-cdm:internationalEducation">
                <item><xsl:value-of select="@code"/></item>
            </xsl:for-each>
        </internationalEducation>
    </xsl:template>
    
    <!-- Dimension internationale -->
    <xsl:template name="program-internationalDimension">
        <internationalDimension>
            <xsl:apply-templates select="cdm:infoBlock[@userDefined = 'ametys-extension']/cdm:extension/ametys-cdm:internationalDimension/cdm:infoBlock[*]" mode="infoblock"/>
        </internationalDimension>
    </xsl:template>
    
    <!-- Géolocalisation -->
    <xsl:template name="program-geocode">
        <xsl:if test="cdm:infoBlock[@userDefined = 'ametys-extension']/cdm:extension/ametys-cdm:geoCode">
            <geoCode>
                <xsl:if test="cdm:infoBlock[@userDefined = 'ametys-extension']/cdm:extension/ametys-cdm:geoCode/@latitude and cdm:infoBlock[@userDefined = 'ametys-extension']/cdm:extension/ametys-cdm:geoCode/@longitude">
                    <latitude><xsl:value-of select="cdm:infoBlock[@userDefined = 'ametys-extension']/cdm:extension/ametys-cdm:geoCode/@latitude" /></latitude>
                    <longitude><xsl:value-of select="cdm:infoBlock[@userDefined = 'ametys-extension']/cdm:extension/ametys-cdm:geoCode/@longitude" /></longitude>
                </xsl:if>
            </geoCode>
        </xsl:if>
    </xsl:template>
    
    <!-- Autres partenaires -->
    <xsl:template name="program-otherPartners">
        <otherPartners>
            <xsl:apply-templates select="cdm:infoBlock[@userDefined = 'ametys-extension']/cdm:extension/ametys-cdm:otherPartners[*]" mode="infoblock"/>
        </otherPartners>
    </xsl:template>
    
    <!-- Autres contacts -->
    <xsl:template name="program-otherContact">
        <otherContact>
            <xsl:apply-templates select="cdm:infoBlock[@userDefined = 'ametys-extension']/cdm:extension/ametys-cdm:otherContact[*]" mode="infoblock"/>
        </otherContact>
    </xsl:template>
    
    <!-- Certifications disponibles -->
    <xsl:template name="program-availableCertification">
        <availableCertification>
            <xsl:for-each select="cdm:infoBlock[@userDefined = 'ametys-extension']/cdm:extension/ametys-cdm:availableCertification">
                <item><xsl:value-of select="@code"/></item>
            </xsl:for-each>
        </availableCertification>
    </xsl:template>
    
    <!-- Inscription -->
    <xsl:template name="program-inscription">
        <inscription>
            <xsl:apply-templates select="cdm:admissionInfo/cdmfr:registrationDetail/cdmfr:registrationProcess/cdmfr:registrationModalities/cdm:infoBlock[*]" mode="infoblock"/>
        </inscription>
    </xsl:template>
    
    <xsl:template name="program-subProgram">
        <xsl:for-each select="cdm:subProgram[cdm:infoBlock/@userDefined = 'subProgram']">
            <subProgram>
                <xsl:call-template name="program-parse"/>
            </subProgram>
        </xsl:for-each>
        <xsl:for-each select="cdm:subProgram[cdm:infoBlock/@userDefined = 'container']">
            <container>
                <xsl:call-template name="container-parse"/>
            </container>
        </xsl:for-each>
    </xsl:template>
</xsl:stylesheet>
