/*
 *  Copyright 2017 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.odfsync.apogee.scc.operator;

import java.util.List;
import java.util.stream.Collectors;

import org.slf4j.Logger;

import org.ametys.plugins.odfsync.scc.operator.AbstractODFSynchronizingContentOperator;
import org.ametys.runtime.model.ElementDefinition;
import org.ametys.runtime.model.ModelItem;
import org.ametys.runtime.model.type.ModelItemTypeConstants;

/**
 * Get mapped values from Apogée to Ametys.
 */
public class ApogeeSynchronizingContentOperator extends AbstractODFSynchronizingContentOperator
{
    @Override
    protected String getHelperRole()
    {
        return "org.ametys.plugins.odfsync.apogee.scc.operator.ApogeeSynchronizingContentOperatorHelper";
    }
    
    @Override
    protected List<Object> _transformAttributeValues(ModelItem definition, List<Object> values, Logger logger)
    {
        if (ModelItemTypeConstants.BOOLEAN_TYPE_ID.equals(definition.getType().getId()))
        {
            return _transformBooleanAttributeValues((ElementDefinition) definition, values, logger);
        }
        
        return super._transformAttributeValues(definition, values, logger);
    }

    /**
     * Transform the given boolean values 
     * @param definition The definition of the attribute
     * @param values The values to transform
     * @param logger The logger
     * @return The transformed boolean values
     */
    protected List<Object> _transformBooleanAttributeValues(ElementDefinition definition, List<Object> values, Logger logger)
    {
        return values.stream()
                .map(String::valueOf)
                .map("O"::equals)
                .collect(Collectors.toList());
    }
}
