/*
 *  Copyright 2022 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.odfsync.export;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;

import org.ametys.core.ui.SimpleMenu;
import org.ametys.runtime.config.Config;

/**
 * Client side element for export connector's export buttons
 */
public class ExportSimpleMenu extends SimpleMenu
{
    private boolean _isActive;
    
    @Override
    public void configure(Configuration configuration) throws ConfigurationException
    {
        super.configure(configuration);
        _isActive = Optional.of("activate-param")
                .map(configuration::getChild)
                .map(childConf -> childConf.getValue(null))
                .map(param -> Config.getInstance().<Boolean>getValue(param, true, false))
                .orElse(false);
    }
    
    @Override
    public List<Script> getScripts(boolean ignoreRights, Map<String, Object> contextParameters)
    {
        if (_isActive)
        {
            return super.getScripts(ignoreRights, contextParameters);
        }
        
        return new ArrayList<>();
    }
}
