/*
 *  Copyright 2017 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.workspaces.odfsync;

import org.apache.cocoon.environment.Request;

import org.ametys.core.authentication.AuthenticateAction;
import org.ametys.workspaces.odf.AbstractODFAuthenticateAction;

/**
 * Special authentication process for incoming CDM-fr.<br>
 * Incoming requests are allowed if client IP is allowed.
 */
public class ODFSyncAuthenticateAction extends AbstractODFAuthenticateAction
{
    @Override
    protected String getConfigParameter()
    {
        return "org.ametys.plugins.odfsync.ip";
    }

    @Override
    protected String getExceptionMessage()
    {
        return "IP '%s' is not allowed as CDM-fr provider.";
    }
    
    @Override
    protected void authenticate(Request request)
    {
        super.authenticate(request);
        request.setAttribute(AuthenticateAction.REQUEST_ATTRIBUTE_INTERNAL_ALLOWED, true);
    }
}
