/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfsync.apogee;

import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.ametys.cms.repository.Content;
import org.ametys.cms.repository.ModifiableContent;
import org.ametys.core.schedule.progression.ContainerProgressionTracker;
import org.ametys.core.schedule.progression.SimpleProgressionTracker;
import org.ametys.odf.ODFHelper;
import org.ametys.odf.catalog.CatalogsManager;
import org.ametys.odf.cdmfr.CDMFRHandler;
import org.ametys.plugins.core.impl.schedule.AbstractStaticSchedulable;
import org.ametys.plugins.odfsync.apogee.scc.ApogeeSynchronizableContentsCollectionHelper;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.jcr.SimpleAmetysObject;
import org.ametys.runtime.i18n.I18nizableText;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Request;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;

public class ApogeeSchedulable
extends AbstractStaticSchedulable {
    private ODFHelper _odfHelper;
    private ApogeeSynchronizableContentsCollectionHelper _apogeeSCCHelper;
    private CatalogsManager _catalogsManager;
    private CDMFRHandler _cdmfrHandler;

    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._odfHelper = (ODFHelper)manager.lookup(ODFHelper.ROLE);
        this._apogeeSCCHelper = (ApogeeSynchronizableContentsCollectionHelper)manager.lookup(ApogeeSynchronizableContentsCollectionHelper.ROLE);
        this._catalogsManager = (CatalogsManager)manager.lookup(CatalogsManager.ROLE);
        this._cdmfrHandler = (CDMFRHandler)manager.lookup(CDMFRHandler.ROLE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(JobExecutionContext context, ContainerProgressionTracker progressionTracker) throws Exception {
        long begin = System.currentTimeMillis();
        Request request = ContextHelper.getRequest((Context)this._context);
        try {
            this._cdmfrHandler.suspendCDMFRObserver();
            request.setAttribute(ApogeeSynchronizableContentsCollectionHelper.HANDLED_CONTENTS, new HashSet());
            this.synchronizeCollections(context, progressionTracker);
        }
        catch (Exception ex) {
            this.getLogger().error("The global synchronization have failed.", (Throwable)ex);
        }
        finally {
            Set handledContents = (Set)request.getAttribute(ApogeeSynchronizableContentsCollectionHelper.HANDLED_CONTENTS);
            this._cdmfrHandler.unsuspendCDMFRObserver(handledContents);
            request.removeAttribute(ApogeeSynchronizableContentsCollectionHelper.HANDLED_CONTENTS);
            if (this.getLogger().isInfoEnabled()) {
                this.getLogger().info("Global synchronization ended in {} ms", (Object)(System.currentTimeMillis() - begin));
            }
        }
    }

    protected void synchronizeCollections(JobExecutionContext context, ContainerProgressionTracker progressionTracker) {
        String catalog = Optional.of(context).map(JobExecutionContext::getJobDetail).map(JobDetail::getJobDataMap).map(map -> map.getString("parameterValues#catalog")).map(arg_0 -> ((CatalogsManager)this._catalogsManager).getCatalog(arg_0)).map(SimpleAmetysObject::getName).orElseGet(() -> ((CatalogsManager)this._catalogsManager).getDefaultCatalogName());
        AmetysObjectIterable programs = this._odfHelper.getProgramItems("org.ametys.plugins.odf.Content.program", null, catalog, null);
        for (Content program : programs) {
            progressionTracker.addSimpleStep(program.getId(), new I18nizableText("plugin.odf-sync", "PLUGINS_ODF_SYNC_GLOBAL_SYNCHRONIZATION_SCHEDULER_PROGRAM_SYNC_STEP_LABEL", List.of(program.getTitle())));
        }
        for (Content program : programs) {
            this._apogeeSCCHelper.synchronizeContent((ModifiableContent)program, this.getLogger());
            ((SimpleProgressionTracker)progressionTracker.getStep(program.getId())).increment();
        }
    }
}

