/*
 *  Copyright 2025 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.odfsync.apogee.scc.impl;

import java.util.List;
import java.util.Map;

import org.ametys.odf.coursepart.CoursePart;
import org.ametys.plugins.odfsync.apogee.scc.AbstractPreviousYearsSynchronizableContentsCollection;

/**
 * SCC for nbStudents fields for container contents.
 */
public class CoursePartGroupsSynchronizableContentsCollection extends AbstractPreviousYearsSynchronizableContentsCollection
{
    @Override
    public String getIdField()
    {
        return CoursePart.CODE;
    }
    
    @Override
    protected String getCurrentYearAttributeName()
    {
        return "currentYearGroups";
    }
    
    @Override
    protected String getPrecedingYearAttributeName()
    {
        return "precedingYearGroups";
    }
    
    @Override
    protected String getSyncCodeItemName()
    {
        return "apogeeSyncCodeGroups";
    }
    
    @Override
    protected List<Map<String, Object>> executeApogeeRequest(Map<String, Object> parameters)
    {
        return _apogeePreviousYearsFieldsDAO.getCoursePartGroups(getDataSourceId(), getParameterValues(), parameters);
    }
}
