<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2012 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:cdm="http://cdm-fr.fr/2011/CDM"
	xmlns:cdmfr="http://cdm-fr.fr/2011/CDM-frSchema"
	exclude-result-prefixes="cdm cdmfr">
	
	<xsl:template name="orgunit-CDMid">
		<xsl:attribute name="CDMid"><xsl:value-of select="@id"/></xsl:attribute>
	</xsl:template>
	
	<xsl:template name="orgunit-code">
		<code><xsl:value-of select="cdm:orgUnitID"/></code>
	</xsl:template>
	
	<xsl:template name="orgunit-codeUAI">
		<xsl:if test="cdm:orgUnitCode[@codeSet='codeUAI']">
			<codeUAI><xsl:value-of select="cdm:orgUnitCode[@codeSet='codeUAI']"/></codeUAI>
		</xsl:if>
	</xsl:template>
	
	<xsl:template name="orgunit-title">
		<xsl:if test="cdm:orgUnitName/cdm:text">
			<title><xsl:value-of select="cdm:orgUnitName/cdm:text"/></title>
		</xsl:if>
	</xsl:template>
	
	<xsl:template name="orgunit-acronym">
		<xsl:if test="cdm:orgUnitAcronym">
			<acronym><xsl:value-of select="cdm:orgUnitAcronym"/></acronym>
		</xsl:if>
	</xsl:template>
	
	<xsl:template name="orgunit-description">
		<description>
			<xsl:if test="cdm:orgUnitDescription/*">
				<xsl:apply-templates select="cdm:orgUnitDescription[*]" mode="infoblock"/>
			</xsl:if>
		</description>
	</xsl:template>
	
	<xsl:template name="orgunit-admissionInfo">
		<admissionInfo>
			<xsl:if test="cdm:admissionInfo/cdmfr:admissionDescription/*">
				<xsl:apply-templates select="cdm:admissionInfo/cdmfr:admissionDescription[*]" mode="infoblock"/>
			</xsl:if>
		</admissionInfo>
	</xsl:template>
	
	<xsl:template name="orgunit-regulations">
		<regulations>
			<xsl:if test="cdm:regulations/*">
				<xsl:apply-templates select="cdm:regulations[*]" mode="infoblock"/>
			</xsl:if>
		</regulations>
	</xsl:template>
	
	<xsl:template name="orgunit-expenses">
		<expenses>
			<xsl:if test="cdm:expenses/*">
				<xsl:apply-templates select="cdm:expenses[*]" mode="infoblock"/>
			</xsl:if>
		</expenses>
	</xsl:template>
	
	<xsl:template name="orgunit-universalAdjustment">
		<universalAdjustment>
			<xsl:if test="cdm:universalAdjustment/*">
				<xsl:apply-templates select="cdm:universalAdjustment[*]" mode="infoblock"/>
			</xsl:if>
		</universalAdjustment>
	</xsl:template>
	
	<xsl:template name="orgunit-studentFacilities">
		<studentFacilities>
			<xsl:if test="cdm:studentFacilities/*">
				<xsl:apply-templates select="cdm:studentFacilities[*]" mode="infoblock"/>
			</xsl:if>
		</studentFacilities>
	</xsl:template>
	
	<xsl:template name="orgunit-additionalInfos">
		<additionalInfos>
			<xsl:if test="cdm:infoBlock/*">
				<xsl:apply-templates select="cdm:infoBlock[*]" mode="infoblock"/>
			</xsl:if>
		</additionalInfos>
	</xsl:template>
	
	<xsl:template name="orgunit-webLinkLabel">
		<xsl:if test="cdmfr:webLink/cdmfr:linkName">
			<webLinkLabel><xsl:value-of select="cdmfr:webLink/cdmfr:linkName"/></webLinkLabel>
		</xsl:if>
	</xsl:template>
	
	<xsl:template name="orgunit-webLinkUrl">
		<xsl:if test="cdmfr:webLink/cdm:href">
			<webLinkUrl><xsl:value-of select="cdmfr:webLink/cdm:href"/></webLinkUrl>
		</xsl:if>
	</xsl:template>
	
	<xsl:template name="orgunit-contactsReferences">
		<contactsReferences>
			<xsl:for-each select="cdm:contacts/cdm:refPerson">
				<item><xsl:value-of select="@idRef"/></item>
			</xsl:for-each>
		</contactsReferences>
	</xsl:template>
    
    <!-- Template to override in order to add customized fields -->
    <xsl:template name="orgunit-additionalFields"/>
</xsl:stylesheet>
