/*
 *  Copyright 2017 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.odfsync.apogee;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

import org.ametys.core.ui.AddTaskClientSideElement;
import org.ametys.plugins.contentio.synchronize.SynchronizableContentsCollection;
import org.ametys.plugins.contentio.synchronize.SynchronizableContentsCollectionDAO;
import org.ametys.plugins.odfsync.apogee.scc.ApogeeSynchronizableContentsCollection;

/**
 * This implementation test if at least one SCC is instance of {@link ApogeeSynchronizableContentsCollection}
 * If yes, the first collection is used to create the button, it there are no collections, the button is not displayed.
 */
public class ApogeeGlobalSynchronizationClientSideElement extends AddTaskClientSideElement
{
    /** The SCC DAO */
    protected SynchronizableContentsCollectionDAO _sccDAO;
    
    @Override
    public void service(ServiceManager manager) throws ServiceException
    {
        super.service(manager);
        _sccDAO = (SynchronizableContentsCollectionDAO) manager.lookup(SynchronizableContentsCollectionDAO.ROLE); 
    }
    
    @Override
    public List<Script> getScripts(boolean ignoreRights, Map<String, Object> contextParameters)
    {
        // Only activate if they are an Apogee SCC
        for (SynchronizableContentsCollection scc : _sccDAO.getSynchronizableContentsCollections())
        {
            if (scc instanceof ApogeeSynchronizableContentsCollection)
            {
                return super.getScripts(ignoreRights, contextParameters);
            }
        }
        
        return new ArrayList<>();
    }
}
