/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfsync.cdmfr.rights;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.ametys.cms.repository.Content;
import org.ametys.core.group.GroupIdentity;
import org.ametys.core.right.AccessController;
import org.ametys.core.right.AccessExplanation;
import org.ametys.core.right.RightsException;
import org.ametys.core.right.RightsExtensionPoint;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.population.UserPopulationDAO;
import org.ametys.odf.rights.ODFContentHierarchicalAccessController;
import org.ametys.odf.tree.ODFContentsTreeHelper;
import org.ametys.plugins.contentio.synchronize.SynchronizableContentsCollection;
import org.ametys.plugins.contentio.synchronize.SynchronizableContentsCollectionDAO;
import org.ametys.plugins.contentio.synchronize.SynchronizableContentsCollectionHelper;
import org.ametys.plugins.odfsync.cdmfr.RemoteCDMFrSynchronizableContentsCollection;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.plugin.component.PluginAware;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public class RemoteCDMFrSCCAccessController
implements AccessController,
Serviceable,
PluginAware {
    protected ODFContentsTreeHelper _odfContentsTreeHelper;
    private SynchronizableContentsCollectionHelper _sccHelper;
    private SynchronizableContentsCollectionDAO _collectionsDAO;
    private RightsExtensionPoint _rightsExtensionPoint;
    private String _id;

    public void service(ServiceManager manager) throws ServiceException {
        this._odfContentsTreeHelper = (ODFContentsTreeHelper)manager.lookup(ODFContentsTreeHelper.ROLE);
        this._sccHelper = (SynchronizableContentsCollectionHelper)manager.lookup(SynchronizableContentsCollectionHelper.ROLE);
        this._collectionsDAO = (SynchronizableContentsCollectionDAO)manager.lookup(SynchronizableContentsCollectionDAO.ROLE);
        this._rightsExtensionPoint = (RightsExtensionPoint)manager.lookup(RightsExtensionPoint.ROLE);
    }

    public void setPluginInfo(String pluginName, String featureName, String id) {
        this._id = id;
    }

    public AccessController.AccessResult getPermission(UserIdentity user, Set<GroupIdentity> userGroups, String rightId, Object object) {
        return UserPopulationDAO.SYSTEM_USER_IDENTITY.equals((Object)user) ? AccessController.AccessResult.USER_ALLOWED : AccessController.AccessResult.UNKNOWN;
    }

    public AccessController.AccessResult getReadAccessPermission(UserIdentity user, Set<GroupIdentity> userGroups, Object object) {
        return UserPopulationDAO.SYSTEM_USER_IDENTITY.equals((Object)user) ? AccessController.AccessResult.USER_ALLOWED : AccessController.AccessResult.UNKNOWN;
    }

    public Map<String, AccessController.AccessResult> getPermissionByRight(UserIdentity user, Set<GroupIdentity> userGroups, Object object) {
        if (UserPopulationDAO.SYSTEM_USER_IDENTITY.equals((Object)user)) {
            return this._rightsExtensionPoint.getExtensionsIds().stream().collect(Collectors.toMap(rightId -> rightId, rightId -> AccessController.AccessResult.USER_ALLOWED));
        }
        return Collections.EMPTY_MAP;
    }

    public AccessController.AccessResult getPermissionForAnonymous(String rightId, Object object) {
        return AccessController.AccessResult.UNKNOWN;
    }

    public AccessController.AccessResult getReadAccessPermissionForAnonymous(Object object) {
        return AccessController.AccessResult.UNKNOWN;
    }

    public AccessController.AccessResult getPermissionForAnyConnectedUser(String rightId, Object object) {
        return AccessController.AccessResult.UNKNOWN;
    }

    public AccessController.AccessResult getReadAccessPermissionForAnyConnectedUser(Object object) {
        return AccessController.AccessResult.UNKNOWN;
    }

    public Map<UserIdentity, AccessController.AccessResult> getPermissionByUser(String rightId, Object object) {
        return Map.of(UserPopulationDAO.SYSTEM_USER_IDENTITY, AccessController.AccessResult.USER_ALLOWED);
    }

    public Map<UserIdentity, AccessController.AccessResult> getReadAccessPermissionByUser(Object object) {
        return this.getPermissionByUser(null, object);
    }

    public Map<GroupIdentity, AccessController.AccessResult> getPermissionByGroup(String rightId, Object object) {
        return Collections.EMPTY_MAP;
    }

    public Map<GroupIdentity, AccessController.AccessResult> getReadAccessPermissionByGroup(Object object) {
        return Collections.EMPTY_MAP;
    }

    public boolean hasUserAnyPermissionOnWorkspace(Set<Object> workspacesContexts, UserIdentity user, Set<GroupIdentity> userGroups, String rightId) {
        return UserPopulationDAO.SYSTEM_USER_IDENTITY.equals((Object)user);
    }

    public boolean hasUserAnyReadAccessPermissionOnWorkspace(Set<Object> workspacesContexts, UserIdentity user, Set<GroupIdentity> userGroups) {
        return this.hasUserAnyPermissionOnWorkspace(workspacesContexts, user, userGroups, null);
    }

    public boolean hasAnonymousAnyPermissionOnWorkspace(Set<Object> workspacesContexts, String rightId) {
        return false;
    }

    public boolean hasAnonymousAnyReadAccessPermissionOnWorkspace(Set<Object> workspacesContexts) {
        return false;
    }

    public boolean hasAnyConnectedUserAnyPermissionOnWorkspace(Set<Object> workspacesContexts, String rightId) {
        return false;
    }

    public boolean hasAnyConnectedUserAnyReadAccessPermissionOnWorkspace(Set<Object> workspacesContexts) {
        return false;
    }

    public boolean supports(Object object) {
        if (object instanceof Content) {
            Content content = (Content)object;
            Set collectionIds = this._sccHelper.getSynchronizableCollectionIds(content);
            for (String collectionId : collectionIds) {
                SynchronizableContentsCollection scc = this._collectionsDAO.getSynchronizableContentsCollection(collectionId);
                if (!(scc instanceof RemoteCDMFrSynchronizableContentsCollection)) continue;
                return true;
            }
        }
        return false;
    }

    public AccessExplanation explainReadAccessPermission(UserIdentity user, Set<GroupIdentity> groups, Object context) {
        if (UserPopulationDAO.SYSTEM_USER_IDENTITY.equals((Object)user)) {
            return new AccessExplanation(this.getId(), AccessController.AccessResult.USER_ALLOWED, new I18nizableText("plugin.odf-sync", "PLUGINS_ODF_SYNC_CDMFR_ACCESS_CONTROLLER_SYSTEM_USER_ALLOWED", Map.of("title", new I18nizableText(((Content)context).getTitle()))));
        }
        return AccessController.getDefaultAccessExplanation((String)this.getId(), (AccessController.AccessResult)AccessController.AccessResult.UNKNOWN);
    }

    public AccessExplanation explainPermission(UserIdentity user, Set<GroupIdentity> groups, String rightId, Object context) {
        if (UserPopulationDAO.SYSTEM_USER_IDENTITY.equals((Object)user)) {
            return new AccessExplanation(this.getId(), AccessController.AccessResult.USER_ALLOWED, new I18nizableText("plugin.odf-sync", "PLUGINS_ODF_SYNC_CDMFR_ACCESS_CONTROLLER_SYSTEM_USER_ALLOWED", Map.of("title", this.getObjectLabel(context))));
        }
        return AccessController.getDefaultAccessExplanation((String)this.getId(), (AccessController.AccessResult)AccessController.AccessResult.UNKNOWN);
    }

    public I18nizableText getObjectLabel(Object object) {
        if (object instanceof Content) {
            Content content = (Content)object;
            return ODFContentHierarchicalAccessController.getContentObjectLabel((Content)content, (ODFContentsTreeHelper)this._odfContentsTreeHelper);
        }
        throw new RightsException("Unsupported context: " + object.toString());
    }

    public Map<AccessController.ExplanationObject, Map<AccessController.Permission, AccessExplanation>> explainAllPermissions(UserIdentity identity, Set<GroupIdentity> groups, Set<Object> workspacesContexts) {
        return Map.of();
    }

    public Map<AccessController.Permission, AccessExplanation> explainAllPermissionsForAnonymous(Object object) {
        return Map.of();
    }

    public Map<AccessController.Permission, AccessExplanation> explainAllPermissionsForAnyConnected(Object object) {
        return Map.of();
    }

    public Map<UserIdentity, Map<AccessController.Permission, AccessExplanation>> explainAllPermissionsByUser(Object object) {
        return Map.of();
    }

    public Map<GroupIdentity, Map<AccessController.Permission, AccessExplanation>> explainAllPermissionsByGroup(Object object) {
        return Map.of();
    }

    public I18nizableText getObjectCategory(Object object) {
        return ODFContentHierarchicalAccessController.ODF_CONTEXT_CATEGORY;
    }

    public String getId() {
        return this._id;
    }
}

