/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfsync.export;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.ametys.cms.repository.Content;
import org.ametys.plugins.odfsync.export.AbstractExportStructure;
import org.ametys.runtime.i18n.I18nizableText;

public class ExportReport {
    private Content _content;
    private AbstractExportStructure _structure;
    private Map<Content, Set<I18nizableText>> _invalidDataByContent;
    private Set<ProblemTypes> _problemsEncountered;
    private int _nbTotal;
    private Set<Content> _elementsPartlyExported;
    private Set<Content> _elementsExported;
    private ExportStatus _status;

    public ExportReport(Content content) {
        this._content = content;
        this._status = ExportStatus.OK;
        this._invalidDataByContent = new HashMap<Content, Set<I18nizableText>>();
        this._problemsEncountered = new HashSet<ProblemTypes>();
        this._elementsExported = new HashSet<Content>();
        this._elementsPartlyExported = new HashSet<Content>();
    }

    public Content getContent() {
        return this._content;
    }

    public Map<Content, Set<I18nizableText>> getInvalidDataPathByContent() {
        return this._invalidDataByContent;
    }

    public void addInvalidDataPath(Content content, I18nizableText invalidMessage) {
        this.updateStatus(ExportStatus.CONTENT_DATA_INVALID);
        this._invalidDataByContent.computeIfAbsent(content, __ -> new HashSet()).add(invalidMessage);
    }

    public AbstractExportStructure getExportStructure() {
        return this._structure;
    }

    public void setExportStructure(AbstractExportStructure structure) {
        this._structure = structure;
    }

    public ExportStatus getStatus() {
        return this._status;
    }

    public void setStatus(ExportStatus status) {
        this._status = status;
    }

    public int getNbExported() {
        return this._elementsExported.size();
    }

    public int getNbPartlyExported() {
        return this._elementsPartlyExported.size();
    }

    public int getNbNotExported() {
        return this._nbTotal - this.getNbExported() - this.getNbPartlyExported();
    }

    public void setNbTotal(int nbTotal) {
        this._nbTotal = nbTotal;
    }

    public Set<ProblemTypes> getProblemsEncountered() {
        return this._problemsEncountered;
    }

    public void addElementExported(Content element) {
        if (!this._elementsPartlyExported.contains(element)) {
            this._elementsExported.add(element);
        }
    }

    public void updateStatus(ExportStatus status) {
        if (status.weight() > this._status.weight()) {
            this._status = status;
        }
    }

    public void updateExportReport(ExportStatus exportStatusWanted, ProblemTypes problemEncountered) {
        this.updateStatus(exportStatusWanted);
        this._problemsEncountered.add(problemEncountered);
    }

    public void updateExportReport(ExportStatus exportStatusWanted, ProblemTypes problemEncountered, Content content) {
        this.updateExportReport(exportStatusWanted, problemEncountered);
        this._elementsPartlyExported.add(content);
        this._elementsExported.remove(content);
    }

    public static enum ExportStatus {
        CONTENT_DATA_INVALID(50),
        CONTENT_STRUCTURE_INVALID(100),
        NON_EDITABLE_PROGRAM_ALREADY_EXISTS(50),
        PROGRAM_IMPOSSIBLE_VERSION(50),
        ERROR(Integer.MAX_VALUE),
        WARN(500),
        OK(0);

        private int _weight;

        private ExportStatus(int weight) {
            this._weight = weight;
        }

        int weight() {
            return this._weight;
        }
    }

    public static enum ProblemTypes {
        ELEMENT_NOT_EXPORTED,
        ELEMENT_ALREADY_EXIST,
        GROUPEMENT_WITHOUT_CHILDREN,
        LINKS_MISSING,
        API_ERROR;

    }
}

