<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2012 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:cdm="http://cdm-fr.fr/2013/CDM"
	xmlns:cdmfr="http://cdm-fr.fr/2013/CDM-frSchema"
	xmlns:ametys-cdm="http://www.ametys.org/cdm/1.0"
    xmlns:exsl="http://exslt.org/common"
    xmlns:cms="http://ametys.org/cms/3.0"
	exclude-result-prefixes="cdm cdmfr cms exsl">
	
    <xsl:import href="../utils.xsl"/>
    
	<xsl:template name="course-CDMid">
		<xsl:attribute name="CDMid"><xsl:value-of select="@id"/></xsl:attribute>
	</xsl:template>
	
	<xsl:template name="course-language">
		<xsl:if test="@language">
			<xsl:attribute name="language"><xsl:value-of select="@language"/></xsl:attribute>
		</xsl:if>
	</xsl:template>
	
	<!-- Catalogue -->
	<xsl:template name="course-catalog">
		<xsl:if test="cdm:infoBlock[@userDefined = 'ametys-extension']/cdm:extension/ametys-cdm:catalog">
			<catalog><xsl:value-of select="cdm:infoBlock[@userDefined = 'ametys-extension']/cdm:extension/ametys-cdm:catalog/@value"/></catalog>
		</xsl:if>
	</xsl:template>
	
    <!-- Nature de l'ELP -->
    <xsl:template name="course-nature">
        <xsl:if test="cdm:courseCode/@codeSet">
            <courseType><xsl:value-of select="cdm:courseCode/@codeSet"/></courseType>
        </xsl:if>
    </xsl:template>
    
	<xsl:template name="course-description">
		<description>
			<xsl:if test="cdm:courseDescription/cdmfr:infoBlock[not(@userDefined)]/*">
				<xsl:apply-templates select="cdm:courseDescription/cdmfr:infoBlock[not(@userDefined)][*]" mode="infoblock"/>
			</xsl:if>
		</description>
	</xsl:template>
	
	<xsl:template name="course-objectives">
		<objectives>
			<xsl:if test="cdm:learningObjectives/*">
				<xsl:apply-templates select="cdm:learningObjectives[*]" mode="infoblock"/>
			</xsl:if>
		</objectives>
	</xsl:template>
	
	<xsl:template name="course-totalDurationOfCM">
		<xsl:if test="cdmfr:credits/cdmfr:globalVolume[@teachingtype='CM' and text() > 0]">
            <coursePart>
                <title>CM</title>
                <nature>CM</nature>
                <nbHours><xsl:value-of select="cdmfr:credits/cdmfr:globalVolume[@teachingtype='CM']"/></nbHours>
                <courseHolder><xsl:value-of select="@id"/></courseHolder>
            </coursePart>
		</xsl:if>
	</xsl:template>
	
	<xsl:template name="course-totalDurationOfTD">
		<xsl:if test="cdmfr:credits/cdmfr:globalVolume[@teachingtype='TD' and text() > 0]">
            <coursePart>
                <title>TD</title>
                <nature>TD</nature>
                <nbHours><xsl:value-of select="cdmfr:credits/cdmfr:globalVolume[@teachingtype='TD']"/></nbHours>
                <courseHolder><xsl:value-of select="@id"/></courseHolder>
            </coursePart>
		</xsl:if>
	</xsl:template>
	
	<xsl:template name="course-totalDurationOfTP">
		<xsl:if test="cdmfr:credits/cdmfr:globalVolume[@teachingtype='TP' and text() > 0]">
            <coursePart>
                <title>TP</title>
                <nature>TP</nature>
                <nbHours><xsl:value-of select="cdmfr:credits/cdmfr:globalVolume[@teachingtype='TP']"/></nbHours>
                <courseHolder><xsl:value-of select="@id"/></courseHolder>
            </coursePart>
		</xsl:if>
	</xsl:template>
	
	<xsl:template name="course-neededPrerequisite">
		<neededPrerequisite>
			<xsl:if test="cdm:formalPrerequisites/*">
				<xsl:apply-templates select="cdm:formalPrerequisites[*]" mode="infoblock"/>
			</xsl:if>
		</neededPrerequisite>
	</xsl:template>
	
	<xsl:template name="course-formOfAssessment">
		<formOfAssessment>
			<xsl:if test="cdm:formOfAssessment/*">
				<xsl:apply-templates select="cdm:formOfAssessment[*]" mode="infoblock"/>
			</xsl:if>
		</formOfAssessment>
	</xsl:template>
	
	<xsl:template name="course-syllabus">
		<syllabus>
			<xsl:if test="cdm:syllabus/*[not(local-name()='webLink' and @role='learningObjectMetadata')]">
				<xsl:apply-templates select="cdm:syllabus[*]" mode="infoblock"/>
			</xsl:if>
		</syllabus>
		<xsl:if test="cdm:syllabus/cdm:webLink[@role='learningObjectMetadata']">
			<lomSheets>
				<xsl:for-each select="cdm:syllabus/cdm:webLink[@role='learningObjectMetadata']">
                    <item name="{position()}">
						<linkUrl><xsl:value-of select="cdm:href"/></linkUrl>
						<linkLabel><xsl:value-of select="cdm:linkName"/></linkLabel>
					</item>
				</xsl:for-each>
			</lomSheets>
		</xsl:if>
	</xsl:template>
	
	<xsl:template name="course-additionalInformations">
		<additionalInformations>
			<xsl:if test="cdm:infoBlock/*">
				<xsl:apply-templates select="cdm:infoBlock[*]" mode="infoblock"/>
			</xsl:if>
		</additionalInformations>
	</xsl:template>
	
	<xsl:template name="course-title">
		<xsl:if test="cdm:courseName/cdm:text">
			<title><xsl:value-of select="cdm:courseName/cdm:text"/></title>
		</xsl:if>
	</xsl:template>
	
	<xsl:template name="course-cdmCode">
		<xsl:if test="cdm:courseCode">
			<cdmCode><xsl:value-of select="cdm:courseCode"/></cdmCode>
		</xsl:if>
	</xsl:template>
	
	<xsl:template name="course-erasmusCode">
		<xsl:if test="@ident">
			<erasmusCode><xsl:value-of select="@ident"/></erasmusCode>
		</xsl:if>
	</xsl:template>
	
	<xsl:template name="course-orgUnit">
		<xsl:choose>
			<xsl:when test="$import-root-orgunit-only = 'true'">
				<orgUnit>
					<item><xsl:call-template name="root-orgunit-id"/></item>
				</orgUnit>
			</xsl:when>
			<xsl:otherwise>
				<orgUnit>
					<xsl:for-each select="cdm:contacts/cdm:refOrgUnit">
						<item><xsl:value-of select="@idRef"/></item>
					</xsl:for-each>
				</orgUnit>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template name="course-teachingLocation">
		<teachingLocation>
			<xsl:for-each select="cdm:teachingPlace/cdm:adr/cdm:pcode">
				<item><xsl:value-of select="."/></item>
			</xsl:for-each>
		</teachingLocation>
	</xsl:template>
	
	<xsl:template name="course-contacts">
        <xsl:if test="cdm:contacts/cdm:refPerson">
            <xsl:variable name="contacts">
                <contacts>
                    <xsl:for-each select="cdm:contacts/cdm:refPerson[not(preceding-sibling::*/@role = @role)]">
                        <xsl:variable name="role" select="@role"/>
                        <entry>
                            <role><xsl:value-of select="$role"/></role>
                            <persons>
                                <xsl:for-each select="../cdm:refPerson[@role = $role]">
                                    <item><xsl:value-of select="@idRef"/></item>
                                </xsl:for-each>
                            </persons>
                        </entry>
                    </xsl:for-each>
                </contacts>
            </xsl:variable>
            
            <contacts>
                <xsl:for-each select="exsl:node-set($contacts)/contacts/entry">
                    <entry name="{position()}">
                        <xsl:copy-of select="*"/>
                    </entry>
                </xsl:for-each>
            </contacts>
        </xsl:if>
    </xsl:template>
	
	<xsl:template name="course-ects">
		<xsl:if test="cdmfr:credits/@ECTScredits">
			<ects><xsl:value-of select="cdmfr:credits/@ECTScredits"/></ects>
		</xsl:if>
	</xsl:template>
	
	<xsl:template name="course-nbHours">
		<xsl:variable name="nbHours" select="cms:getNbHours(cdmfr:credits/@totalWorkLoad)"/>
		<xsl:if test="$nbHours">
            <nbHours><xsl:value-of select="$nbHours"/></nbHours>
		</xsl:if>
	</xsl:template>
	
	<xsl:template name="course-maxNumberOfStudents">
		<xsl:if test="cdm:admissionInfo/cdm:studentPlaces">
			<maxNumberOfStudents><xsl:value-of select="cdm:admissionInfo/cdm:studentPlaces/@places"/></maxNumberOfStudents>
		</xsl:if>
	</xsl:template>

	<xsl:template name="course-teachingTerm">
		<xsl:if test="cdm:teachingTerm/@term">
			<teachingTerm><xsl:value-of select="cdm:teachingTerm/@term"/></teachingTerm>
		</xsl:if>
	</xsl:template>
	
	<xsl:template name="course-timeSlot">
		<xsl:if test="cdm:teachingTerm/@timeOfDay">
			<timeSlot><xsl:value-of select="cdm:teachingTerm/@timeOfDay"/></timeSlot>
		</xsl:if>
	</xsl:template>
	
	<xsl:template name="course-level">
		<xsl:if test="cdm:level/@level">
			<level><xsl:value-of select="cdm:level/@level"/></level>
		</xsl:if>
	</xsl:template>
	
	<xsl:template name="course-formofteachingMethod">
		<xsl:if test="cdm:formOfTeaching/@method">
			<formofteachingMethod><xsl:value-of select="cdm:formOfTeaching/@method"/></formofteachingMethod>
		</xsl:if>
	</xsl:template>
	
	<xsl:template name="course-formofteachingOrg">
		<xsl:if test="cdm:formOfTeaching/@org">
			<formofteachingOrg><xsl:value-of select="cdm:formOfTeaching/@org"/></formofteachingOrg>
		</xsl:if>
	</xsl:template>
	
	<xsl:template name="course-teachingActivity">
		<xsl:if test="cdm:teachingActivity/@method">
			<teachingActivity><xsl:value-of select="cdm:teachingActivity/@method"/></teachingActivity>
		</xsl:if>
	</xsl:template>
	
	<xsl:template name="course-teachingLanguage">
        <teachingLanguage>
            <xsl:for-each select="cdm:instructionLanguage">
                <item><xsl:value-of select="@teachingLang"/></item>
    		</xsl:for-each>
        </teachingLanguage>
	</xsl:template>
	
	<xsl:template name="course-startDate">
		<xsl:if test="cdm:admissionInfo/cdm:teachingStart">
			<startDate><xsl:value-of select="cdm:admissionInfo/cdm:teachingStart/@date"/></startDate>
		</xsl:if>
	</xsl:template>
	
	<xsl:template name="course-keywords">
		<keywords>
			<xsl:for-each select="cdm:searchword">
				<item multiple="true"><xsl:value-of select="."/></item>
			</xsl:for-each>
		</keywords>
	</xsl:template>
	
	<xsl:template name="course-webLinkLabel">
		<xsl:if test="cdmfr:webLink/cdmfr:linkName">
			<webLinkLabel><xsl:value-of select="cdmfr:webLink/cdmfr:linkName"/></webLinkLabel>
		</xsl:if>
	</xsl:template>
	
	<xsl:template name="course-webLinkUrl">
		<xsl:if test="cdmfr:webLink/cdm:href">
			<webLinkUrl><xsl:value-of select="cdmfr:webLink/cdm:href"/></webLinkUrl>
		</xsl:if>
	</xsl:template>
	
	<xsl:template name="course-coursesReferences">
        <xsl:for-each select="cdm:courseDescription/cdmfr:courseContentsEC[cdmfr:refCourse/@idRef]">
            <coursesReferences name="{cdm:infoBlock[@userDefined = 'listName']}" code="{cdm:infoBlock[@userDefined = 'listCode']}" choiceType="{cdm:infoBlock[@userDefined = 'listChoiceType']}">
                <xsl:if test="cdm:infoBlock[@userDefined = 'listMinNumberOfCourses']">
                    <xsl:attribute name="min"><xsl:value-of select="cdm:infoBlock[@userDefined = 'listMinNumberOfCourses']"/></xsl:attribute>
                </xsl:if>
                <xsl:if test="cdm:infoBlock[@userDefined = 'listMaxNumberOfCourses']">
                    <xsl:attribute name="max"><xsl:value-of select="cdm:infoBlock[@userDefined = 'listMaxNumberOfCourses']"/></xsl:attribute>
                </xsl:if>
                <xsl:for-each select="cdmfr:refCourse">
                    <item><xsl:value-of select="@idRef"/></item>
                </xsl:for-each>
            </coursesReferences>
        </xsl:for-each>
	</xsl:template>
    
    <!-- Template to override in order to add customized fields -->
    <xsl:template name="course-additionalFields"/>
</xsl:stylesheet>
