/*
 *  Copyright 2018 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.odfsync.cdmfr.components.impl;

import java.io.IOException;
import java.util.Map;

import org.apache.cocoon.ProcessingException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

import org.ametys.plugins.odfsync.cdmfr.RemoteCDMFrSynchronizableContentsCollection;
import org.ametys.plugins.odfsync.cdmfr.components.AbstractImportCDMFrComponent;

/**
 * Component to import a CDM-fr input stream from a remote server.
 */
public class RemoteImportCDMFrComponent extends AbstractImportCDMFrComponent
{
    /** Avalon Role */
    @SuppressWarnings("hiding")
    public static final String ROLE = RemoteImportCDMFrComponent.class.getName();
    
    /** Forced catalog */
    protected String _forcedCatalog;

    /** Validate after import */
    protected boolean _validateAfterImport;
    
    @Override
    protected void additionalParameters(Map<String, Object> parameters)
    {
        _forcedCatalog = (String) parameters.getOrDefault(RemoteCDMFrSynchronizableContentsCollection.PARAM_CDMFR_CATALOG, null);
        _validateAfterImport = (boolean) parameters.getOrDefault(RemoteCDMFrSynchronizableContentsCollection.PARAM_CDMFR_VALIDATE_AFTER_IMPORT, false);
    }
    
    @Override
    public String getCatalogName(Element contentElement)
    {
        if (StringUtils.isNotEmpty(_forcedCatalog))
        {
            return _forcedCatalog;
        }
        
        return super.getCatalogName(contentElement);
    }
    
    @Override
    protected Document transformDocument(Document document, Map<String, Object> parameters, Logger logger) throws IOException, SAXException, ProcessingException
    {
        parameters.put("importRootOrgUnitOnly", true);
        return super.transformDocument(document, parameters, logger);
    }

    @Override
    protected boolean validateAfterImport()
    {
        return _validateAfterImport;
    }

    @Override
    protected boolean removalSync()
    {
        return true;
    }
    
    @Override
    protected boolean ignoreRights()
    {
        return true;
    }
}
