/*
 *  Copyright 2021 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/*
 * This script migrates the config files for CDM-fr import
 * (replace occurences of 'metadata' by 'attribute')
 */

let requiresRestart = Ametys.utils.searchAndReplace("context://WEB-INF/param/odf-synchro.xml", /metadata/g, "attribute");

let coAccreditedURI = "context://WEB-INF/param/co-accredited.xml";
if (Ametys.utils.exists(coAccreditedURI))
{
    requiresRestart = Ametys.utils.searchAndReplace(coAccreditedURI, /metadata-to-copy/g, "attributes-to-copy") || requiresRestart;
    requiresRestart = Ametys.utils.searchAndReplace(coAccreditedURI, /metadata-to-merge/g, "attributes-to-merge") || requiresRestart;
    requiresRestart = Ametys.utils.searchAndReplace(coAccreditedURI, /metadata-ref/g, "attribute-ref") || requiresRestart;
}

if (requiresRestart)
{
    actionData.setRequiresRestart(true);
}
