<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2012 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:cdm="http://cdm-fr.fr/2013/CDM"
	xmlns:cdmfr="http://cdm-fr.fr/2013/CDM-frSchema"
	xmlns:ametys-cdm="http://www.ametys.org/cdm/1.0"
    xmlns:exsl="http://exslt.org/common"
	exclude-result-prefixes="cdm cdmfr ametys-cdm exsl">
	
	<!-- Identifiant CDM -->
	<xsl:template name="program-CDMid">
		<xsl:attribute name="CDMid"><xsl:value-of select="@id"/></xsl:attribute>
	</xsl:template>
	
	<!-- Language -->
	<xsl:template name="program-language">
		<xsl:if test="@language">
			<xsl:attribute name="language"><xsl:value-of select="@language"/></xsl:attribute>
		</xsl:if>
	</xsl:template>
	
	<!-- Catalogue -->
	<xsl:template name="program-catalog">
		<xsl:if test="cdm:infoBlock[@userDefined = 'ametys-extension']/cdm:extension/ametys-cdm:catalog">
			<catalog><xsl:value-of select="cdm:infoBlock[@userDefined = 'ametys-extension']/cdm:extension/ametys-cdm:catalog/@value"/></catalog>
		</xsl:if>
	</xsl:template>
    
    <!-- Certification -->
    <xsl:template name="program-certified">
        <certified><xsl:value-of select="count(cdm:infoBlock[@userDefined = 'ametys-extension']/cdm:extension/ametys-cdm:certified) > 0"/></certified>
    </xsl:template>
	
	<!-- Présentation -->
	<xsl:template name="program-presentation">
		<presentation>
			<xsl:apply-templates select="cdmfr:programDescription/cdm:infoBlock[*]" mode="infoblock"/>
		</presentation>
	</xsl:template>
	
	<!-- Objectifs -->
	<xsl:template name="program-objectives">
		<objectives>
			<xsl:if test="cdm:learningObjectives/*">
				<xsl:apply-templates select="cdm:learningObjectives[*]" mode="infoblock"/>
			</xsl:if>
		</objectives>
	</xsl:template>
	
	<!-- Savoir-faire et compétences -->
	<xsl:template name="program-qualification">
		<qualification>
			<xsl:if test="cdm:qualification/cdmfr:qualificationDescription/cdm:infoBlock/*">
				<xsl:apply-templates select="cdm:qualification/cdmfr:qualificationDescription/cdm:infoBlock[*]" mode="infoblock"/>
			</xsl:if>
		</qualification>
	</xsl:template>
	
	<!-- Organisation -->
	<xsl:template name="program-teachingOrganization">
		<teachingOrganization>
			<xsl:if test="cdmfr:programStructure[not(cdmfr:refCourse)]/cdm:infoBlock/*">
				<xsl:apply-templates select="cdmfr:programStructure[not(cdmfr:refCourse)]/cdm:infoBlock[*]" mode="infoblock"/>
			</xsl:if>
		</teachingOrganization>
	</xsl:template>
	
	<!-- Condition d'admission -->
	<xsl:template name="program-accessCondition">
		<accessCondition>
			<xsl:if test="cdm:admissionInfo/cdmfr:admissionDescription/*">
				<xsl:apply-templates select="cdm:admissionInfo/cdmfr:admissionDescription[*]" mode="infoblock"/>
			</xsl:if>
		</accessCondition>
	</xsl:template>
    
    <!-- Dates inscriptions -->
    <xsl:template name="program-registration">
        <registrationStart><xsl:value-of select="cdm:admissionInfo/cdmfr:registrationDetail/cdm:registrationStart/@date"/></registrationStart>
        <registrationDeadline><xsl:value-of select="cdm:admissionInfo/cdm:registrationDeadline/@date"/></registrationDeadline>
    </xsl:template>
    
    <!-- Début de la formation -->
    <xsl:template name="program-teachingStart">
        <teachingStart><xsl:value-of select="cdm:admissionInfo/cdm:teachingStart/@date"/></teachingStart>
    </xsl:template>
    
    <!-- Fin de la formation -->
    <xsl:template name="program-teachingEnd">
        <teachingEnd><xsl:value-of select="cdm:infoBlock[@userDefined = 'ametys-extension']/cdm:extension/ametys-cdm:teachingEnd/@date"/></teachingEnd>
    </xsl:template>
	
	<!-- ¨Pré-requis nécessaires -->
	<xsl:template name="program-neededPrerequisite">
		<neededPrerequisite>
			<xsl:if test="cdm:formalPrerequisites/*">
				<xsl:apply-templates select="cdm:formalPrerequisites[*]" mode="infoblock"/>
			</xsl:if>
		</neededPrerequisite>
	</xsl:template>
	
	<!-- ¨Pré-requis recommandés -->
	<xsl:template name="program-recommendedPrerequisite">
		<recommendedPrerequisite>
			<xsl:if test="cdm:recommendedPrerequisites/*">
				<xsl:apply-templates select="cdm:recommendedPrerequisites[*]" mode="infoblock"/>
			</xsl:if>
		</recommendedPrerequisite>
	</xsl:template>
	
	<!-- Poursuite d'étude -->
	<xsl:template name="program-furtherStudy">
		<furtherStudy>
			<xsl:if test="cdm:qualification/cdmfr:studyQualification/cdm:infoBlock/*">
				<xsl:apply-templates select="cdm:qualification/cdmfr:studyQualification/cdm:infoBlock[*]" mode="infoblock"/>
			</xsl:if>
		</furtherStudy>
	</xsl:template>
	
	<!-- Poursuite d'études à l'étranger -->
	<xsl:template name="program-studyAbroad">
		<studyAbroad>
			<xsl:if test="cdm:studyAbroad/*">
				<xsl:apply-templates select="cdm:studyAbroad[*]" mode="infoblock"/>
			</xsl:if>
		</studyAbroad>
	</xsl:template>
	
	<!-- Public cible -->
	<xsl:template name="program-targetGroup">
		<targetGroup>
			<xsl:if test="cdm:targetGroup/*">
				<xsl:apply-templates select="cdm:targetGroup[*]" mode="infoblock"/>
			</xsl:if>
		</targetGroup>
	</xsl:template>
	
	<!-- Insertion professionnelle -->
	<xsl:template name="program-jobOpportunities">
		<jobOpportunities>
			<xsl:if test="cdm:qualification/cdmfr:profession/cdm:infoBlock/*">
				<xsl:apply-templates select="cdm:qualification/cdmfr:profession/cdm:infoBlock[*]" mode="infoblock"/>
			</xsl:if>
		</jobOpportunities>
	</xsl:template>
	
	<!-- Stage -->
	<xsl:template name="program-trainingStrategy">
		<trainingStrategy>
			<xsl:if test="/cdm:CDM/cdmfr:habilitation/cdmfr:partnership/cdmfr:training/cdmfr:trainingStrategy/*">
				<xsl:apply-templates select="/cdm:CDM/cdmfr:habilitation/cdmfr:partnership/cdmfr:training/cdmfr:trainingStrategy[*]" mode="infoblock"/>
			</xsl:if>
		</trainingStrategy>
	</xsl:template>
    
    <!-- AMETYS : Stages -->
    <xsl:template name="program-trainingInfo">
        <internship><xsl:value-of select="cdm:infoBlock[@userDefined = 'ametys-extension']/cdm:extension/ametys-cdm:training/ametys-cdm:trainingInfo/@value"/></internship>
        <internshipDuration><xsl:value-of select="cdm:infoBlock[@userDefined = 'ametys-extension']/cdm:extension/ametys-cdm:training/ametys-cdm:trainingDuration"/></internshipDuration>
        <internshipAbroad><xsl:value-of select="cdm:infoBlock[@userDefined = 'ametys-extension']/cdm:extension/ametys-cdm:training/ametys-cdm:trainingAbroadInfo/@value"/></internshipAbroad>
        <internshipAbroadDuration><xsl:value-of select="cdm:infoBlock[@userDefined = 'ametys-extension']/cdm:extension/ametys-cdm:training/ametys-cdm:trainingAbroadDuration"/></internshipAbroadDuration>
    </xsl:template>
	
	<!-- Contrôle des connaissance -->
	<xsl:template name="program-knowledgeCheck">
		<knowledgeCheck>
			<xsl:if test="cdm:qualification/cdmfr:credits/cdm:infoBlock/*">
				<xsl:apply-templates select="cdm:qualification/cdmfr:credits/cdm:infoBlock[*]" mode="infoblock"/>
			</xsl:if>
		</knowledgeCheck>
	</xsl:template>
	
	<!-- Aménagement particulier -->
	<xsl:template name="program-universalAdjustment">
		<universalAdjustment>
			<xsl:if test="cdm:universalAdjustment/*">
				<xsl:apply-templates select="cdm:universalAdjustment[*]" mode="infoblock"/>
			</xsl:if>
		</universalAdjustment>
	</xsl:template>
	
	<!-- Information complémentaire -->
	<xsl:template name="program-additionalInformations">
		<additionalInformations>
			<xsl:if test="cdm:infoBlock[not(@userDefined = 'ametys-extension')]/*">
				<xsl:apply-templates select="cdm:infoBlock[not(@userDefined = 'ametys-extension')][*]" mode="infoblock"/>
			</xsl:if>
		</additionalInformations>
	</xsl:template>
	
	<!-- AMETYS : Passerelle et ré-orientation -->
    <xsl:template name="program-reorientation">
        <reorientation>
            <xsl:if test="cdm:infoBlock[@userDefined = 'ametys-extension']/cdm:extension/ametys-cdm:reorientation/*">
                <xsl:apply-templates select="cdm:infoBlock[@userDefined = 'ametys-extension']/cdm:extension/ametys-cdm:reorientation[*]" mode="infoblock"/>
            </xsl:if>
        </reorientation>
    </xsl:template>
	
	<!-- Droits de scolarités -->
	<xsl:template name="program-expenses">
		<expenses>
			<xsl:if test="cdm:expenses/*">
				<xsl:apply-templates select="cdm:expenses[*]" mode="infoblock"/>
			</xsl:if>
		</expenses>
	</xsl:template>
	
	<!-- Domaine ministeriel-->
	<xsl:template name="program-domain">
        <domain>
            <xsl:for-each select="/cdm:CDM/cdmfr:habilitation/cdmfr:cohabilitation/cdmfr:listOfOrgUnit/cdmfr:habOrgUnit/cdmfr:domainName">
                <item><xsl:value-of select="cdmfr:fixedDomain|cdmfr:openDomain"/></item>
            </xsl:for-each>
        </domain>
	</xsl:template>

	<!-- RNCP Code -->
	<xsl:template name="program-rncpCode">
		<rncpCode>
			<xsl:for-each select="cdm:infoBlock[@userDefined = 'ametys-extension']/cdm:extension/ametys-cdm:rncpCode">
				<item><xsl:value-of select="."/></item>
			</xsl:for-each>
		</rncpCode>
	</xsl:template>
	
	<!-- RNCP Level -->
    <xsl:template name="program-rncpLevel">
        <rncpLevel>
            <xsl:value-of select="cdm:infoBlock[@userDefined = 'ametys-extension']/cdm:extension/ametys-cdm:rncpLevel/@value"/>
        </rncpLevel>
    </xsl:template>
    
    <!-- NSF Code -->
    <xsl:template name="program-nsfCode">
        <nsfCode>
            <xsl:value-of select="cdmfr:programCode[@codeSet='codeCNIS-NSF']"/>
        </nsfCode>
    </xsl:template>
	
	<!-- SISE Code -->
	<xsl:template name="program-dgesipCode">
		<dgesipCode>
			<xsl:for-each select="cdmfr:programCode[@codeSet='sectDGESIP']">
				<item><xsl:value-of select="."/></item>
			</xsl:for-each>
		</dgesipCode>
	</xsl:template>
	
	<!-- SISE Code -->
	<xsl:template name="program-siseCode">
		<siseCode>
			<xsl:for-each select="cdmfr:programCode[@codeSet='sectDiscipSISE']">
				<item><xsl:value-of select="."/></item>
			</xsl:for-each>
		</siseCode>
	</xsl:template>
	
	<!-- CITE97 Code -->
	<xsl:template name="program-cite97Code">
		<cite97Code>
			<xsl:for-each select="cdmfr:programCode[@codeSet='cite97']">
				<item><xsl:value-of select="."/></item>
			</xsl:for-each>
		</cite97Code>
	</xsl:template>
	
	<!-- Erasmus Code -->
	<xsl:template name="program-erasmusCode">
		<erasmusCode>
			<xsl:for-each select="cdmfr:programCode[@codeSet='ERASMUS']">
				<item><xsl:value-of select="."/></item>
			</xsl:for-each>
		</erasmusCode>
	</xsl:template>
	
	<!-- ROME Code -->
	<xsl:template name="program-romeCode">
		<romeCode>
			<xsl:for-each select="cdm:qualification/cdmfr:profession/cdmfr:romeData[@romeCode]">
				<item><xsl:value-of select="@romeCode"/></item>
			</xsl:for-each>
		</romeCode>
	</xsl:template>
    
    <!-- FAP Code -->
    <xsl:template name="program-fapCode">
        <fapCode>
            <xsl:for-each select="cdmfr:programCode[@codeSet='FAP']">
                <item><xsl:value-of select="."/></item>
            </xsl:for-each>
        </fapCode>
    </xsl:template>
	
	<!-- Code -->
	<xsl:template name="program-code">
		<xsl:if test="cdmfr:programCode[@codeSet='userDefined']">
			<code><xsl:value-of select="cdmfr:programCode[@codeSet='userDefined']"/></code>
		</xsl:if>
	</xsl:template>
	
	<!-- CDM Code -->
	<xsl:template name="program-cdmCode">
		<xsl:if test="cdm:programID">
			<cdmCode><xsl:value-of select="cdm:programID"/></cdmCode>
		</xsl:if>
	</xsl:template>
	
	<!-- Titre -->
	<xsl:template name="program-title">
		<xsl:if test="cdmfr:programName/cdmfr:text">
			<title><xsl:value-of select="cdmfr:programName/cdmfr:text"/></title>
		</xsl:if>
	</xsl:template>
	
	<!-- Mention -->
	<xsl:template name="program-mention">
        <mention>
            <xsl:choose>
                <xsl:when test="/cdm:CDM/cdmfr:habilitation/cdmfr:field/cdmfr:fieldName/cdmfr:controlled/@fieldNameCode">
                    <xsl:value-of select="/cdm:CDM/cdmfr:habilitation/cdmfr:field/cdmfr:fieldName/cdmfr:controlled/@fieldNameCode"/>
                </xsl:when>
                <xsl:when test="/cdm:CDM/cdmfr:habilitation/cdmfr:field/cdmfr:fieldName/cdmfr:controlled">
                    <xsl:value-of select="/cdm:CDM/cdmfr:habilitation/cdmfr:field/cdmfr:fieldName/cdmfr:controlled/cdmfr:registeredName"/>
                </xsl:when>
                <xsl:when test="/cdm:CDM/cdmfr:habilitation/cdmfr:field/cdmfr:fieldName/cdmfr:free">
                    <xsl:value-of select="/cdm:CDM/cdmfr:habilitation/cdmfr:field/cdmfr:fieldName/cdmfr:free"/>
                </xsl:when>
            </xsl:choose>
        </mention>
	</xsl:template>
	
	<!-- Spécialité -->
	<xsl:template name="program-speciality">
		<speciality><xsl:value-of select="/cdm:CDM/cdmfr:habilitation/cdmfr:field/cdmfr:speciality/cdmfr:specialityName|/cdm:CDM/cdmfr:habilitation/cdmfr:licPro/cdmfr:specialite/cdm:text"/></speciality>
	</xsl:template>
	
	<!-- Niveau d'étude -->
	<xsl:template name="program-educationLevel">
	   <educationLevel><xsl:value-of select="cdm:levelCode/@codeSet"/></educationLevel>
	</xsl:template>
	
	<!-- Diplome -->
	<xsl:template name="program-degree">
		<xsl:choose>
			<xsl:when test="cdm:qualification/cdmfr:degree/@degree">
				<degree><xsl:value-of select="cdm:qualification/cdmfr:degree/@degree"/></degree>
			</xsl:when>
			<xsl:when test="cdm:qualification/cdmfr:degree/@degreeNotLMD">
				<degree><xsl:value-of select="cdm:qualification/cdmfr:degree/@degreeNotLMD"/></degree>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	
	<!-- Etablissements cohabilités -->
	<xsl:template name="program-jointOrgUnit">
		<jointOrgUnit>
			<xsl:if test="/cdm:CDM/cdmfr:habilitation/cdmfr:cohabilitation/cdmfr:listOfOrgUnit[@cohabilitationRole= 'cohabilité']/cdmfr:habOrgUnit">
				<xsl:for-each select="/cdm:CDM/cdmfr:habilitation/cdmfr:cohabilitation/cdmfr:listOfOrgUnit[@cohabilitationRole= 'cohabilité']/cdmfr:habOrgUnit">
					<item><xsl:value-of select="cdmfr:refOrgUnit"/></item>
				</xsl:for-each>
			</xsl:if>
		</jointOrgUnit>
	</xsl:template>
	
	<!-- Composantes -->
	<xsl:template name="program-orgUnit">
		<xsl:choose>
			<xsl:when test="$import-root-orgunit-only = 'true'">
				<orgUnit>
					<item><xsl:call-template name="root-orgunit-id"/></item>
				</orgUnit>
			</xsl:when>
			<xsl:otherwise>
				<orgUnit>
					<xsl:for-each select="cdm:contacts/cdm:refOrgUnit">
						<item><xsl:value-of select="@idRef"/></item>
					</xsl:for-each>
				</orgUnit>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<!-- Lieux -->
	<xsl:template name="program-place">
		<place>
			<xsl:for-each select="cdm:teachingPlace[cdm:adr/cdm:pcode]">
				<item><xsl:value-of select="cdm:adr/cdm:pcode"/></item>
			</xsl:for-each>
		</place>
	</xsl:template>
	
	<!-- Contacts -->
    <xsl:template name="program-contacts">
        <xsl:if test="cdm:contacts/cdm:refPerson">
            <xsl:variable name="contacts">
                <contacts>
                    <xsl:for-each select="cdm:contacts/cdm:refPerson[not(preceding-sibling::*/@role = @role)]">
                        <xsl:variable name="role" select="@role"/>
                        <entry>
                            <role><xsl:value-of select="$role"/></role>
                            <persons>
                                <xsl:for-each select="../cdm:refPerson[@role = $role]">
                                    <item><xsl:value-of select="@idRef"/></item>
                                </xsl:for-each>
                            </persons>
                        </entry>
                    </xsl:for-each>
                </contacts>
            </xsl:variable>
            
            <contacts>
                <xsl:for-each select="exsl:node-set($contacts)/contacts/entry">
                    <entry name="{position()}">
                        <xsl:copy-of select="*"/>
                    </entry>
                </xsl:for-each>
            </contacts>
        </xsl:if>
    </xsl:template>
	
    <xsl:template name="program-website">
        <programWebSite>
            <xsl:if test="cdmfr:webLink/cdm:href != '' or cdmfr:webLink/cdmfr:linkName != ''">
                <entry name="1">
                    <programWebSiteUrl><xsl:value-of select="cdmfr:webLink/cdm:href"/></programWebSiteUrl>
                    <programWebSiteLabel><xsl:value-of select="cdmfr:webLink/cdmfr:linkName"/></programWebSiteLabel>
                </entry>
            </xsl:if>
        </programWebSite>
    </xsl:template>
    
	<!-- Taux de réusssite -->
	<xsl:template name="program-successRate">
	   <successRate><xsl:value-of select="cdm:qualification/cdmfr:qualificationDescription/cdmfr:statistics"/></successRate>
	</xsl:template>
	
	<!-- Crédits ECTS -->
	<xsl:template name="program-ects">
	   <ects><xsl:value-of select="cdm:qualification/cdmfr:credits/@ECTScredits"/></ects>
	</xsl:template>
	
	<!-- Nature de la formation -->
	<xsl:template name="program-educationKind">
		<educationKind><xsl:value-of select="cdmfr:programDescription/@nature"/></educationKind>
	</xsl:template>
	
	<!-- Durée -->
	<xsl:template name="program-duration">
		<duration><xsl:value-of select="cdm:programDuration"/></duration>
	</xsl:template>
	
	<!-- Langue -->
	<xsl:template name="program-educationLanguage">
		<educationLanguage>
            <xsl:if test="cdmfr:ppalTeachingLanguage/@teachingLang">
                <item><xsl:value-of select="cdmfr:ppalTeachingLanguage/@teachingLang"/></item>
            </xsl:if>
        </educationLanguage>
	</xsl:template>
	
	<!-- Nombre d'étudiants -->
	<xsl:template name="program-numberOfStudents">
        <numberOfStudents><article version="5"><para><xsl:value-of select="cdm:admissionInfo/cdm:studentPlaces"/></para></article></numberOfStudents>
	</xsl:template>
	
    <!-- Organisation de l'enseignement -->
    <xsl:template name="program-formofteachingOrg">
        <formofteachingOrg>
            <xsl:for-each select="cdm:formOfTeaching/@org">
                <item><xsl:value-of select="."/></item>
            </xsl:for-each>
        </formofteachingOrg>
    </xsl:template>
    
	<!-- Formation a distance -->
	<xsl:template name="program-distanceLearning">
		<distanceLearning><xsl:value-of select="cdm:formOfTeaching/@method"/></distanceLearning>
	</xsl:template>
	
	
	<!-- Mots clés -->
    <xsl:template name="program-keywords">
        <keywords>
            <xsl:for-each select="cdm:searchword">
                <item multiple="true"><xsl:value-of select="."/></item>
            </xsl:for-each>
        </keywords>
    </xsl:template>
	
	<!-- AMETYS : Etablissements partenaires -->
	<xsl:template name="program-partnerSchools">
		<xsl:if test="cdm:infoBlock[@userDefined = 'ametys-extension']//cdm:extension/ametys-cdm:partnerSchools">
			<partnerSchools>
				<xsl:for-each select="cdm:infoBlock[@userDefined = 'ametys-extension']//cdm:extension/ametys-cdm:partnerSchools/ametys-cdm:partnerSchool">
					<entry name="{position()}">
						<linkUrl><xsl:value-of select="ametys-cdm:linkUrl"/></linkUrl>
						<linkLabel><xsl:value-of select="ametys-cdm:linkLabel"/></linkLabel>
					</entry>
				</xsl:for-each>
			</partnerSchools>
		</xsl:if>
	</xsl:template>
	
	<!-- AMETYS : Laboratoire partenaires -->
	<xsl:template name="program-partnerLaboratories">
		<xsl:if test="cdm:infoBlock[@userDefined = 'ametys-extension']/cdm:extension/ametys-cdm:partnerLaboratories">
			<partnerLaboratories>
				<xsl:for-each select="cdm:infoBlock[@userDefined = 'ametys-extension']/cdm:extension/ametys-cdm:partnerLaboratories/ametys-cdm:partnerLaboratory">
					<entry name="{position()}">
						<linkUrl><xsl:value-of select="ametys-cdm:linkUrl"/></linkUrl>
						<linkLabel><xsl:value-of select="ametys-cdm:linkLabel"/></linkLabel>
					</entry>
				</xsl:for-each>
			</partnerLaboratories>
		</xsl:if>
	</xsl:template>
	
	<!-- AMETYS : Fichiers attachés -->
	<xsl:template name="program-attachments">
		<xsl:if test="cdm:infoBlock[@userDefined = 'ametys-extension']/cdm:extension/ametys-cdm:attachments">
			<attachments>
				<xsl:for-each select="cdm:infoBlock[@userDefined = 'ametys-extension']/cdm:extension/ametys-cdm:attachments/ametys-cdm:attachment">
					<entry name="{position()}">
						<attachment><xsl:value-of select="ametys-cdm:href"/></attachment>
						<attachment-text><xsl:value-of select="ametys-cdm:text"/></attachment-text>
					</entry>
				</xsl:for-each>
			</attachments>
		</xsl:if>
	</xsl:template>
	
	<!-- Structure -->
	<xsl:template name="program-structure">
		<!-- Courses lists -->
		<xsl:for-each select="cdmfr:programStructure[cdmfr:refCourse]">
			<coursesReferences name="{cdm:infoBlock[@userDefined = 'listName']}" code="{cdm:infoBlock[@userDefined = 'listCode']}" choiceType="{cdm:infoBlock[@userDefined = 'listChoiceType']}">
				<xsl:if test="cdm:infoBlock[@userDefined = 'listMinNumberOfCourses']">
					<xsl:attribute name="min"><xsl:value-of select="cdm:infoBlock[@userDefined = 'listMinNumberOfCourses']"/></xsl:attribute>
				</xsl:if>
				<xsl:if test="cdm:infoBlock[@userDefined = 'listMaxNumberOfCourses']">
					<xsl:attribute name="max"><xsl:value-of select="cdm:infoBlock[@userDefined = 'listMaxNumberOfCourses']"/></xsl:attribute>
				</xsl:if>
				<xsl:for-each select="cdmfr:refCourse">
					<item><xsl:value-of select="@idRef"/></item>
				</xsl:for-each>
			</coursesReferences>
		</xsl:for-each>
	</xsl:template>
	
	<xsl:template name="program-subProgram">
		<xsl:for-each select="cdm:subProgram[cdm:infoBlock/@userDefined = 'subProgram']">
			<subProgram>
				<xsl:call-template name="program-parse"/>
			</subProgram>
		</xsl:for-each>
		<xsl:for-each select="cdm:subProgram[cdm:infoBlock/@userDefined = 'container']">
			<container>
				<xsl:call-template name="program-parse"/>
			</container>
		</xsl:for-each>
	</xsl:template>
    
    <!-- Template to override in order to add customized fields -->
    <xsl:template name="program-additionalFields"/>
</xsl:stylesheet>
