/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfsync.apogee.scc;

import com.google.common.base.CharMatcher;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Clob;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ametys.cms.contenttype.ContentType;
import org.ametys.cms.data.ContentValue;
import org.ametys.cms.repository.Content;
import org.ametys.cms.repository.ModifiableContent;
import org.ametys.core.schedule.progression.ContainerProgressionTracker;
import org.ametys.core.schedule.progression.ProgressionTrackerFactory;
import org.ametys.core.util.JSONUtils;
import org.ametys.odf.ODFHelper;
import org.ametys.odf.cdmfr.CDMFRHandler;
import org.ametys.plugins.contentio.synchronize.AbstractSimpleSynchronizableContentsCollection;
import org.ametys.plugins.contentio.synchronize.SynchronizableContentsCollection;
import org.ametys.plugins.odfsync.apogee.ApogeeDAO;
import org.ametys.plugins.odfsync.apogee.scc.ApogeeCriterion;
import org.ametys.plugins.odfsync.apogee.scc.ApogeeSynchronizableContentsCollection;
import org.ametys.plugins.odfsync.apogee.scc.ApogeeSynchronizableContentsCollectionHelper;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.ModelItem;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfigurationBuilder;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Context;
import org.apache.cocoon.environment.Request;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;

public abstract class AbstractApogeeSynchronizableContentsCollection
extends AbstractSimpleSynchronizableContentsCollection
implements Contextualizable,
ApogeeSynchronizableContentsCollection {
    public static final String PARAM_DATASOURCE_ID = "datasourceId";
    public static final String PARAM_YEAR = "year";
    public static final String PARAM_ADD_UNEXISTING_CHILDREN = "add-unexisting-children";
    public static final String PARAM_ADD_EXISTING_CHILDREN = "add-existing-children";
    protected static final String __PARAM_ID_COLUMN = "idColumn";
    protected static final String __PARAM_MAPPING = "mapping";
    protected static final String __PARAM_MAPPING_SYNCHRO = "synchro";
    protected static final String __PARAM_MAPPING_METADATA_REF = "metadata-ref";
    protected static final String __PARAM_MAPPING_ATTRIBUTE = "attribute";
    protected static final String __PARAM_CRITERIA = "criteria";
    protected static final String __PARAM_CRITERIA_CRITERION = "criterion";
    protected static final String __PARAM_CRITERIA_CRITERION_ID = "id";
    protected static final String __PARAM_CRITERIA_CRITERION_LABEL = "label";
    protected static final String __PARAM_CRITERIA_CRITERION_TYPE = "type";
    protected static final String __PARAM_COLUMNS = "columns";
    protected static final String __PARAM_COLUMNS_COLUMN = "column";
    protected Boolean _addUnexistingChildren;
    protected Boolean _addExistingChildren;
    protected String _idColumn;
    protected Map<String, List<String>> _mapping;
    protected Set<String> _syncFields;
    protected Set<String> _columns;
    protected Set<ApogeeCriterion> _criteria;
    protected org.apache.avalon.framework.context.Context _context;
    protected ApogeeDAO _apogeeDAO;
    protected JSONUtils _jsonUtils;
    protected ODFHelper _odfHelper;
    protected ApogeeSynchronizableContentsCollectionHelper _apogeeSCCHelper;
    protected CDMFRHandler _cdmfrHandler;

    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._apogeeDAO = (ApogeeDAO)((Object)manager.lookup(ApogeeDAO.ROLE));
        this._jsonUtils = (JSONUtils)manager.lookup(JSONUtils.ROLE);
        this._odfHelper = (ODFHelper)manager.lookup(ODFHelper.ROLE);
        this._apogeeSCCHelper = (ApogeeSynchronizableContentsCollectionHelper)manager.lookup(ApogeeSynchronizableContentsCollectionHelper.ROLE);
        this._cdmfrHandler = (CDMFRHandler)manager.lookup(CDMFRHandler.ROLE);
    }

    public void contextualize(org.apache.avalon.framework.context.Context context) throws ContextException {
        this._context = context;
    }

    protected void configureDataSource(Configuration configuration) throws ConfigurationException {
        try {
            Context ctx = (Context)this._context.get((Object)"environment-context");
            File apogeeMapping = new File(ctx.getRealPath("/WEB-INF/param/odf/apogee-mapping.xml"));
            try (InputStream is = apogeeMapping.isFile() ? new FileInputStream(apogeeMapping) : this.getClass().getResourceAsStream("/org/ametys/plugins/odfsync/apogee/apogee-mapping.xml");){
                Configuration cfg = new DefaultConfigurationBuilder().build(is);
                Configuration child = cfg.getChild(this.getMappingName());
                if (child != null) {
                    Configuration[] columns;
                    Configuration[] criteria;
                    this._criteria = new LinkedHashSet<ApogeeCriterion>();
                    this._columns = new LinkedHashSet<String>();
                    this._idColumn = child.getChild(__PARAM_ID_COLUMN).getValue();
                    this._mapping = new HashMap<String, List<String>>();
                    this._syncFields = new HashSet<String>();
                    String mappingAsString = child.getChild(__PARAM_MAPPING).getValue();
                    this._mapping.put(this.getIdField(), List.of(this.getIdColumn()));
                    if (StringUtils.isNotEmpty((String)mappingAsString)) {
                        List mappingAsList = this._jsonUtils.convertJsonToList(mappingAsString);
                        for (Object object : mappingAsList) {
                            Map field = (Map)object;
                            String metadataRef = (String)field.get(__PARAM_MAPPING_METADATA_REF);
                            String[] attributes = ((String)field.get(__PARAM_MAPPING_ATTRIBUTE)).split(",");
                            this._mapping.put(metadataRef, Arrays.asList(attributes));
                            boolean isSynchronized = field.containsKey(__PARAM_MAPPING_SYNCHRO) ? (Boolean)field.get(__PARAM_MAPPING_SYNCHRO) : false;
                            if (!isSynchronized) continue;
                            this._syncFields.add(metadataRef);
                        }
                    }
                    for (Configuration criterion : criteria = child.getChild(__PARAM_CRITERIA).getChildren(__PARAM_CRITERIA_CRITERION)) {
                        String id = criterion.getChild(__PARAM_CRITERIA_CRITERION_ID).getValue();
                        I18nizableText label = this._getCriterionLabel(criterion.getChild(__PARAM_CRITERIA_CRITERION_LABEL), id);
                        String type = criterion.getChild(__PARAM_CRITERIA_CRITERION_TYPE).getValue("STRING");
                        this._criteria.add(new ApogeeCriterion(id, label, type));
                    }
                    for (Configuration column : columns = child.getChild(__PARAM_COLUMNS).getChildren(__PARAM_COLUMNS_COLUMN)) {
                        this._columns.add(column.getValue());
                    }
                }
            }
        }
        catch (Exception e) {
            throw new ConfigurationException("Error while parsing apogee-mapping.xml", (Throwable)e);
        }
    }

    private I18nizableText _getCriterionLabel(Configuration configuration, String defaultValue) {
        if (configuration.getAttributeAsBoolean("i18n", false)) {
            return new I18nizableText("plugin.odf-sync", configuration.getValue(defaultValue));
        }
        return new I18nizableText(configuration.getValue(defaultValue));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ModifiableContent> populate(Logger logger, ContainerProgressionTracker progressionTracker) {
        boolean isRequestAttributeOwner = false;
        Request request = ContextHelper.getRequest((org.apache.avalon.framework.context.Context)this._context);
        try {
            if (request.getAttribute(ApogeeSynchronizableContentsCollectionHelper.HANDLED_CONTENTS) == null) {
                this._startHandleCDMFR();
                request.setAttribute(ApogeeSynchronizableContentsCollectionHelper.HANDLED_CONTENTS, new HashSet());
                isRequestAttributeOwner = true;
            }
            List list = super.populate(logger, progressionTracker);
            return list;
        }
        finally {
            if (isRequestAttributeOwner) {
                this._endHandleCDMFR(request);
                request.removeAttribute(ApogeeSynchronizableContentsCollectionHelper.HANDLED_CONTENTS);
            }
        }
    }

    protected List<ModifiableContent> _internalPopulate(Logger logger, ContainerProgressionTracker progressionTracker) {
        return this._importOrSynchronizeContents(Map.of("isGlobalSync", true), false, logger, progressionTracker);
    }

    protected Map<String, Map<String, Object>> internalSearch(Map<String, Object> searchParameters, int offset, int limit, List<Object> sort, Logger logger) {
        HashMap<String, Object> searchParams = new HashMap<String, Object>(searchParameters);
        if (offset > 0) {
            searchParams.put("__offset", offset);
        }
        if (limit < Integer.MAX_VALUE) {
            searchParams.put("__limit", offset + limit);
        }
        searchParams.put("__order", this._getSort(sort));
        List<Map<String, Object>> requestValues = this._search(searchParams, logger);
        Set<String> clobColumns = this.getClobColumns();
        if (!clobColumns.isEmpty()) {
            for (Map<String, Object> contentValues : requestValues) {
                String idValue = contentValues.get(this.getIdColumn()).toString();
                for (String clobKey : this.getClobColumns()) {
                    Optional<List> oldValues = Optional.of(clobKey).map(contentValues::get).map(obj -> (List)obj);
                    if (!oldValues.isPresent()) continue;
                    List newValues = oldValues.get().stream().map(value -> this._transformClobToString(value, idValue, logger)).filter(Objects::nonNull).collect(Collectors.toList());
                    contentValues.put(clobKey, newValues);
                }
            }
        }
        String idColumn = this.getIdColumn();
        LinkedHashMap<String, Map<String, Object>> results = new LinkedHashMap<String, Map<String, Object>>();
        for (Map<String, Object> contentValues : requestValues) {
            results.put(contentValues.get(idColumn).toString(), contentValues);
        }
        for (Map<String, Object> result : results.values()) {
            result.put("scc$uniqueid", result.get(this.getIdColumn()));
        }
        return results;
    }

    protected Map<String, Map<String, List<Object>>> getRemoteValues(Map<String, Object> searchParameters, Logger logger) {
        Map<String, Map<String, List<Object>>> remoteValues = new HashMap<String, Map<String, List<Object>>>();
        Map<String, Map<String, Object>> results = this.internalSearch(searchParameters, 0, Integer.MAX_VALUE, null, logger);
        if (results != null) {
            remoteValues = this._sccHelper.organizeRemoteValuesByAttribute(results, this._mapping);
        }
        return remoteValues;
    }

    public List<String> getLanguages() {
        return List.of(this._apogeeSCCHelper.getSynchronizationLang());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ModifiableContent> importContent(String idValue, Map<String, Object> additionalParameters, Logger logger) throws Exception {
        boolean isRequestAttributeOwner = false;
        Request request = ContextHelper.getRequest((org.apache.avalon.framework.context.Context)this._context);
        try {
            if (request.getAttribute(ApogeeSynchronizableContentsCollectionHelper.HANDLED_CONTENTS) == null) {
                this._startHandleCDMFR();
                request.setAttribute(ApogeeSynchronizableContentsCollectionHelper.HANDLED_CONTENTS, new HashSet());
                isRequestAttributeOwner = true;
            }
            List list = super.importContent(idValue, additionalParameters, logger);
            return list;
        }
        finally {
            if (isRequestAttributeOwner) {
                this._endHandleCDMFR(request);
                request.removeAttribute(ApogeeSynchronizableContentsCollectionHelper.HANDLED_CONTENTS);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void synchronizeContent(ModifiableContent content, Logger logger) throws Exception {
        boolean isRequestAttributeOwner = false;
        Request request = ContextHelper.getRequest((org.apache.avalon.framework.context.Context)this._context);
        try {
            if (request.getAttribute(ApogeeSynchronizableContentsCollectionHelper.HANDLED_CONTENTS) == null) {
                this._startHandleCDMFR();
                request.setAttribute(ApogeeSynchronizableContentsCollectionHelper.HANDLED_CONTENTS, new HashSet());
                this._addContentAttributes(request, content);
                isRequestAttributeOwner = true;
            }
            super.synchronizeContent(content, logger);
        }
        finally {
            if (isRequestAttributeOwner) {
                this._endHandleCDMFR(request);
                request.removeAttribute(ApogeeSynchronizableContentsCollectionHelper.HANDLED_CONTENTS);
                this._removeContentAttributes(request);
            }
        }
    }

    protected void _startHandleCDMFR() {
        this._cdmfrHandler.suspendCDMFRObserver();
    }

    protected void _endHandleCDMFR(Request request) {
        Set handledContents = (Set)request.getAttribute(ApogeeSynchronizableContentsCollectionHelper.HANDLED_CONTENTS);
        this._cdmfrHandler.unsuspendCDMFRObserver(handledContents);
    }

    protected void _addContentAttributes(Request request, ModifiableContent content) {
        request.setAttribute(ApogeeSynchronizableContentsCollectionHelper.LANG, (Object)content.getLanguage());
    }

    protected void _removeContentAttributes(Request request) {
        request.removeAttribute(ApogeeSynchronizableContentsCollectionHelper.LANG);
    }

    protected Map<String, Object> putIdParameter(String idValue) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put(this.getIdField(), idValue);
        return parameters;
    }

    protected abstract List<Map<String, Object>> _search(Map<String, Object> var1, Logger var2);

    protected List<Map<String, Object>> _convertBigDecimal(List<Map<String, Object>> searchResults) {
        ArrayList<Map<String, Object>> convertedSearchResults = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> searchResult : searchResults) {
            for (String key : searchResult.keySet()) {
                searchResult.put(key, this._convertBigDecimal(this.getContentType(), key, searchResult.get(key)));
            }
            convertedSearchResults.add(searchResult);
        }
        return convertedSearchResults;
    }

    protected Object _convertBigDecimal(String contentTypeId, String attributeName, Object objectToConvert) {
        if (objectToConvert instanceof BigDecimal) {
            ContentType contentType = (ContentType)this._contentTypeEP.getExtension(contentTypeId);
            if (contentType.hasModelItem(attributeName)) {
                String typeId;
                ModelItem definition = contentType.getModelItem(attributeName);
                switch (typeId = definition.getType().getId()) {
                    case "double": {
                        return ((BigDecimal)objectToConvert).doubleValue();
                    }
                    case "long": {
                        return ((BigDecimal)objectToConvert).longValue();
                    }
                }
            }
            return ((BigDecimal)objectToConvert).toString();
        }
        return objectToConvert;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object _transformClobToString(Object value, String idValue, Logger logger) {
        if (value instanceof Clob) {
            Clob clob = (Clob)value;
            try {
                String strValue = IOUtils.toString((Reader)clob.getCharacterStream());
                String string = CharMatcher.javaIsoControl().and(CharMatcher.anyOf((CharSequence)"\r\n\t").negate()).removeFrom((CharSequence)strValue);
                return string;
            }
            catch (IOException | SQLException e) {
                logger.error("Unable to get education add elements from the program '{}'.", (Object)idValue, (Object)e);
                Object var6_8 = null;
                return var6_8;
            }
            finally {
                try {
                    clob.free();
                }
                catch (SQLException sQLException) {}
            }
        }
        return value;
    }

    protected Set<String> getClobColumns() {
        return Set.of();
    }

    protected Map<String, List<Object>> _transformListOfMap2MapOfList(List<Map<String, Object>> lines) {
        return lines.stream().filter(Objects::nonNull).map(Map::entrySet).flatMap(Collection::stream).filter(e -> Objects.nonNull(e.getValue())).collect(Collectors.toMap(Map.Entry::getKey, e -> List.of(e.getValue()), (l1, l2) -> ListUtils.union((List)l1, (List)l2)));
    }

    protected abstract String getMappingName();

    protected String getDataSourceId() {
        return (String)this.getParameterValues().get(PARAM_DATASOURCE_ID);
    }

    protected String getYear() {
        return (String)this.getParameterValues().get(PARAM_YEAR);
    }

    protected boolean addUnexistingChildren() {
        if (this._addUnexistingChildren == null) {
            this._addUnexistingChildren = Boolean.valueOf(this.getParameterValues().getOrDefault(PARAM_ADD_UNEXISTING_CHILDREN, Boolean.TRUE.toString()));
        }
        return this._addUnexistingChildren;
    }

    protected boolean addExistingChildren() {
        if (this._addExistingChildren == null) {
            this._addExistingChildren = Boolean.valueOf(this.getParameterValues().getOrDefault(PARAM_ADD_EXISTING_CHILDREN, Boolean.FALSE.toString()));
        }
        return this._addExistingChildren;
    }

    protected String getIdColumn() {
        return this._idColumn;
    }

    public String getIdField() {
        return "apogeeSyncCode";
    }

    public Set<String> getLocalAndExternalFields(Map<String, Object> additionalParameters) {
        return this._syncFields;
    }

    protected void configureSearchModel() {
        for (ApogeeCriterion criterion : this._criteria) {
            this._searchModelConfiguration.addCriterion(criterion.getId(), criterion.getLabel(), criterion.getType());
        }
        for (String columnName : this._columns) {
            this._searchModelConfiguration.addColumn(columnName);
        }
    }

    protected Map<String, Object> getAdditionalAttributeValues(String idValue, Content content, Map<String, Object> additionalParameters, boolean create, Logger logger) {
        Map additionalValues = super.getAdditionalAttributeValues(idValue, content, additionalParameters, create, logger);
        this.getParentFromAdditionalParameters(additionalParameters).map(this::getParentAttribute).ifPresent(attribute -> additionalValues.put((String)attribute.getKey(), attribute.getValue()));
        String childrenAttributeName = this.getChildrenAttributeName();
        if (childrenAttributeName != null) {
            List<ModifiableContent> children = this.handleChildren(idValue, content, create, logger);
            additionalValues.put(childrenAttributeName, children.toArray(new ModifiableContent[children.size()]));
        }
        return additionalValues;
    }

    protected Pair<String, Object> getParentAttribute(ModifiableContent parent) {
        return null;
    }

    protected List<ModifiableContent> handleChildren(String idValue, Content content, boolean create, Logger logger) {
        return this.importOrSynchronizeChildren(idValue, content, this.getChildrenSCCModelId(), this.getChildrenAttributeName(), create, logger);
    }

    protected Set<String> getNotSynchronizedRelatedContentIds(Content content, Map<String, Object> contentValues, Map<String, Object> additionalParameters, String lang, Logger logger) {
        Set contentIds = super.getNotSynchronizedRelatedContentIds(content, contentValues, additionalParameters, lang, logger);
        this.getParentIdFromAdditionalParameters(additionalParameters).ifPresent(contentIds::add);
        return contentIds;
    }

    protected Optional<ModifiableContent> getParentFromAdditionalParameters(Map<String, Object> additionalParameters) {
        return this.getParentIdFromAdditionalParameters(additionalParameters).map(arg_0 -> ((AmetysObjectResolver)this._resolver).resolveById(arg_0));
    }

    protected Optional<String> getParentIdFromAdditionalParameters(Map<String, Object> additionalParameters) {
        return Optional.ofNullable(additionalParameters).filter(params -> params.containsKey("parentId")).map(params -> params.get("parentId")).filter(String.class::isInstance).map(String.class::cast);
    }

    protected String getChildrenSCCModelId() {
        return null;
    }

    protected abstract String getChildrenAttributeName();

    protected String _getSort(List<Object> sortList) {
        if (sortList != null) {
            StringBuilder sort = new StringBuilder();
            for (Object sortValueObj : sortList) {
                Map sortValue = (Map)sortValueObj;
                sort.append(sortValue.get("property"));
                if (sortValue.containsKey("direction")) {
                    sort.append(" ");
                    sort.append(sortValue.get("direction"));
                    sort.append(",");
                    continue;
                }
                sort.append(" ASC,");
            }
            sort.deleteCharAt(sort.length() - 1);
            return sort.toString();
        }
        return null;
    }

    public int getTotalCount(Map<String, Object> searchParameters, Logger logger) {
        HashMap<String, Object> searchParams = new HashMap<String, Object>();
        for (String parameterName : searchParameters.keySet()) {
            Object parameterValue = searchParameters.get(parameterName);
            if (parameterValue == null || parameterValue.toString().isEmpty()) continue;
            searchParams.put(parameterName, parameterValue);
        }
        searchParams.put("__count", true);
        List<Map<String, Object>> results = this._search(searchParams, logger);
        if (results != null && !results.isEmpty()) {
            return Integer.valueOf(results.get(0).get("COUNT(*)").toString());
        }
        return 0;
    }

    protected ModifiableContent _importContent(String idValue, Map<String, Object> additionalParameters, String lang, Map<String, List<Object>> remoteValues, Logger logger) throws Exception {
        ModifiableContent content = super._importContent(idValue, additionalParameters, lang, this._transformOrgUnitAttribute(remoteValues, logger), logger);
        if (content != null) {
            this._apogeeSCCHelper.addToHandleContents(content.getId());
        }
        return content;
    }

    protected ModifiableContent _synchronizeContent(ModifiableContent content, Map<String, List<Object>> remoteValues, Logger logger) throws Exception {
        if (!this._apogeeSCCHelper.addToHandleContents(content.getId())) {
            return content;
        }
        return super._synchronizeContent(content, this._transformOrgUnitAttribute(remoteValues, logger), logger);
    }

    protected List<ModifiableContent> importOrSynchronizeChildren(String idValue, Content content, String sccModelId, String attributeName, boolean create, Logger logger) {
        SynchronizableContentsCollection scc = this._sccHelper.getSCCFromModelId(sccModelId);
        return create ? this._importChildren(idValue, scc, logger) : this._synchronizeChildren(content, scc, attributeName, logger);
    }

    protected List<ModifiableContent> _importChildren(String idValue, SynchronizableContentsCollection scc, Logger logger) {
        if (scc != null && scc instanceof ApogeeSynchronizableContentsCollection) {
            return ((ApogeeSynchronizableContentsCollection)scc).importOrSynchronizeContents(this._getChildrenSearchParametersWithParent(idValue), logger);
        }
        return List.of();
    }

    protected List<ModifiableContent> _synchronizeChildren(Content content, SynchronizableContentsCollection scc, String attributeName, Logger logger) {
        Set<String> childrenRemoteSyncCode;
        List<Object> ametysChildren = Stream.of((ContentValue[])content.getValue(attributeName, false, (Object)new ContentValue[0])).map(ContentValue::getContentIfExists).flatMap(Optional::stream).collect(Collectors.toList());
        Set<String> set = childrenRemoteSyncCode = this.removalSync() || this.addUnexistingChildren() || this.addExistingChildren() ? this._getChildrenRemoteSyncCode(content, scc, logger) : null;
        if (childrenRemoteSyncCode != null) {
            if (this.removalSync()) {
                ametysChildren = ametysChildren.stream().filter(c -> !this._isChildWillBeRemoved((ModifiableContent)c, scc, childrenRemoteSyncCode, logger)).collect(Collectors.toList());
            }
            if (this.addExistingChildren() || this.addUnexistingChildren()) {
                for (String string : childrenRemoteSyncCode) {
                    ModifiableContent child = scc.getContent(this._apogeeSCCHelper.getSynchronizationLang(), string, false);
                    if (child == null) {
                        if (!this.addUnexistingChildren()) continue;
                        ametysChildren.addAll(this._importUnexistingChildren(scc, string, null, logger));
                        continue;
                    }
                    if (!this.addExistingChildren() || ametysChildren.contains(child)) continue;
                    ametysChildren.add(child);
                }
            }
        }
        for (ModifiableContent modifiableContent : ametysChildren) {
            this._apogeeSCCHelper.synchronizeContent(modifiableContent, logger);
        }
        return ametysChildren;
    }

    protected Set<String> _getChildrenRemoteSyncCode(Content content, SynchronizableContentsCollection scc, Logger logger) {
        if (scc != null && scc instanceof AbstractApogeeSynchronizableContentsCollection) {
            String syncCode = (String)content.getValue(this.getIdField());
            return ((AbstractApogeeSynchronizableContentsCollection)scc).search(this._getChildrenSearchParametersWithParent(syncCode), 0, Integer.MAX_VALUE, null, logger).keySet();
        }
        return null;
    }

    protected Map<String, Object> _getChildrenSearchParametersWithParent(String parentSyncCode) {
        HashMap<String, Object> searchParameters = new HashMap<String, Object>();
        searchParameters.put("parentCode", parentSyncCode);
        return searchParameters;
    }

    protected List<ModifiableContent> _importUnexistingChildren(SynchronizableContentsCollection scc, String syncCode, Map<String, List<Object>> additionalParameters, Logger logger) {
        try {
            return scc.importContent(syncCode, additionalParameters, logger);
        }
        catch (Exception e) {
            logger.error("An error occured while importing a new children content with syncCode '{}' from SCC '{}'", new Object[]{syncCode, scc.getId(), e});
            return Collections.emptyList();
        }
    }

    protected boolean _isChildWillBeRemoved(ModifiableContent content, SynchronizableContentsCollection scc, Set<String> childrenRemoteSyncCode, Logger logger) {
        String syncCode = (String)content.getValue(scc.getIdField());
        return !childrenRemoteSyncCode.contains(syncCode);
    }

    @Override
    public List<ModifiableContent> importOrSynchronizeContents(Map<String, Object> searchParams, Logger logger) {
        ContainerProgressionTracker containerProgressionTracker = ProgressionTrackerFactory.createContainerProgressionTracker((String)"Import or synchronize contents", (Logger)logger);
        return this._importOrSynchronizeContents(searchParams, true, logger, containerProgressionTracker);
    }

    private Map<String, List<Object>> _transformOrgUnitAttribute(Map<String, List<Object>> remoteValues, Logger logger) {
        SynchronizableContentsCollection scc = this._sccHelper.getSCCFromModelId("org.ametys.plugins.odfsync.apogee.scc.orgunit");
        List<Object> orgUnitCodes = remoteValues.get("orgUnit");
        if (orgUnitCodes != null && !orgUnitCodes.isEmpty()) {
            List orgUnitContents = null;
            String orgUnitCode = orgUnitCodes.get(0).toString();
            if (scc != null) {
                try {
                    ModifiableContent orgUnitContent = scc.getContent(this._apogeeSCCHelper.getSynchronizationLang(), orgUnitCode, false);
                    orgUnitContents = orgUnitContent == null ? scc.importContent(orgUnitCode, null, logger) : List.of(orgUnitContent);
                }
                catch (Exception e) {
                    logger.error("An error occured during the import of the OrgUnit identified by the synchronization code '{}'", (Object)orgUnitCode, (Object)e);
                }
            }
            if (orgUnitContents == null) {
                remoteValues.remove("orgUnit");
                logger.warn("Impossible to import the OrgUnit with the synchronization code '{}', check if you set the OrgUnit SCC with the following model ID: '{}'", (Object)orgUnitCode, (Object)"org.ametys.plugins.odfsync.apogee.scc.orgunit");
            } else {
                remoteValues.put("orgUnit", orgUnitContents);
            }
        }
        return remoteValues;
    }

    public boolean handleRightAssignmentContext() {
        return false;
    }
}

