<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2019 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                            xmlns:cms="http://ametys.org/cms/3.0"
                            xmlns:func="http://exslt.org/functions"
                            exclude-result-prefixes="cms func">

    <func:function name="cms:getNbHours">
        <xsl:param name="value"/>
        
        <xsl:variable name="hours">
	        <xsl:choose>
	            <xsl:when test="contains($value, 'H')"><xsl:value-of select="substring-before($value, 'H')"/></xsl:when>
	            <xsl:when test="contains($value, 'h')"><xsl:value-of select="substring-before($value, 'h')"/></xsl:when>
	            <xsl:otherwise><xsl:value-of select="$value"/></xsl:otherwise>
	        </xsl:choose>
        </xsl:variable>
        <func:result select="normalize-space($hours)"/>
    </func:function>
    
</xsl:stylesheet>
    
    