/*
 *  Copyright 2019 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.odfsync.apogee.ws;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

import org.ametys.odf.program.Program;
import org.ametys.plugins.odfsync.export.AbstractExportStructure;
import org.ametys.plugins.odfsync.export.AbstractStructureComponent;
import org.ametys.plugins.odfsync.export.ExportReport;
import org.ametys.plugins.odfsync.export.ExportReport.ExportStatus;

/**
 * Component for Apogee export
 */
public class ApogeeStructureComponent extends AbstractStructureComponent
{
    /** Avalon Role */
    public static final String ROLE = ApogeeStructureComponent.class.getName();
    
    /** The apogee export extension point */
    protected ApogeeExportExtensionPoint _exportApogeeEP;
    
    @Override
    public void service(ServiceManager manager) throws ServiceException
    {
        super.service(manager);
        _exportApogeeEP = (ApogeeExportExtensionPoint) manager.lookup(ApogeeExportExtensionPoint.ROLE);
    }
    
    /**
     * Get the Apogee export report of the program id
     * @param program the program id
     * @return the Apogee export report
     */
    @Override
    public ExportReport getExportReport(Program program)
    {
        ExportReport report = new ExportReport(program);
        for (String implementationId : _exportApogeeEP.getExtensionsIds())
        {
            AbstractExportStructure exportApogeeStructure = _exportApogeeEP.getExtension(implementationId);

            // Check if the structure is good
            // Do nothing  if the structure is invalid and continue to check the other Apogee implementations
            exportApogeeStructure.checkProgram(program, report);
            if (report.getStatus() != ExportStatus.CONTENT_STRUCTURE_INVALID)
            {
                report.setExportStructure(exportApogeeStructure);
                return report;
            }
        }
        
        // No implementation for this program structure 
        report.setStatus(ExportStatus.CONTENT_STRUCTURE_INVALID);
        return report;
    }
}
