/*
 *  Copyright 2017 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.odfsync.cdmfr.transformers;

import java.io.IOException;
import java.util.Map;

import org.apache.cocoon.ProcessingException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

import org.ametys.runtime.plugin.component.Prioritizable;
import org.ametys.runtime.plugin.component.Supporter;

/**
 * Interface for sync transformer objects.
 */
public interface CDMFrSyncTransformer extends Prioritizable, Supporter<Document>
{
    /**
     * Transform the document to a generic document designed for Ametys importers and synchronizers.
     * @param document The document to transform.
     * @param parameters additional parameters for transformation
     * @return The transformed document.
     * @throws IOException if an error occurs.
     * @throws SAXException if an error occurs.
     * @throws ProcessingException if an error occurs.
     */
    public Document transform(Document document, Map<String, Object> parameters) throws IOException, SAXException, ProcessingException;
}
