/*
 *  Copyright 2025 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.odfsync.pegase;

import org.ametys.odf.content.code.AttributeBasedDisplayCodeProvider;
import org.ametys.runtime.config.Config;
import org.ametys.runtime.plugin.PluginsManager;

/**
 * Display provider based on Pegase synchronization code.
 * This provider is available only if Pegase import/export is active in configuration parameter.
 */
public class PegaseDisplayCodeProvider extends AttributeBasedDisplayCodeProvider
{
    public boolean isActive()
    {
        // Cannot access configuration parameters in safe mode
        return !PluginsManager.getInstance().isSafeMode() && Config.getInstance().getValue("pegase.activate", true, false);
    }
}
