/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfsync.pegase.ws;

import fr.pcscol.pegase.odf.ApiClient;
import fr.pcscol.pegase.odf.api.EspacesExterneApi;
import fr.pcscol.pegase.odf.api.MaquettesApi;
import fr.pcscol.pegase.odf.api.MaquettesExterneApi;
import fr.pcscol.pegase.odf.api.ObjetsMaquetteApi;
import fr.pcscol.pegase.odf.api.ObjetsMaquetteExterneApi;
import java.io.IOException;
import org.ametys.core.util.HttpUtils;
import org.ametys.plugins.odfsync.pegase.ws.PegaseTokenManager;
import org.ametys.runtime.config.Config;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public class PegaseApiManager
extends AbstractLogEnabled
implements Component,
Serviceable,
Initializable {
    public static final String ROLE = PegaseApiManager.class.getName();
    protected PegaseTokenManager _pegaseTokenManager;
    private ObjetsMaquetteExterneApi _objetsMaquetteExterneApi;
    private MaquettesExterneApi _maquettesExterneApi;
    private ObjetsMaquetteApi _objetsMaquetteApi;
    private MaquettesApi _maquettesApi;
    private EspacesExterneApi _espacesExterneApi;
    private boolean _isActive;
    private String _pegaseODFUrl;

    public void service(ServiceManager manager) throws ServiceException {
        this._pegaseTokenManager = (PegaseTokenManager)((Object)manager.lookup(PegaseTokenManager.ROLE));
    }

    public void initialize() throws Exception {
        this._isActive = (Boolean)Config.getInstance().getValue("pegase.activate", true, (Object)false);
        if (this._isActive) {
            this._pegaseODFUrl = HttpUtils.sanitize((String)((String)Config.getInstance().getValue("pegase.odf.url")));
        }
    }

    private void _updateApiClient(ApiClient apiClient, boolean external) throws IOException {
        apiClient.setBearerToken(this._pegaseTokenManager.getToken());
        apiClient.setServerUrl(this._pegaseODFUrl);
        apiClient.useExternalApi(external);
    }

    public ObjetsMaquetteExterneApi getObjetsMaquetteExterneApi() throws IOException {
        if (this._objetsMaquetteExterneApi == null) {
            this._objetsMaquetteExterneApi = new ObjetsMaquetteExterneApi();
        }
        this._updateApiClient(this._objetsMaquetteExterneApi.getApiClient(), true);
        return this._objetsMaquetteExterneApi;
    }

    public MaquettesExterneApi getMaquettesExterneApi() throws IOException {
        if (this._maquettesExterneApi == null) {
            this._maquettesExterneApi = new MaquettesExterneApi();
        }
        this._updateApiClient(this._maquettesExterneApi.getApiClient(), true);
        return this._maquettesExterneApi;
    }

    public ObjetsMaquetteApi getObjetsMaquetteApi() throws IOException {
        if (this._objetsMaquetteApi == null) {
            this._objetsMaquetteApi = new ObjetsMaquetteApi();
        }
        this._updateApiClient(this._objetsMaquetteApi.getApiClient(), false);
        return this._objetsMaquetteApi;
    }

    public MaquettesApi getMaquettesApi() throws IOException {
        if (this._maquettesApi == null) {
            this._maquettesApi = new MaquettesApi();
        }
        this._updateApiClient(this._maquettesApi.getApiClient(), false);
        return this._maquettesApi;
    }

    public EspacesExterneApi getEspacesExterneApi() throws IOException {
        if (this._espacesExterneApi == null) {
            this._espacesExterneApi = new EspacesExterneApi();
        }
        this._updateApiClient(this._espacesExterneApi.getApiClient(), true);
        return this._espacesExterneApi;
    }
}

