<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2012 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:docbook="http://docbook.org/ns/docbook" 
	xmlns:cdm="http://cdm-fr.fr/2012/CDM"
	xmlns:cdmfr="http://cdm-fr.fr/2012/CDM-frSchema"
	xmlns:odf="org.ametys.odf.OdfXSLTHelper"
	exclude-result-prefixes="cdm cdmfr">
	
	<xsl:import href="../rof23/program2content.xsl"/>
	
    <!-- +
         | ROF4 is same as ROF2.3 except cdmfr:programStructure has been replaced by cdm:programStructure 
         + -->
         
         <xsl:template name="root-program-title">
        <xsl:if test="cdmfr:programName/cdmfr:text">
            <xsl:variable name="degree" select="/cdm:CDM/cdm:program[@ident = /cdm:CDM/cdmfr:habilitation/cdmfr:habiliId]/cdm:qualification/cdmfr:degree/@degree"/>
            <title><xsl:value-of select="cdmfr:programName/cdmfr:text"/></title>
            <!-- <title><xsl:value-of select="odf:degreeLabel($degree)"/><xsl:text> </xsl:text><xsl:value-of select="cdmfr:programName/cdmfr:text"/></title> -->
        </xsl:if>
    </xsl:template>
    
	<xsl:template name="program-structure">
		<!-- Liste d'UE -->
		<xsl:if test="cdm:programStructure/cdm:refCourse/@ref">
			<coursesReferences name="Liste">
				<xsl:if test="@ident">
					<xsl:attribute name="code"><xsl:value-of select="concat(@ident, '-CL')" /></xsl:attribute>
				</xsl:if>
				<xsl:for-each select="cdm:programStructure/cdm:refCourse">
					<item><xsl:value-of select="@ref"/></item>
				</xsl:for-each>
			</coursesReferences>
		</xsl:if>
	</xsl:template>
	
	<!-- @Override Program sub-program -->
	<xsl:template name="program-subProgram">
		<!-- Sous-programme ou conteneur -->
		<xsl:for-each select="cdm:programStructure/cdm:refProgram/@ref">
			<xsl:variable name="subprogram"><xsl:value-of select="."/></xsl:variable>
			<xsl:apply-templates select="//cdm:program[cdm:programID = $subprogram]" mode="rof-subprogram"/>
		</xsl:for-each>
	</xsl:template>
	
	<!-- Listes d'UE -->
	<xsl:template match="cdm:program[cdm:programStructure/cdm:refCourse/@ref and not(cdm:programStructure/cdm:refProgram/@ref) and not(cdmfr:programDescription/@nature = 'semestre')]" mode="rof-subprogram">
		<coursesReferences name="{cdmfr:programName/cdmfr:text}" code="{cdmfr:programCode[@codeSet='userDefined']}">
			<xsl:for-each select="cdm:programStructure/cdm:refCourse">
				<item><xsl:value-of select="@ref"/></item>
			</xsl:for-each>
		</coursesReferences>
	</xsl:template>
    
    <!-- Organisation des études -->
    <xsl:template name="root-program-teachingOrganization">
        <xsl:param name="ME"/>
        <xsl:param name="SP"/>
        
        <!-- Concaténation de la mention ME (si présente), de la spécialité SP (si présente) et du programme PR-->
        <teachingOrganization>
            <xsl:if test="$ME/cdm:programStructure/cdm:infoBlock/* or $SP/cdm:programStructure/cdm:infoBlock/* or cdm:programStructure/cdm:infoBlock/*">
                <article version="5" xmlns="http://docbook.org/ns/docbook">
                    <xsl:apply-templates select="$ME/cdm:programStructure/cdm:infoBlock[*]" mode="infoblock-without-article"/>
                    <xsl:apply-templates select="$SP/cdm:programStructure/cdm:infoBlock[*]" mode="infoblock-without-article"/>
                    <xsl:apply-templates select="cdm:programStructure/cdm:infoBlock[*]" mode="infoblock-without-article"/>
                </article>
            </xsl:if>
        </teachingOrganization>
    </xsl:template>
	
</xsl:stylesheet>