/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfsync.export;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ametys.cms.clientsideelement.AbstractContentClientSideElement;
import org.ametys.cms.contenttype.ContentType;
import org.ametys.cms.contenttype.ContentTypeExtensionPoint;
import org.ametys.cms.repository.Content;
import org.ametys.core.ui.ClientSideElement;
import org.ametys.odf.ProgramItem;
import org.ametys.odf.course.Course;
import org.ametys.odf.courselist.CourseList;
import org.ametys.odf.orgunit.OrgUnit;
import org.ametys.odf.program.Container;
import org.ametys.odf.program.Program;
import org.ametys.odf.program.SubProgram;
import org.ametys.plugins.odfsync.export.AbstractStructureComponent;
import org.ametys.plugins.odfsync.export.ExportReport;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.runtime.config.Config;
import org.ametys.runtime.i18n.I18nizableText;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

public abstract class AbstractExportClientSideElement
extends AbstractContentClientSideElement
implements Initializable {
    protected ServiceManager _manager;
    protected AmetysObjectResolver _resolver;
    protected ContentTypeExtensionPoint _ctExtPoint;
    protected AbstractStructureComponent _structureComponent;
    private boolean _isActive;

    public void initialize() throws Exception {
        this._isActive = (Boolean)Config.getInstance().getValue(this.getActivateParam(), true, (Object)false);
    }

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._manager = smanager;
        this._resolver = (AmetysObjectResolver)smanager.lookup(AmetysObjectResolver.ROLE);
        this._ctExtPoint = (ContentTypeExtensionPoint)smanager.lookup(ContentTypeExtensionPoint.ROLE);
        this._structureComponent = (AbstractStructureComponent)this._manager.lookup(this.getStructureComponentRole());
    }

    public List<ClientSideElement.Script> getScripts(boolean ignoreRights, Map<String, Object> contextParameters) {
        if (this._isActive) {
            return super.getScripts(ignoreRights, contextParameters);
        }
        return new ArrayList<ClientSideElement.Script>();
    }

    protected abstract String getActivateParam();

    protected abstract String getStructureComponentRole();

    public Map<String, Object> getExportReportInfo(String programId) {
        HashMap<String, Object> results = new HashMap<String, Object>();
        Program program = (Program)this._resolver.resolveById(programId);
        if (this.hasRight((Content)program)) {
            ExportReport report = this._structureComponent.getExportReport(program);
            ExportReport.ExportStatus exportStatus = report.getStatus();
            results.put("status", exportStatus.name());
            if (exportStatus == ExportReport.ExportStatus.CONTENT_DATA_INVALID) {
                HashMap<String, Map<String, Object>> programReport = new HashMap<String, Map<String, Object>>();
                HashMap<String, Map<String, Object>> subProgramReport = new HashMap<String, Map<String, Object>>();
                HashMap<String, Map<String, Object>> containerReport = new HashMap<String, Map<String, Object>>();
                HashMap<String, Map<String, Object>> courseListReport = new HashMap<String, Map<String, Object>>();
                HashMap<String, Map<String, Object>> courseReport = new HashMap<String, Map<String, Object>>();
                HashMap<String, Map<String, Object>> orgUnitReport = new HashMap<String, Map<String, Object>>();
                HashMap<String, Map<String, Object>> otherContentReport = new HashMap<String, Map<String, Object>>();
                Map<Content, Set<I18nizableText>> invalidDataByContent = report.getInvalidDataPathByContent();
                for (Content content : invalidDataByContent.keySet()) {
                    if (content instanceof Program) {
                        programReport.put(content.getId(), this._getContentParams(content, invalidDataByContent.get(content)));
                        continue;
                    }
                    if (content instanceof SubProgram) {
                        subProgramReport.put(content.getId(), this._getContentParams(content, invalidDataByContent.get(content)));
                        continue;
                    }
                    if (content instanceof Container) {
                        containerReport.put(content.getId(), this._getContentParams(content, invalidDataByContent.get(content)));
                        continue;
                    }
                    if (content instanceof CourseList) {
                        courseListReport.put(content.getId(), this._getContentParams(content, invalidDataByContent.get(content)));
                        continue;
                    }
                    if (content instanceof Course) {
                        courseReport.put(content.getId(), this._getContentParams(content, invalidDataByContent.get(content)));
                        continue;
                    }
                    if (content instanceof OrgUnit) {
                        orgUnitReport.put(content.getId(), this._getContentParams(content, invalidDataByContent.get(content)));
                        continue;
                    }
                    otherContentReport.put(content.getId(), this._getContentParams(content, invalidDataByContent.get(content)));
                }
                results.put("program", programReport);
                results.put("subprogram", subProgramReport);
                results.put("container", containerReport);
                results.put("courselist", courseListReport);
                results.put("course", courseReport);
                results.put("orgunit", orgUnitReport);
                results.put("other", otherContentReport);
            }
        } else {
            results.put("status", ExportReport.ExportStatus.ERROR.name());
        }
        return results;
    }

    public Map<String, Object> exportProgram(String programId) {
        HashMap<String, Object> results = new HashMap<String, Object>();
        Program program = (Program)this._resolver.resolveById(programId);
        if (this.hasRight((Content)program)) {
            ExportReport exportReport = this._structureComponent.getExportReport(program);
            if (exportReport.getStatus() == ExportReport.ExportStatus.OK) {
                exportReport.getExportStructure().createProgram(program, exportReport);
            }
            results.put("nbExported", exportReport.getNbExported());
            results.put("nbNotExported", exportReport.getNbNotExported());
            results.put("nbPartlyExported", exportReport.getNbPartlyExported());
            results.put("problemsEncountered", exportReport.getProblemsEncountered());
            results.put("status", exportReport.getStatus().name());
        } else {
            results.put("status", ExportReport.ExportStatus.ERROR.name());
        }
        results.put("contentId", program.getId());
        results.put("contentTitle", program.getTitle());
        return results;
    }

    protected Map<String, Object> _getContentParams(Content content, Set<I18nizableText> invalidMessages) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("contentTitle", content.getTitle());
        if (content instanceof ProgramItem) {
            params.put("contentCode", ((ProgramItem)content).getCode());
        } else if (content instanceof OrgUnit) {
            params.put("contentCode", ((OrgUnit)content).getUAICode());
        } else {
            String contentTypeId = content.getTypes()[0];
            ContentType contentType = (ContentType)this._ctExtPoint.getExtension(contentTypeId);
            params.put("contentTypeLabel", contentType.getLabel());
            params.put("contentTypeId", contentTypeId);
            params.put("isTableRef", true);
        }
        params.put("attributes", invalidMessages);
        return params;
    }
}

