/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfsync.utils;

import java.util.stream.Stream;

public enum ContentWorkflowDescription {
    PROGRAM_WF_DESCRIPTION("org.ametys.plugins.odf.Content.program", "program", 1, 4),
    SUBPROGRAM_WF_DESCRIPTION("org.ametys.plugins.odf.Content.subProgram", "subprogram", 1, 4),
    CONTAINER_WF_DESCRIPTION("org.ametys.plugins.odf.Content.container", "container", 1, 4),
    COURSELIST_WF_DESCRIPTION("org.ametys.plugins.odf.Content.courseList", "courselist", 1, 4),
    COURSE_WF_DESCRIPTION("org.ametys.plugins.odf.Content.course", "course", 1, 4),
    COURSEPART_WF_DESCRIPTION("org.ametys.plugins.odf.Content.coursePart", "course-part", 1, -1),
    ORGUNIT_WF_DESCRIPTION("org.ametys.plugins.odf.Content.orgunit", "orgunit", 1, 4),
    PERSON_WF_DESCRIPTION("org.ametys.plugins.odf.Content.person", "person", 1, 4);

    private String _contentType;
    private String _workflowName;
    private int _initialActionId;
    private int _validationActionId;

    private ContentWorkflowDescription(String contentType, String workflowName, int initialActionId, int validationActionId) {
        this._contentType = contentType;
        this._workflowName = workflowName;
        this._initialActionId = initialActionId;
        this._validationActionId = validationActionId;
    }

    public String getContentType() {
        return this._contentType;
    }

    public String getWorkflowName() {
        return this._workflowName;
    }

    public int getInitialActionId() {
        return this._initialActionId;
    }

    public int getValidationActionId() {
        return this._validationActionId;
    }

    public static ContentWorkflowDescription getByContentType(String contentType) {
        return Stream.of(ContentWorkflowDescription.values()).filter(wd -> wd.getContentType().equals(contentType)).findFirst().orElse(null);
    }
}

