<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2012 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:cdm="http://cdm-fr.fr/2013/CDM"
	xmlns:cdmfr="http://cdm-fr.fr/2013/CDM-frSchema"
    xmlns:ametys-cdm="http://www.ametys.org/cdm/1.0"
	exclude-result-prefixes="cdm cdmfr">
	
	<xsl:template name="person-CDMid">
		<xsl:attribute name="CDMid"><xsl:value-of select="@id"/></xsl:attribute>
	</xsl:template>
    
    <xsl:template name="person-title">
        <title>
            <xsl:choose>
                <xsl:when test="cdm:infoBlock[@userDefined = 'ametys-extension']/cdm:extension/ametys-cdm:title">
                    <xsl:value-of select="cdm:infoBlock[@userDefined = 'ametys-extension']/cdm:extension/ametys-cdm:title"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="normalize-space(concat(cdm:name/cdm:family, ' ', cdm:name/cdm:given))"/>
                </xsl:otherwise>
            </xsl:choose>
        </title>
    </xsl:template>
    
	<xsl:template name="person-login">
		<xsl:if test="cdm:personID">
			<login><xsl:value-of select="cdm:personID"/></login>
		</xsl:if>
	</xsl:template>
	
	<xsl:template name="person-personTitle">
		<xsl:if test="cdm:title/cdm:text">
			<personTitle><xsl:value-of select="cdm:title/cdm:text"/></personTitle>
		</xsl:if>
	</xsl:template>
	
	<xsl:template name="person-lastName">
		<xsl:if test="cdm:name/cdm:family">
			<lastName><xsl:value-of select="cdm:name/cdm:family"/></lastName>
		</xsl:if>
	</xsl:template>
	
	<xsl:template name="person-givenName">
		<xsl:if test="cdm:name/cdm:given">
			<givenName><xsl:value-of select="cdm:name/cdm:given"/></givenName>
		</xsl:if>
	</xsl:template>
	
	<xsl:template name="person-role">
		<role>
			<xsl:for-each select="cdm:role">
				<item><xsl:value-of select="cdm:text"/></item>
			</xsl:for-each>
		</role>
	</xsl:template>
	
	<xsl:template name="person-phone">
		<xsl:if test="cdm:contactData/cdm:telephone">
			<phone><xsl:value-of select="cdm:contactData/cdm:telephone"/></phone>
		</xsl:if>
	</xsl:template>
	
	<xsl:template name="person-fax">
		<xsl:if test="cdm:contactData/cdm:fax">
			<fax><xsl:value-of select="cdm:contactData/cdm:fax"/></fax>
		</xsl:if>
	</xsl:template>
	
	<xsl:template name="person-mail">
		<xsl:if test="cdm:contactData/cdm:email">
			<mail><xsl:value-of select="cdm:contactData/cdm:email"/></mail>
		</xsl:if>
	</xsl:template>
	
	<xsl:template name="person-address">
		<xsl:if test="cdm:contactData/cdm:adr/cdm:street">
			<address><xsl:value-of select="cdm:contactData/cdm:adr/cdm:street"/></address>
		</xsl:if>
	</xsl:template>
	
	<xsl:template name="person-additionalAddress">
		<xsl:if test="cdm:contactData/cdm:adr/cdm:extadr">
			<additionalAddress><xsl:value-of select="cdm:contactData/cdm:adr/cdm:extadr"/></additionalAddress>
		</xsl:if>
	</xsl:template>
	
	<xsl:template name="person-zipCode">
		<xsl:if test="cdm:contactData/cdm:adr/cdm:pcode">
			<zipCode><xsl:value-of select="cdm:contactData/cdm:adr/cdm:pcode"/></zipCode>
		</xsl:if>
	</xsl:template>
	
	<xsl:template name="person-town">
		<xsl:if test="cdm:contactData/cdm:adr/cdm:locality">
			<town><xsl:value-of select="cdm:contactData/cdm:adr/cdm:locality"/></town>
		</xsl:if>
	</xsl:template>
	
	<xsl:template name="person-webLinkLabel">
		<xsl:if test="cdm:contactData/cdm:webLink/cdm:linkName">
			<webLinkLabel><xsl:value-of select="cdm:contactData/cdm:webLink/cdm:linkName"/></webLinkLabel>
		</xsl:if>
	</xsl:template>
	
	<xsl:template name="person-webLinkUrl">
		<xsl:if test="cdm:contactData/cdm:webLink/cdm:href">
			<webLinkUrl><xsl:value-of select="cdm:contactData/cdm:webLink/cdm:href"/></webLinkUrl>
		</xsl:if>
	</xsl:template>
	
	<xsl:template name="person-additionalInformations">
		<additionalInformations>
			<xsl:if test="cdm:infoBlock/*">
				<xsl:apply-templates select="cdm:infoBlock[*]" mode="infoblock"/>
			</xsl:if>
		</additionalInformations>
	</xsl:template>
    
    <!-- Template to override in order to add customized fields -->
    <xsl:template name="person-additionalFields"/>
</xsl:stylesheet>
