/*
 *  Copyright 2022 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.odfsync.pegase.ws;

/**
 * Exception thrown when exporting a program (to Pégase)
 */
public class PegaseExportException extends Exception
{

    /**
     * Constructs a new PegaseExportException
     */
    public PegaseExportException()
    {
        super();
    }

    /**
     * Constructs a new PegaseExportException with the specified cause.
     * @param message the detail message.
     * @param cause the cause.
     */
    public PegaseExportException(String message, Throwable cause)
    {
        super(message, cause);
    }

    /**
     * Constructs a new PegaseExportException with the specified cause.
     * @param message the detail message.
     */
    public PegaseExportException(String message)
    {
        super(message);
    }

    /**
     * Constructs a new PegaseExportException with the specified cause.
     * @param cause the cause of the exception.
     */
    public PegaseExportException(Throwable cause)
    {
        super(cause);
    }
    
}
