/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfsync.apogee.scc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ametys.cms.repository.Content;
import org.ametys.cms.repository.ModifiableContent;
import org.ametys.core.schedule.progression.ContainerProgressionTracker;
import org.ametys.odf.cdmfr.CDMFRHandler;
import org.ametys.plugins.contentio.synchronize.impl.AbstractDefaultSynchronizableContentsCollection;
import org.ametys.plugins.odfsync.apogee.ApogeePreviousYearsFieldsDAO;
import org.ametys.plugins.odfsync.apogee.scc.ApogeeSynchronizableContentsCollectionHelper;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.query.expression.Expression;
import org.ametys.plugins.repository.query.expression.StringExpression;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

public abstract class AbstractPreviousYearsSynchronizableContentsCollection
extends AbstractDefaultSynchronizableContentsCollection {
    public static final String PARAM_DATASOURCE_ID = "datasourceId";
    public static final String PARAM_CURRENT_YEAR = "currentYear";
    public static final String PARAM_PRECEDING_YEAR = "precedingYear";
    protected ApogeePreviousYearsFieldsDAO _apogeePreviousYearsFieldsDAO;
    protected ApogeeSynchronizableContentsCollectionHelper _apogeeSCCHelper;
    protected CDMFRHandler _cdmfrHandler;

    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._apogeePreviousYearsFieldsDAO = (ApogeePreviousYearsFieldsDAO)((Object)manager.lookup(ApogeePreviousYearsFieldsDAO.ROLE));
        this._apogeeSCCHelper = (ApogeeSynchronizableContentsCollectionHelper)manager.lookup(ApogeeSynchronizableContentsCollectionHelper.ROLE);
        this._cdmfrHandler = (CDMFRHandler)manager.lookup(CDMFRHandler.ROLE);
    }

    protected String getDataSourceId() {
        return (String)this.getParameterValues().get(PARAM_DATASOURCE_ID);
    }

    protected String getCurrentYear() {
        return (String)this.getParameterValues().get(PARAM_CURRENT_YEAR);
    }

    protected String getPrecedingYear() {
        return (String)this.getParameterValues().get(PARAM_PRECEDING_YEAR);
    }

    public boolean checkCollection() {
        return false;
    }

    protected String getIdColumn() {
        return "ID_SYNC";
    }

    public List<String> getLanguages() {
        return List.of(this._apogeeSCCHelper.getSynchronizationLang());
    }

    public Set<String> getLocalAndExternalFields(Map<String, Object> additionalParameters) {
        HashSet<String> fields = new HashSet<String>();
        fields.add(this.getCurrentYearAttributeName());
        fields.add(this.getPrecedingYearAttributeName());
        return fields;
    }

    public void updateSyncInformations(ModifiableContent content, String syncCode, Logger logger) throws Exception {
        throw new UnsupportedOperationException("updateSyncInformations() method is not supported for this synchronizable contents collections.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ModifiableContent> populate(Logger logger, ContainerProgressionTracker progressionTracker) {
        Set<String> contentIds = null;
        try {
            this._startHandleCDMFR();
            List contents = super.populate(logger, progressionTracker);
            contentIds = contents.stream().map(AmetysObject::getId).collect(Collectors.toSet());
            List list = contents;
            return list;
        }
        finally {
            this._endHandleCDMFR(contentIds);
        }
    }

    protected void _startHandleCDMFR() {
        this._cdmfrHandler.suspendCDMFRObserver();
    }

    protected void _endHandleCDMFR(Set<String> contentIds) {
        this._cdmfrHandler.unsuspendCDMFRObserver(contentIds);
    }

    protected abstract String getCurrentYearAttributeName();

    protected abstract String getPrecedingYearAttributeName();

    protected Stream<Content> getContents() {
        String query = this._getContentPathQuery(this._apogeeSCCHelper.getSynchronizationLang(), null, this.getContentType(), false);
        return this._resolver.query(query).stream();
    }

    protected Map<String, Map<String, Object>> internalSearch(Map<String, Object> initialSearchParameters, int offset, int limit, List<Object> sort, Logger logger) {
        boolean isSingleSearch = initialSearchParameters.containsKey(this.getIdField());
        Map<String, Object> commonSearchParameters = isSingleSearch ? this._addSyncCodeToSearchParams(initialSearchParameters) : initialSearchParameters;
        List<Map<String, Object>> listOfResults = this._search(commonSearchParameters);
        Map<String, String> syncCode2Code = isSingleSearch ? Map.of((String)initialSearchParameters.get(this.getIdField()), (String)commonSearchParameters.get("syncCode")) : this._getAllSyncCodes();
        return this._group(listOfResults, syncCode2Code);
    }

    private Map<String, Object> _addSyncCodeToSearchParams(Map<String, Object> initialSearchParameters) {
        HashMap<String, Object> commonSearchParameters = new HashMap<String, Object>(initialSearchParameters);
        String code = (String)commonSearchParameters.remove(this.getIdField());
        String lang = this._apogeeSCCHelper.getSynchronizationLang();
        String syncCode = Optional.ofNullable(this.getContent(lang, code, false)).map(this::getSyncCode).orElseThrow(() -> new IllegalArgumentException("The content with code '" + code + "' with language '" + lang + "' in catalog '" + this._apogeeSCCHelper.getSynchronizationCatalog() + "' does not have a synchronization code for SCC '" + this.getId() + "'"));
        commonSearchParameters.put("syncCode", syncCode);
        return commonSearchParameters;
    }

    private List<Map<String, Object>> _search(Map<String, Object> searchParameters) {
        ArrayList<Map<String, Object>> results = new ArrayList<Map<String, Object>>();
        results.addAll(this.searchByYear(this.getCurrentYear(), this.getCurrentYearAttributeName(), searchParameters));
        results.addAll(this.searchByYear(this.getPrecedingYear(), this.getPrecedingYearAttributeName(), searchParameters));
        return results;
    }

    private Map<String, Map<String, Object>> _group(List<Map<String, Object>> listOfResults, Map<String, String> syncCode2Code) {
        String idColumn = this.getIdColumn();
        HashMap<String, Map<String, Object>> results = new HashMap<String, Map<String, Object>>();
        for (Map<String, Object> resultFromList : listOfResults) {
            String syncCode = resultFromList.get(idColumn).toString();
            String code = syncCode2Code.get(syncCode);
            if (!StringUtils.isNotBlank((CharSequence)code)) continue;
            Map result = results.computeIfAbsent(code, __ -> new HashMap());
            result.putAll(resultFromList);
        }
        return results;
    }

    protected List<Map<String, Object>> searchByYear(String year, String yearAttributeName, Map<String, Object> searchParameters) {
        if (StringUtils.isBlank((CharSequence)year)) {
            return List.of();
        }
        HashMap<String, Object> searchParametersForYear = new HashMap<String, Object>(searchParameters);
        searchParametersForYear.put("yearValue", year);
        searchParametersForYear.put("attributeName", yearAttributeName);
        return this.executeApogeeRequest(searchParametersForYear);
    }

    protected String getSyncCode(Content content) {
        return (String)content.getValue(this.getSyncCodeItemName());
    }

    protected abstract String getSyncCodeItemName();

    protected abstract List<Map<String, Object>> executeApogeeRequest(Map<String, Object> var1);

    protected List<Expression> _getExpressionsList(String lang, String idValue, String contentType, boolean forceStrictCheck) {
        List expList = super._getExpressionsList(lang, idValue, contentType, forceStrictCheck);
        String catalog = this._apogeeSCCHelper.getSynchronizationCatalog();
        if (catalog != null) {
            expList.add(new StringExpression("catalog", Expression.Operator.EQ, catalog));
        }
        return expList;
    }

    protected ModifiableContent _importContent(String idValue, Map<String, Object> additionalParameters, String lang, Map<String, List<Object>> remoteValues, Logger logger) throws Exception {
        throw new UnsupportedOperationException("The method _importContent is not handled by PreviousYearsSCC. The previous years fields can only be synchronized.");
    }

    protected void ensureTitleIsPresent(Content content, Map<String, List<Object>> remoteValues, Logger logger) {
        remoteValues.put("title", List.of(content.getTitle()));
    }

    private Map<String, String> _getAllSyncCodes() {
        HashMap<String, String> syncCode2Code = new HashMap<String, String>();
        this.getContents().forEach(content -> {
            String syncCode = this.getSyncCode((Content)content);
            if (StringUtils.isNotEmpty((CharSequence)syncCode)) {
                syncCode2Code.put(syncCode, (String)content.getValue(this.getIdField()));
            }
        });
        return syncCode2Code;
    }
}

