/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfsync.cdmfr.components.impl;

import com.opensymphony.workflow.WorkflowException;
import java.lang.reflect.Array;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.ametys.cms.contenttype.ContentType;
import org.ametys.cms.data.holder.impl.DefaultModifiableModelAwareDataHolder;
import org.ametys.cms.repository.Content;
import org.ametys.cms.repository.ContentQueryHelper;
import org.ametys.cms.repository.ContentTypeExpression;
import org.ametys.cms.repository.LanguageExpression;
import org.ametys.cms.repository.ModifiableContent;
import org.ametys.cms.repository.WorkflowAwareContent;
import org.ametys.odf.enumeration.OdfReferenceTableEntry;
import org.ametys.odf.program.Program;
import org.ametys.odf.program.ProgramPart;
import org.ametys.odf.program.SubProgram;
import org.ametys.plugins.odfsync.cdmfr.ImportCDMFrContext;
import org.ametys.plugins.odfsync.cdmfr.components.impl.RemoteImportCDMFrComponent;
import org.ametys.plugins.odfsync.utils.ContentWorkflowDescription;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.data.extractor.ModelAwareValuesExtractor;
import org.ametys.plugins.repository.data.holder.ModelAwareDataHolder;
import org.ametys.plugins.repository.data.holder.ModifiableModelAwareDataHolder;
import org.ametys.plugins.repository.data.holder.group.ModelAwareComposite;
import org.ametys.plugins.repository.data.holder.group.ModelAwareRepeater;
import org.ametys.plugins.repository.data.holder.group.ModelAwareRepeaterEntry;
import org.ametys.plugins.repository.data.holder.impl.DataHolderHelper;
import org.ametys.plugins.repository.data.holder.values.SynchronizationContext;
import org.ametys.plugins.repository.data.repositorydata.ModifiableRepositoryData;
import org.ametys.plugins.repository.model.CompositeDefinition;
import org.ametys.plugins.repository.model.ViewHelper;
import org.ametys.plugins.repository.query.expression.AndExpression;
import org.ametys.plugins.repository.query.expression.Expression;
import org.ametys.plugins.repository.query.expression.StringExpression;
import org.ametys.runtime.model.ElementDefinition;
import org.ametys.runtime.model.Model;
import org.ametys.runtime.model.ModelItem;
import org.ametys.runtime.model.ModelItemContainer;
import org.ametys.runtime.model.View;
import org.ametys.runtime.model.ViewItemAccessor;
import org.ametys.runtime.model.ViewItemContainer;
import org.ametys.runtime.model.type.ElementType;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CoAccreditedRemoteImportCDMFrComponent
extends RemoteImportCDMFrComponent {
    protected static final String SHARED_PROGRAMS_NODE_NAME = "shared-programs";
    protected Set<String> _mentionAttributePaths;
    protected Set<String> _attributePathsToMerge;
    protected ContentType _mentionContentType;
    protected String _mentionId;
    protected String _programToLinkCode;
    protected ContentType _subProgramContentType;
    protected boolean _handleSharedSubPrograms;

    @Override
    public void configure(Configuration configuration) throws ConfigurationException {
        super.configure(configuration);
        if ("co-accredited".equals(configuration.getName())) {
            this._configureCoAccreditedParams(configuration);
        } else {
            this._configureCoAccreditedParams(configuration.getChild("co-accredited"));
        }
    }

    protected void _configureCoAccreditedParams(Configuration configuration) throws ConfigurationException {
        Configuration attributesConf;
        Configuration attributesConf2;
        this._mentionAttributePaths = new HashSet<String>();
        Configuration mentionConf = configuration.getChild("mention");
        if (mentionConf != null && (attributesConf2 = mentionConf.getChild("attributes-to-copy")) != null) {
            for (Configuration attributeConf : attributesConf2.getChildren()) {
                String attributePath = attributeConf.getAttribute("path");
                this._mentionAttributePaths.add(attributePath);
            }
        }
        this._attributePathsToMerge = new HashSet<String>();
        Configuration sharedWithConf = configuration.getChild("shared-with");
        if (sharedWithConf != null && (attributesConf = sharedWithConf.getChild("attributes-to-merge")) != null) {
            for (Configuration attributeConf : attributesConf.getChildren()) {
                String attributePath = attributeConf.getAttribute("path");
                this._attributePathsToMerge.add(attributePath);
            }
        }
    }

    @Override
    public void initialize() throws Exception {
        super.initialize();
        this._mentionContentType = (ContentType)this._contentTypeEP.getExtension(ContentWorkflowDescription.PROGRAM_WF_DESCRIPTION.getContentType());
        this._subProgramContentType = (ContentType)this._contentTypeEP.getExtension(ContentWorkflowDescription.SUBPROGRAM_WF_DESCRIPTION.getContentType());
    }

    @Override
    protected void additionalParameters(Map<String, Object> parameters) {
        this._mentionId = null;
        String sharedSubProgramType = (String)parameters.get("shared.subprogram.type");
        this._handleSharedSubPrograms = sharedSubProgramType != null && !"NONE".equalsIgnoreCase(sharedSubProgramType);
        super.additionalParameters(parameters);
    }

    @Override
    public ModifiableContent importOrSynchronizeContent(Element contentElement, ContentWorkflowDescription wfDescription, String title, String syncCode, ImportCDMFrContext context) {
        ModifiableContent content = null;
        if (contentElement.getLocalName().equals("program")) {
            String educationKind = this._xPathProcessor.evaluateAsString((Node)contentElement, "educationKind");
            String mention = this._xPathProcessor.evaluateAsString((Node)contentElement, "mention");
            if (StringUtils.isNotBlank((CharSequence)mention) && "parcours".equals(educationKind)) {
                Program mentionProgram = this._getOrCreateMention(contentElement, mention, syncCode, context);
                this._mentionId = mentionProgram.getId();
                this._programToLinkCode = syncCode;
                if (this._handleSharedSubPrograms) {
                    content = this._importOrSynchronizeSharedSubProgram(mentionProgram, contentElement, title, syncCode, context);
                }
            }
        }
        if (content == null) {
            content = super.importOrSynchronizeContent(contentElement, wfDescription, title, syncCode, context);
        }
        if (this._mentionId != null && content instanceof SubProgram && this._programToLinkCode.equals(content.getValue(this.getIdField()))) {
            Program mention = (Program)this._resolver.resolveById(this._mentionId);
            this._updateMentionAttributes(mention, (SubProgram)content, context);
        }
        return content;
    }

    protected Program _getOrCreateMention(Element contentElement, String mentionCode, String syncCode, ImportCDMFrContext context) {
        String mentionType;
        String degreeCodeCDM = this._xPathProcessor.evaluateAsString((Node)contentElement, "degree");
        OdfReferenceTableEntry degreeContent = this._odfRefTableHelper.getItemFromCDM("odf-enumeration.Degree", degreeCodeCDM);
        String degreeCode = degreeContent != null ? degreeContent.getCode() : degreeCodeCDM;
        String string = mentionType = degreeContent != null ? this._odfRefTableHelper.getMentionForDegree(degreeContent.getId()) : null;
        if (mentionType != null) {
            String mentionId = this.getIdFromCDMThenCode(mentionType, mentionCode);
            if (mentionId != null) {
                String degreeId = this.getIdFromCDMThenCode("odf-enumeration.Degree", degreeCode);
                Program mention = this._getMention(mentionId, degreeId, context);
                if (mention == null) {
                    mention = this._createMention(contentElement, mentionId, syncCode, context);
                    this._importedContents.put(mention.getId(), ContentWorkflowDescription.PROGRAM_WF_DESCRIPTION.getValidationActionId());
                }
                return mention;
            }
            context.getLogger().error("Il n'y a pas de code associ\u00e9 \u00e0 la mention {}. La formation n'a pas \u00e9t\u00e9 import\u00e9e.", (Object)mentionCode);
            ++this._nbError;
        } else {
            context.getLogger().error("Il n'y a pas de type de mention (licence, licence pro, master) associ\u00e9e au dipl\u00f4me {}. La formation n'a pas \u00e9t\u00e9 import\u00e9e.", (Object)degreeCode);
            ++this._nbError;
        }
        return null;
    }

    protected Program _getMention(String mentionId, String degreeId, ImportCDMFrContext context) {
        ArrayList<Object> expList = new ArrayList<Object>();
        expList.add(new ContentTypeExpression(Expression.Operator.EQ, new String[]{"org.ametys.plugins.odf.Content.program"}));
        expList.add(new LanguageExpression(Expression.Operator.EQ, context.getLang()));
        expList.add(new StringExpression("catalog", Expression.Operator.EQ, context.getCatalog()));
        expList.add(new StringExpression("degree", Expression.Operator.EQ, degreeId));
        expList.add(new StringExpression("mention", Expression.Operator.EQ, mentionId));
        AndExpression andExp = new AndExpression(expList.toArray(new Expression[expList.size()]));
        String xPathQuery = ContentQueryHelper.getContentXPathQuery((Expression)andExp);
        AmetysObjectIterable contents = this._resolver.query(xPathQuery);
        if (contents.getSize() > 0L) {
            return (Program)contents.iterator().next();
        }
        return null;
    }

    protected Program _createMention(Element contentElement, String mentionId, String syncCode, ImportCDMFrContext context) {
        String contentTitle = this._odfRefTableHelper.getItemLabel(mentionId, context.getLang());
        ContentWorkflowDescription wfDescription = ContentWorkflowDescription.PROGRAM_WF_DESCRIPTION;
        Program mention = null;
        try {
            mention = (Program)this._createContent(wfDescription, contentTitle, context);
        }
        catch (WorkflowException e) {
            context.getLogger().error("Failed to initialize workflow for content {} and language {}", new Object[]{contentTitle, context.getLang(), e});
            ++this._nbError;
        }
        if (mention != null) {
            try {
                this._sccHelper.updateSCCProperty((Content)mention, context.getSCC().getId());
                mention.saveChanges();
                ModelAwareValuesExtractor valuesExtractor = this._valuesExtractorFactory.getMentionValuesExtractor(contentElement, this, context);
                View mentionView = this._createMentionView();
                Map values = valuesExtractor.extractValues(mentionView);
                values.put("mention", mentionId);
                this._editContent((WorkflowAwareContent)mention, Optional.empty(), values, true, Set.of(), context);
            }
            catch (Exception e) {
                ++this._nbError;
                context.getLogger().error("Failed to synchronize data for mention {} and language {}.", new Object[]{mention, context.getLang(), e});
            }
        }
        return mention;
    }

    protected View _createMentionView() {
        HashSet<String> itemPaths = new HashSet<String>(this._mentionAttributePaths);
        itemPaths.add("degree");
        itemPaths.add("domain");
        return View.of((Model)this._mentionContentType, (String[])itemPaths.toArray(new String[itemPaths.size()]));
    }

    protected ModifiableContent _importOrSynchronizeSharedSubProgram(Program mentionProgram, Element contentElement, String title, String syncCode, ImportCDMFrContext context) {
        ModifiableContent subProgram = this.getContent(ContentWorkflowDescription.SUBPROGRAM_WF_DESCRIPTION.getContentType(), syncCode, context);
        SubProgram mainSubProgram = this._getSameSubProgram(mentionProgram, contentElement, context);
        boolean create = false;
        if (subProgram != null || mainSubProgram == null) {
            mainSubProgram = (SubProgram)super.importOrSynchronizeContent(contentElement, ContentWorkflowDescription.SUBPROGRAM_WF_DESCRIPTION, title, syncCode, context);
            if (subProgram == null) {
                create = true;
            }
        }
        View mergeView = this._createMergeView(this._attributePathsToMerge, context);
        String sharedSubProgramCode = this._xPathProcessor.evaluateAsString((Node)contentElement, "code");
        Map<String, Object> valuesToMerge = this._extractValuesToMerge(contentElement, mergeView, sharedSubProgramCode, context);
        try {
            this._synchronizeAttributesToMergeOnSharedSubProgramNode(mainSubProgram, sharedSubProgramCode, mergeView, valuesToMerge, context);
            Map<String, Object> mergedValues = this._getMergedAttributes(mainSubProgram, mergeView);
            this._editContent((WorkflowAwareContent)mainSubProgram, Optional.of(mergeView), mergedValues, create, Set.of(), context);
        }
        catch (WorkflowException e) {
            ++this._nbError;
            context.getLogger().warn("Impossible de synchronizer les attributs partag\u00e9s pour le parcours principal '" + String.valueOf(mainSubProgram) + "'");
        }
        return mainSubProgram;
    }

    protected SubProgram _getSameSubProgram(Program mentionProgram, Element contentElement, ImportCDMFrContext context) {
        String contentTitle = this._xPathProcessor.evaluateAsString((Node)contentElement, "title");
        for (ProgramPart child : mentionProgram.getProgramPartChildren()) {
            SubProgram subProgram;
            if (!(child instanceof SubProgram) || !this._getNormalizeTitle((subProgram = (SubProgram)child).getTitle()).equals(this._getNormalizeTitle(contentTitle))) continue;
            return subProgram;
        }
        return null;
    }

    private String _getNormalizeTitle(String title) {
        return Normalizer.normalize(title.toLowerCase(), Normalizer.Form.NFD).replaceAll("[\\p{InCombiningDiacriticalMarks}]", "");
    }

    @Override
    protected Map<String, Object> _getAdditionalValuesToSynchronize(ModifiableContent content, String syncCode, ImportCDMFrContext context) {
        Map<String, Object> additionalValues = super._getAdditionalValuesToSynchronize(content, syncCode, context);
        if (this._mentionId != null && content instanceof SubProgram && syncCode.equals(this._programToLinkCode)) {
            additionalValues.put("parentProgramParts", new String[]{this._mentionId});
        }
        return additionalValues;
    }

    @Override
    protected Set<String> _getNotSynchronizedRelatedContentIds(ModifiableContent content, String syncCode, ImportCDMFrContext context) {
        Set<String> contentIds = super._getNotSynchronizedRelatedContentIds(content, syncCode, context);
        if (this._mentionId != null && content instanceof SubProgram && syncCode.equals(this._programToLinkCode)) {
            contentIds.add(this._mentionId);
        }
        return contentIds;
    }

    protected View _createMergeView(Set<String> attributePathsToMerge, ImportCDMFrContext context) {
        HashSet<String> attributePaths = new HashSet<String>();
        for (String attributePathToMerge : attributePathsToMerge) {
            if (!this.isValidAttributePath(this._subProgramContentType, attributePathToMerge, context)) continue;
            attributePaths.add(attributePathToMerge);
        }
        return View.of((Model)this._subProgramContentType, (String[])attributePaths.toArray(new String[attributePaths.size()]));
    }

    protected boolean isValidAttributePath(ContentType contentType, String attributePath, ImportCDMFrContext context) {
        Logger logger = context.getLogger();
        if (!contentType.hasModelItem(attributePath)) {
            String warn = "L'attribut '" + attributePath + "' n'existe pas. il sera ignor\u00e9 lors de la fusion de parcours partag\u00e9s.";
            logger.warn(warn);
            return false;
        }
        ModelItem modelItem = contentType.getModelItem(attributePath);
        if (modelItem instanceof ElementDefinition && !((ElementDefinition)modelItem).isMultiple()) {
            String warn = "L'attribut '" + attributePath + "' n'est pas multiple. il sera ignor\u00e9 lors de la fusion de parcours partag\u00e9s.";
            logger.warn(warn);
            return false;
        }
        if (modelItem instanceof CompositeDefinition) {
            String warn = "L'attribut '" + attributePath + "' n'est pas multiple. il sera ignor\u00e9 lors de la fusion de parcours partag\u00e9s.";
            logger.warn(warn);
            return false;
        }
        return true;
    }

    protected Map<String, Object> _extractValuesToMerge(Element contentElement, View mergeView, String sharedSubProgramCode, ImportCDMFrContext context) {
        try {
            ModelAwareValuesExtractor valuesExtractor = this._valuesExtractorFactory.getSharedSubProgramValuesExtractor(contentElement, this, context);
            return valuesExtractor.extractValues(mergeView);
        }
        catch (Exception e) {
            ++this._nbError;
            context.getLogger().error("Failed to extract values to merge from content {} and language {}.", new Object[]{sharedSubProgramCode, context.getLang(), e});
            return Map.of();
        }
    }

    protected void _synchronizeAttributesToMergeOnSharedSubProgramNode(SubProgram mainSubProgram, String sharedSubProgramCode, View mergeView, Map<String, Object> valuesToMerge, ImportCDMFrContext context) {
        Map convertedValues = DataHolderHelper.convertValues((ViewItemAccessor)mergeView, valuesToMerge);
        ModifiableRepositoryData rootRepositoryData = this._getSharedSubProgramRootRepositoryData(mainSubProgram);
        ModifiableModelAwareDataHolder sharedDataHolder = this._getSharedSubProgramDataHolder(rootRepositoryData, mainSubProgram, sharedSubProgramCode);
        sharedDataHolder.synchronizeValues((ViewItemAccessor)mergeView, convertedValues, SynchronizationContext.newInstance());
    }

    protected Map<String, Object> _getMergedAttributes(SubProgram mainSubProgram, View mergeView) {
        ArrayList<ModifiableModelAwareDataHolder> sharedSubPrograms = new ArrayList<ModifiableModelAwareDataHolder>();
        ModifiableRepositoryData rootRepositoryData = this._getSharedSubProgramRootRepositoryData(mainSubProgram);
        for (String subProgramCode : rootRepositoryData.getDataNames("")) {
            ModifiableModelAwareDataHolder sharedSubProgram = this._getSharedSubProgramDataHolder(rootRepositoryData, mainSubProgram, subProgramCode);
            sharedSubPrograms.add(sharedSubProgram);
        }
        return this._getMergedAttributes(sharedSubPrograms, (ViewItemContainer)mergeView);
    }

    private Map<String, Object> _getMergedAttributes(Collection<? extends ModelAwareDataHolder> dataHolders, ViewItemContainer viewItemContainer) {
        HashMap<String, Object> results = new HashMap<String, Object>();
        ViewHelper.visitView((ViewItemAccessor)viewItemContainer, (element, definition) -> {
            String name = definition.getName();
            LinkedHashSet<Object> result = new LinkedHashSet<Object>();
            for (ModelAwareDataHolder dataHolder : dataHolders) {
                if (!dataHolder.hasValue(name)) continue;
                Object values = dataHolder.getValue(name);
                for (int i = 0; i < Array.getLength(values); ++i) {
                    Object value = Array.get(values, i);
                    if (this._containsValue((ElementDefinition)definition, (Set<Object>)result, value)) continue;
                    result.add(value);
                }
            }
            results.put(name, result);
        }, (group, definition) -> {
            String name = definition.getName();
            ArrayList<ModelAwareComposite> composites = new ArrayList<ModelAwareComposite>();
            for (ModelAwareDataHolder dataHolder : dataHolders) {
                if (!dataHolder.hasValue(name)) continue;
                ModelAwareComposite composite = dataHolder.getComposite(name);
                composites.add(composite);
            }
            results.put(name, this._getMergedAttributes(composites, (ViewItemContainer)group));
        }, (group, definition) -> {
            String name = definition.getName();
            ArrayList<Map> result = new ArrayList<Map>();
            for (ModelAwareDataHolder dataHolder : dataHolders) {
                if (!dataHolder.hasValue(name)) continue;
                ModelAwareRepeater repeater = dataHolder.getRepeater(name);
                for (ModelAwareRepeaterEntry repeaterEntry : repeater.getEntries()) {
                    Map repeaterEntryAsMap = repeaterEntry.dataToMap();
                    result.add(repeaterEntryAsMap);
                }
            }
            results.put(name, result);
        }, group -> results.putAll(this._getMergedAttributes(dataHolders, (ViewItemContainer)group)));
        return results;
    }

    private boolean _containsValue(ElementDefinition definition, Set<Object> values, Object valueToCheck) {
        ElementType type = definition.getType();
        for (Object value : values) {
            if (type.compareValues(value, valueToCheck).count() > 0L) continue;
            return true;
        }
        return false;
    }

    protected ModifiableRepositoryData _getSharedSubProgramRootRepositoryData(SubProgram mainSubProgram) {
        ModifiableRepositoryData repositoryData = mainSubProgram.getRepositoryData();
        if (repositoryData.hasValue(SHARED_PROGRAMS_NODE_NAME, "ametys-internal")) {
            return repositoryData.getRepositoryData(SHARED_PROGRAMS_NODE_NAME, "ametys-internal");
        }
        mainSubProgram.setLockInfoOnCurrentContext();
        return repositoryData.addRepositoryData(SHARED_PROGRAMS_NODE_NAME, "ametys:compositeMetadata", "ametys-internal");
    }

    protected ModifiableModelAwareDataHolder _getSharedSubProgramDataHolder(ModifiableRepositoryData rootRepositoryData, SubProgram mainSubProgram, String subProgramCode) {
        ModifiableRepositoryData repositoryData;
        if (rootRepositoryData.hasValue(subProgramCode, "")) {
            repositoryData = rootRepositoryData.getRepositoryData(subProgramCode, "");
        } else {
            mainSubProgram.setLockInfoOnCurrentContext();
            repositoryData = rootRepositoryData.addRepositoryData(subProgramCode, "ametys:compositeMetadata", "");
        }
        ContentType contentType = (ContentType)this._contentTypeEP.getExtension("org.ametys.plugins.odf.Content.subProgram");
        return new DefaultModifiableModelAwareDataHolder(repositoryData, (ModelItemContainer)contentType, Optional.of(mainSubProgram));
    }

    protected void _updateMentionAttributes(Program mention, SubProgram subProgram, ImportCDMFrContext context) {
        List orgUnitsToAdd;
        List orgUnits = mention.getOrgUnits();
        if (!CollectionUtils.containsAll((Collection)orgUnits, (Collection)(orgUnitsToAdd = subProgram.getOrgUnits()))) {
            try {
                View view = View.of((Model)this._mentionContentType, (String[])new String[]{"orgUnit"});
                List newOrgUnitIds = ListUtils.union((List)orgUnits, (List)orgUnitsToAdd);
                HashMap<String, Object> values = new HashMap<String, Object>();
                values.put("orgUnit", newOrgUnitIds.toArray(new String[newOrgUnitIds.size()]));
                this._editContent((WorkflowAwareContent)mention, Optional.of(view), values, false, Set.of(), context);
            }
            catch (WorkflowException e) {
                context.getLogger().error("Failed to synchronize data for mention {} and language {}.", new Object[]{mention, context.getLang(), e});
                ++this._nbError;
            }
        }
    }
}

