/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfsync.scc;

import java.util.Map;
import java.util.Set;
import org.ametys.cms.repository.Content;
import org.ametys.cms.repository.ModifiableContent;
import org.ametys.odf.catalog.CopyCatalogUpdater;
import org.ametys.odf.program.ProgramTranslationUpdater;
import org.ametys.plugins.contentio.synchronize.SynchronizableContentsCollectionHelper;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public class SCCCopyUpdater
extends AbstractLogEnabled
implements CopyCatalogUpdater,
ProgramTranslationUpdater,
Serviceable {
    protected AmetysObjectResolver _resolver;
    protected SynchronizableContentsCollectionHelper _sccHelper;

    public void service(ServiceManager manager) throws ServiceException {
        this._resolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
        this._sccHelper = (SynchronizableContentsCollectionHelper)manager.lookup(SynchronizableContentsCollectionHelper.ROLE);
    }

    public void updateContents(String initialCatalogName, String newCatalogName, Map<Content, Content> copiedContents, Content targetParentContent) {
        for (Content initialContent : copiedContents.keySet()) {
            Content createdContent;
            Set synchronizableCollectionIds = this._sccHelper.getSynchronizableCollectionIds(initialContent);
            if (synchronizableCollectionIds.isEmpty() || !((createdContent = copiedContents.get(initialContent)) instanceof ModifiableContent)) continue;
            ModifiableContent modifiableCreatedContent = (ModifiableContent)createdContent;
            for (String sccId : synchronizableCollectionIds) {
                this._sccHelper.updateSCCProperty((Content)modifiableCreatedContent, sccId);
            }
            modifiableCreatedContent.saveChanges();
        }
    }
}

