/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfsync.cdmfr;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.ametys.cms.repository.ModifiableContent;
import org.ametys.core.schedule.progression.ContainerProgressionTracker;
import org.ametys.core.schedule.progression.SimpleProgressionTracker;
import org.ametys.core.util.DateUtils;
import org.ametys.plugins.contentio.synchronize.SynchronizableContentsCollection;
import org.ametys.plugins.odfsync.cdmfr.AbstractCDMFrSynchronizableContentsCollection;
import org.ametys.plugins.odfsync.cdmfr.CDMFrFileFilter;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.runtime.config.Config;
import org.ametys.runtime.i18n.I18nizableText;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.Context;
import org.apache.commons.collections.SetUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.io.comparator.LastModifiedFileComparator;
import org.apache.commons.io.comparator.NameFileComparator;
import org.apache.commons.io.comparator.SizeFileComparator;
import org.slf4j.Logger;

public class CDMFrSynchronizableContentsCollection
extends AbstractCDMFrSynchronizableContentsCollection
implements Contextualizable {
    protected static final String __PARAM_FOLDER = "folder";
    private static final String _CRITERIA_FILENAME = "filename";
    private static final String _CRITERIA_LAST_MODIFIED_AFTER = "lastModifiedAfter";
    private static final String _CRITERIA_LAST_MODIFIED_BEFORE = "lastModifiedBefore";
    private static final String _COLUMN_FILENAME = "filename";
    private static final String _COLUMN_LAST_MODIFIED = "lastModified";
    private static final String _COLUMN_LENGTH = "length";
    private static final Map<String, Comparator<File>> _NAME_TO_COMPARATOR = new HashMap<String, Comparator<File>>();
    protected Context _cocoonContext;
    protected File _cdmfrFolder;
    protected String _odfLang;
    protected Set<String> _updatedContents;

    public void contextualize(org.apache.avalon.framework.context.Context context) throws ContextException {
        this._cocoonContext = (Context)context.get((Object)"environment-context");
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        super.configure(configuration);
        this._updatedContents = new HashSet<String>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List<ModifiableContent> _internalPopulate(Logger logger, ContainerProgressionTracker progressionTracker) {
        this._updatedContents.clear();
        try {
            this._startHandleCDMFR();
            SimpleProgressionTracker progressionTrackerCDMfrFiles = progressionTracker.addSimpleStep("files", new I18nizableText("plugin.odf-sync", "PLUGINS_ODF_SYNC_GLOBAL_SYNCHRONIZATION_CDMFR_STEP_LABEL"));
            ArrayList<ModifiableContent> contents = new ArrayList<ModifiableContent>();
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("validateAfterImport", this.validateAfterImport());
            parameters.put("removalSync", this.removalSync());
            parameters.put("contentPrefix", this.getContentPrefix());
            parameters.put("collectionId", this.getId());
            File[] cdmfrFiles = this._cdmfrFolder.listFiles(new CDMFrFileFilter(null, null, null));
            progressionTrackerCDMfrFiles.setSize((long)cdmfrFiles.length);
            for (File cdmfrFile : cdmfrFiles) {
                Map<String, Object> resultMap = this._handleFile(cdmfrFile, parameters, logger);
                if (resultMap.containsKey("importedPrograms")) {
                    contents.addAll((List)resultMap.remove("importedPrograms"));
                }
                parameters.putAll(resultMap);
                progressionTrackerCDMfrFiles.increment();
            }
            this._updatedContents.addAll(parameters.getOrDefault("updatedContents", SetUtils.EMPTY_SET));
            this._nbCreatedContents += ((Integer)parameters.getOrDefault("nbCreatedContents", 0)).intValue();
            this._nbSynchronizedContents += ((Integer)parameters.getOrDefault("nbSynchronizedContents", 0)).intValue();
            this._nbError += ((Integer)parameters.getOrDefault("nbError", 0)).intValue();
            ArrayList<ModifiableContent> arrayList = contents;
            return arrayList;
        }
        finally {
            this._endHandleCDMFR(this._updatedContents);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ModifiableContent> importContent(String idValue, Map<String, Object> additionalParameters, Logger logger) throws Exception {
        block5: {
            this._updatedContents.clear();
            try {
                this._startHandleCDMFR();
                File cdmfrFile = new File(this._cdmfrFolder, idValue);
                if (!cdmfrFile.exists()) {
                    logger.error("The file '{}' doesn't exists in the repository '{}'.", (Object)idValue, (Object)this._cdmfrFolder.getAbsolutePath());
                    break block5;
                }
                if (!cdmfrFile.isFile()) {
                    logger.error("The element '{}' is not a file.", (Object)cdmfrFile.getAbsolutePath());
                    break block5;
                }
                HashMap<String, Object> parameters = new HashMap<String, Object>();
                parameters.put("validateAfterImport", this.validateAfterImport());
                parameters.put("removalSync", this.removalSync());
                parameters.put("contentPrefix", this.getContentPrefix());
                parameters.put("collectionId", this.getId());
                Map<String, Object> resultMap = this._handleFile(cdmfrFile, parameters, logger);
                this._updatedContents.addAll((Set)resultMap.getOrDefault("updatedContents", SetUtils.EMPTY_SET));
                this._nbCreatedContents += ((Integer)resultMap.getOrDefault("nbCreatedContents", 0)).intValue();
                this._nbSynchronizedContents += ((Integer)resultMap.getOrDefault("nbSynchronizedContents", 0)).intValue();
                this._nbError += ((Integer)resultMap.getOrDefault("nbError", 0)).intValue();
                List<ModifiableContent> list = resultMap.getOrDefault("importedPrograms", Collections.emptyList());
                return list;
            }
            finally {
                this._endHandleCDMFR(this._updatedContents);
            }
        }
        return null;
    }

    protected Map<String, Object> _handleFile(File cdmfrFile, Map<String, Object> parameters, Logger logger) {
        block9: {
            Map<String, Object> map;
            String absolutePath = cdmfrFile.getAbsolutePath();
            logger.info("Processing CDM-fr file '{}'", (Object)absolutePath);
            FileInputStream fis = new FileInputStream(cdmfrFile);
            try {
                map = this._importCDMFrComponent.handleInputStream(fis, parameters, (SynchronizableContentsCollection)this, logger);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ((InputStream)fis).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    logger.error("An error occured while reading or closing the file {}.", (Object)absolutePath, (Object)e);
                    break block9;
                }
                catch (ProcessingException e) {
                    logger.error("An error occured while handling the file {}.", (Object)absolutePath, (Object)e);
                    break block9;
                }
                catch (Exception e) {
                    logger.error("An unknown error happens while handling the file {}.", (Object)absolutePath, (Object)e);
                }
            }
            ((InputStream)fis).close();
            return map;
        }
        return new HashMap<String, Object>();
    }

    @Override
    public Map<String, Map<String, Object>> search(Map<String, Object> searchParameters, int offset, int limit, List<Object> sort, Logger logger) {
        File[] cdmfrFiles = this.internalSearch(searchParameters, logger);
        cdmfrFiles = this._sortFiles(cdmfrFiles, sort);
        int i = 0;
        LinkedHashMap<String, Map<String, Object>> files = new LinkedHashMap<String, Map<String, Object>>();
        for (File cdmfrFile : cdmfrFiles) {
            if (i >= offset && i < offset + limit) {
                HashMap<String, Object> file = new HashMap<String, Object>();
                file.put("scc$uniqueid", cdmfrFile.getName());
                file.put("filename", cdmfrFile.getName());
                file.put(_COLUMN_LAST_MODIFIED, DateUtils.dateToString((Date)new Date(cdmfrFile.lastModified())));
                file.put(_COLUMN_LENGTH, cdmfrFile.length());
                files.put(cdmfrFile.getName(), file);
            } else if (i >= offset + limit) break;
            ++i;
        }
        return files;
    }

    @Override
    public int getTotalCount(Map<String, Object> searchParameters, Logger logger) {
        return this.internalSearch(searchParameters, logger).length;
    }

    private File[] _sortFiles(File[] files, List<Object> sortList) {
        if (sortList != null) {
            for (Object sortValueObj : Lists.reverse(sortList)) {
                Map sortValue = (Map)sortValueObj;
                Comparator<File> comparator = _NAME_TO_COMPARATOR.get(sortValue.get("property"));
                Object direction = sortValue.get("direction");
                if (direction != null && direction.toString().equalsIgnoreCase("DESC")) {
                    comparator = Collections.reverseOrder(comparator);
                }
                Arrays.sort(files, comparator);
            }
        }
        return files;
    }

    protected File[] internalSearch(Map<String, Object> searchParameters, Logger logger) {
        String filename = null;
        Date lastModifiedAfter = null;
        Date lastModifiedBefore = null;
        if (searchParameters != null && !searchParameters.isEmpty()) {
            filename = MapUtils.getString(searchParameters, (Object)"filename");
            lastModifiedAfter = DateUtils.parse((String)MapUtils.getString(searchParameters, (Object)_CRITERIA_LAST_MODIFIED_AFTER));
            lastModifiedBefore = DateUtils.parse((String)MapUtils.getString(searchParameters, (Object)_CRITERIA_LAST_MODIFIED_BEFORE));
        }
        CDMFrFileFilter filter = new CDMFrFileFilter(filename, lastModifiedAfter, lastModifiedBefore);
        return this._cdmfrFolder.listFiles(filter);
    }

    @Override
    protected void configureDataSource(Configuration configuration) throws ConfigurationException {
        this.configureSpecificParameters();
        this._odfLang = (String)Config.getInstance().getValue("odf.programs.lang");
    }

    protected void configureSpecificParameters() {
        String cdmfrFolderPath = this.getParameterValues().get(__PARAM_FOLDER).toString();
        this._cdmfrFolder = new File(cdmfrFolderPath);
        if (!this._cdmfrFolder.isAbsolute()) {
            this._cdmfrFolder = new File(this._cocoonContext.getRealPath("/" + cdmfrFolderPath));
        }
        if (!this._cdmfrFolder.isDirectory()) {
            throw new RuntimeException("The path '" + cdmfrFolderPath + "' defined in the SCC '" + this.getLabel().getLabel() + "' (" + this.getId() + ") is not a directory.");
        }
        if (!this._cdmfrFolder.canRead()) {
            throw new RuntimeException("The folder '" + cdmfrFolderPath + "' defined in the SCC '" + this.getLabel().getLabel() + "' (" + this.getId() + ") is not readable.");
        }
    }

    @Override
    protected void configureSearchModel() {
        this._searchModelConfiguration.displayMaskImported(false);
        this._searchModelConfiguration.addCriterion("filename", new I18nizableText("plugin.odf-sync", "PLUGINS_ODF_SYNC_IMPORT_CDMFR_CRITERIA_FILENAME"));
        this._searchModelConfiguration.addCriterion(_CRITERIA_LAST_MODIFIED_AFTER, new I18nizableText("plugin.odf-sync", "PLUGINS_ODF_SYNC_IMPORT_CDMFR_CRITERIA_LASTMODIFIED_AFTER"), "DATETIME", "edition.date");
        this._searchModelConfiguration.addCriterion(_CRITERIA_LAST_MODIFIED_BEFORE, new I18nizableText("plugin.odf-sync", "PLUGINS_ODF_SYNC_IMPORT_CDMFR_CRITERIA_LASTMODIFIED_BEFORE"), "DATETIME", "edition.date");
        this._searchModelConfiguration.addColumn("filename", new I18nizableText("plugin.odf-sync", "PLUGINS_ODF_SYNC_IMPORT_CDMFR_COLUMN_FILENAME"), 350);
        this._searchModelConfiguration.addColumn(_COLUMN_LAST_MODIFIED, new I18nizableText("plugin.odf-sync", "PLUGINS_ODF_SYNC_IMPORT_CDMFR_COLUMN_DATE"), 200, true, "DATETIME");
        this._searchModelConfiguration.addColumn(_COLUMN_LENGTH, new I18nizableText("plugin.odf-sync", "PLUGINS_ODF_SYNC_IMPORT_CDMFR_COLUMN_SIZE"), 120, true, "DOUBLE", "Ext.util.Format.fileSize");
    }

    @Override
    public ModifiableContent getContent(String lang, String idValue, boolean forceStrictCheck) {
        return null;
    }

    public boolean handleRightAssignmentContext() {
        return false;
    }

    @Override
    protected List<ModifiableContent> _getContentsToRemove(AmetysObjectIterable<ModifiableContent> contents) {
        return contents.stream().filter(content -> !this._updatedContents.contains(content.getId())).collect(Collectors.toList());
    }

    static {
        _NAME_TO_COMPARATOR.put("filename", NameFileComparator.NAME_INSENSITIVE_COMPARATOR);
        _NAME_TO_COMPARATOR.put(_COLUMN_LAST_MODIFIED, LastModifiedFileComparator.LASTMODIFIED_COMPARATOR);
        _NAME_TO_COMPARATOR.put(_COLUMN_LENGTH, SizeFileComparator.SIZE_COMPARATOR);
    }
}

