/*
 *  Copyright 2017 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * This tool allows to see items from an external datasource, in order to import them.
 * It adds the imported content to the parent.
 */
Ext.define('Ametys.plugins.odfsync.apogee.ApogeeSCCSearchTool', {
    extend: 'Ametys.plugins.contentio.search.SCCSearchTool',

    _location: new Ext.Template("{{i18n PLUGINS_ODF_SYNC_UITOOL_IMPORT_LOCATION}}", { compiled: true }),
    
    /**
     * @protected
     * @property {Ametys.message.MessageTarget} _parent The parent content
     */
     
    constructor: function(config)
    {
        this.callParent(arguments);
        
        Ametys.message.MessageBus.on(Ametys.message.Message.SELECTION_CHANGED, this._onMessageBusSelectionChanged, this);
    },
     
    createPanel: function()
    {
        var p = this.callParent(arguments);
        
        p.insert(0, {
            xtype: 'component',
            itemId: 'displayLocation',
            html: "",
            split: false,
            ui: 'tool-hintmessage'
        })
        
        return p;
    },
    
    /**
     * @protected
     * Listener when the selection of the message bus has changed
     * @param {Ametys.message.Message} [message] The selection message. Can be null to get the last selection message
     */
    _onMessageBusSelectionChanged: function(message)
    {
        message = message || Ametys.message.MessageBus.getCurrentSelectionMessage();
        
        var contentTarget = message.getTarget("content");
        if (contentTarget)
        {
            var contentTypesString = this.getParams()['content-types'];
            if (contentTypesString)
            {
                var contentTypes = contentTypesString.split(',');
                for (var i = 0; i < contentTypes.length; i++)
                {
                    if (Ext.Array.contains(contentTarget.getParameters().ancestorsOrSelfTypes, contentTypes[i]))
                    {
                        this._updateImportLocation(contentTarget);
                        return;
                    }
                }
            }
            else
            {
                // No content type specified to accept
                throw new Error("The tool " + this.getId() + " did not received a content-types params from the opening button")
            }
        }
    },
    
    /**
     * @protected
     * Set import location
     * @param {Ametys.message.MessageTarget} parent The new parent location
     */
    _updateImportLocation: function(parent)
    {
        this._parent = parent;
        
        var displayLocation = this.mainPanel.getComponent('displayLocation');
        if (parent)
        {
            displayLocation.setHtml(this._location.apply([parent.getParameters().title]));
            displayLocation.show();
            this.getWrapper().unmask();
        }
        else
        {
            displayLocation.hide();
            this.getWrapper().mask("{{i18n PLUGINS_ODF_SYNC_UITOOL_IMPORT_EMPTY_SELECTION}}", "ametys-mask-unloading");
        }
    },
    
    setParams: function(params)
    {
        this.callParent(arguments);
        this._updateImportLocation();
        this._onMessageBusSelectionChanged();
    },
    
    _getAdditionalImportParams: function()
    {
    	var addParams = this.callParent(arguments);
    	
        if (this._parent != null)
        {
            addParams = Ext.apply(addParams, {parentId: this._parent.getParameters().id});
        }
        
        return addParams;
    },
    
    _importFnCb: function(result)
    {
        if (this._parent != null)
        {
        	var parentId = this._parent.getParameters().id;
            Ext.create("Ametys.message.Message", {
                type: Ametys.message.Message.MODIFIED,
                targets: {
                id: Ametys.message.MessageTarget.CONTENT,
                    parameters: { ids: [parentId] }
                }
            });
        }
        
        this.callParent(arguments);
    }
});
