/*
 *  Copyright 2022 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.odfsync.pegase.ws;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

import org.ametys.odf.program.Program;
import org.ametys.plugins.odfsync.export.AbstractStructureComponent;
import org.ametys.plugins.odfsync.export.ExportReport;
import org.ametys.plugins.odfsync.pegase.ws.structure.PegaseProgramStructure;

/**
 * Component for Pegase export
 */
public class PegaseStructureComponent extends AbstractStructureComponent
{
    /** Avalon Role */
    public static final String ROLE = PegaseStructureComponent.class.getName();
    
    /** The PegaseProgramStructure */
    protected PegaseProgramStructure _pegaseProgramStructure;
    
    @Override
    public void service(ServiceManager manager) throws ServiceException
    {
        super.service(manager);
        _pegaseProgramStructure = (PegaseProgramStructure) manager.lookup(PegaseProgramStructure.ROLE);
    }
    
    /**
     * Get the Pegase export report of the program id
     * @param program the program
     * @return the Pegase export report
     */
    @Override
    public ExportReport getExportReport(Program program)
    {
        ExportReport report = new ExportReport(program);
        _pegaseProgramStructure.checkProgram(program, report);
        report.setExportStructure(_pegaseProgramStructure);
        return report;
    }
}
