/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfsync;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ametys.core.ui.AddTaskClientSideElement;
import org.ametys.core.ui.ClientSideElement;
import org.ametys.plugins.contentio.synchronize.SynchronizableContentsCollection;
import org.ametys.plugins.contentio.synchronize.SynchronizableContentsCollectionHelper;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

public class GlobalSynchronizationClientSideElement
extends AddTaskClientSideElement {
    protected SynchronizableContentsCollectionHelper _sccHelper;

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._sccHelper = (SynchronizableContentsCollectionHelper)smanager.lookup(SynchronizableContentsCollectionHelper.ROLE);
    }

    public List<ClientSideElement.Script> getScripts(boolean ignoreRights, Map<String, Object> contextParameters) {
        ArrayList<ClientSideElement.Script> clonedScripts = new ArrayList<ClientSideElement.Script>();
        List scripts = super.getScripts(ignoreRights, contextParameters);
        for (ClientSideElement.Script script : scripts) {
            if (!script.getParameters().containsKey("modelsToSync")) continue;
            String[] modelsToSync = ((String)script.getParameters().get("modelsToSync")).split(",");
            clonedScripts.addAll(this.getClonedScripts(script, modelsToSync));
        }
        return clonedScripts;
    }

    protected List<ClientSideElement.Script> getClonedScripts(ClientSideElement.Script script, String[] modelsToSync) {
        ArrayList<ClientSideElement.Script> clonedScripts = new ArrayList<ClientSideElement.Script>();
        for (String sccModelId : modelsToSync) {
            SynchronizableContentsCollection collection = this._sccHelper.getSCCFromModelId(sccModelId);
            if (collection == null) continue;
            ClientSideElement.Script clonedScript = new ClientSideElement.Script(script);
            HashMap<String, String> openToolParams = new HashMap<String, String>();
            openToolParams.put("collectionId", collection.getId());
            clonedScript.getParameters().put("schedulable-parameters", openToolParams);
            clonedScripts.add(clonedScript);
        }
        return clonedScripts;
    }
}

