/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfsync.pegase.scc;

import com.opensymphony.workflow.WorkflowException;
import fr.pcscol.pegase.odf.ApiException;
import fr.pcscol.pegase.odf.api.MaquettesExterneApi;
import fr.pcscol.pegase.odf.api.ObjetsMaquetteExterneApi;
import fr.pcscol.pegase.odf.externe.model.DescripteursFormation;
import fr.pcscol.pegase.odf.externe.model.DescripteursGroupement;
import fr.pcscol.pegase.odf.externe.model.DescripteursObjetFormation;
import fr.pcscol.pegase.odf.externe.model.DescripteursObjetMaquette;
import fr.pcscol.pegase.odf.externe.model.DescripteursSise;
import fr.pcscol.pegase.odf.externe.model.DescripteursSyllabus;
import fr.pcscol.pegase.odf.externe.model.EnfantsStructure;
import fr.pcscol.pegase.odf.externe.model.MaquetteStructure;
import fr.pcscol.pegase.odf.externe.model.Nomenclature;
import fr.pcscol.pegase.odf.externe.model.ObjetMaquetteDetail;
import fr.pcscol.pegase.odf.externe.model.ObjetMaquetteStructure;
import fr.pcscol.pegase.odf.externe.model.ObjetMaquetteSummary;
import fr.pcscol.pegase.odf.externe.model.Pageable;
import fr.pcscol.pegase.odf.externe.model.PagedObjetMaquetteSummaries;
import fr.pcscol.pegase.odf.externe.model.PlageDeChoix;
import fr.pcscol.pegase.odf.externe.model.TypeObjetMaquette;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ametys.cms.data.ContentSynchronizationResult;
import org.ametys.cms.data.ContentValue;
import org.ametys.cms.repository.Content;
import org.ametys.cms.repository.ContentQueryHelper;
import org.ametys.cms.repository.LanguageExpression;
import org.ametys.cms.repository.ModifiableContent;
import org.ametys.cms.repository.WorkflowAwareContent;
import org.ametys.core.schedule.progression.ContainerProgressionTracker;
import org.ametys.core.util.JSONUtils;
import org.ametys.odf.catalog.CatalogsManager;
import org.ametys.odf.cdmfr.CDMFRHandler;
import org.ametys.odf.course.Course;
import org.ametys.odf.courselist.CourseList;
import org.ametys.odf.enumeration.OdfReferenceTableEntry;
import org.ametys.odf.enumeration.OdfReferenceTableHelper;
import org.ametys.odf.program.Container;
import org.ametys.odf.program.ProgramPart;
import org.ametys.odf.program.TraversableProgramPart;
import org.ametys.odf.workflow.AbstractCreateODFContentFunction;
import org.ametys.plugins.contentio.synchronize.AbstractSimpleSynchronizableContentsCollection;
import org.ametys.plugins.odfsync.pegase.scc.PegaseSCCMappingHelper;
import org.ametys.plugins.odfsync.pegase.ws.PegaseApiManager;
import org.ametys.plugins.odfsync.utils.ContentWorkflowDescription;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.jcr.NameHelper;
import org.ametys.plugins.repository.query.expression.AndExpression;
import org.ametys.plugins.repository.query.expression.Expression;
import org.ametys.plugins.repository.query.expression.StringExpression;
import org.ametys.runtime.config.Config;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.View;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

public class PegaseSynchronizableContentsCollection
extends AbstractSimpleSynchronizableContentsCollection {
    private static final String __INSERTED_GROUPEMENT_SUFFIX = "-LIST-";
    protected JSONUtils _jsonUtils;
    protected CatalogsManager _catalogsManager;
    protected PegaseApiManager _pegaseApiManager;
    protected CDMFRHandler _cdmfrHandler;
    protected PegaseSCCMappingHelper _pegaseSccMappingHelper;
    protected OdfReferenceTableHelper _refTableHelper;
    protected Map<String, Map<String, String>> _mappingByContentType;
    protected Set<String> _searchFields;
    protected Map<String, Integer> _importedContents;
    protected Set<String> _synchronizedContents;
    protected Set<String> _updatedRelationContents;
    protected Map<String, Set<String>> _contentsChildren;
    protected String _odfLang;
    protected String _structureCode;

    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._jsonUtils = (JSONUtils)manager.lookup(JSONUtils.ROLE);
        this._catalogsManager = (CatalogsManager)manager.lookup(CatalogsManager.ROLE);
        this._pegaseApiManager = (PegaseApiManager)((Object)manager.lookup(PegaseApiManager.ROLE));
        this._cdmfrHandler = (CDMFRHandler)manager.lookup(CDMFRHandler.ROLE);
        this._pegaseSccMappingHelper = (PegaseSCCMappingHelper)((Object)manager.lookup(PegaseSCCMappingHelper.ROLE));
        this._refTableHelper = (OdfReferenceTableHelper)manager.lookup(OdfReferenceTableHelper.ROLE);
    }

    public String getIdField() {
        return "pegaseSyncCode";
    }

    protected String getIdColumn() {
        return "id";
    }

    public Set<String> getLocalAndExternalFields(Map<String, Object> additionalParameters) {
        return Optional.ofNullable(additionalParameters).map(params -> params.get("contentTypes")).filter(List.class::isInstance).map(cTypes -> (List)cTypes).filter(Predicate.not(List::isEmpty)).map(l -> (String)l.get(0)).map(this._mappingByContentType::get).map(Map::keySet).orElse(Set.of());
    }

    protected Map<String, Object> putIdParameter(String idValue) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put(this.getIdColumn(), List.of(idValue));
        return parameters;
    }

    protected void configureDataSource(Configuration configuration) throws ConfigurationException {
        this._odfLang = (String)Config.getInstance().getValue("odf.programs.lang");
        this._searchFields = new HashSet<String>();
        this._mappingByContentType = new HashMap<String, Map<String, String>>();
        if (((Boolean)Config.getInstance().getValue("pegase.activate", true, (Object)false)).booleanValue()) {
            this._structureCode = (String)Config.getInstance().getValue("pegase.structure.code");
            this._searchFields.add("libelle");
            this._searchFields.add("code");
            this._searchFields.add("espace");
            this._searchFields.add("id");
            HashMap<String, String> contentTypeMapping = new HashMap<String, String>();
            contentTypeMapping.put("title", "libelle");
            contentTypeMapping.put("pegaseCode", "code");
            contentTypeMapping.put("ects", "ects");
            contentTypeMapping.put("educationKind", "codeNatureDiplomeCode");
            contentTypeMapping.put("presentation", "description");
            contentTypeMapping.put("objectives", "objectif");
            contentTypeMapping.put("neededPrerequisite", "prerequis");
            contentTypeMapping.put("mention", "codeMention");
            contentTypeMapping.put("domain", "codeDomaineFormation");
            contentTypeMapping.put("programField", "codeChampFormation");
            contentTypeMapping.put("educationLevel", "codeNiveauFormation");
            contentTypeMapping.put("rncpLevel", "codeNiveauDiplome");
            contentTypeMapping.put("degree", "codeTypeDiplome");
            contentTypeMapping.put("orgUnit", "orgUnit");
            this._mappingByContentType.put("org.ametys.plugins.odf.Content.program", contentTypeMapping);
            contentTypeMapping = new HashMap();
            contentTypeMapping.put("title", "libelle");
            contentTypeMapping.put("pegaseCode", "code");
            contentTypeMapping.put("ects", "ects");
            contentTypeMapping.put("presentation", "description");
            contentTypeMapping.put("objectives", "objectif");
            contentTypeMapping.put("neededPrerequisite", "prerequis");
            contentTypeMapping.put("orgUnit", "orgUnit");
            this._mappingByContentType.put("org.ametys.plugins.odf.Content.subProgram", contentTypeMapping);
            contentTypeMapping = new HashMap();
            contentTypeMapping.put("title", "libelle");
            contentTypeMapping.put("pegaseCode", "code");
            contentTypeMapping.put("ects", "ects");
            contentTypeMapping.put("nature", "typeObjetFormation");
            contentTypeMapping.put("period", "typeObjetFormation");
            this._mappingByContentType.put("org.ametys.plugins.odf.Content.container", contentTypeMapping);
            contentTypeMapping = new HashMap();
            contentTypeMapping.put("title", "libelle");
            contentTypeMapping.put("pegaseCode", "code");
            contentTypeMapping.put("plageDeChoix", "plageDeChoix");
            contentTypeMapping.put("obligatoire", "obligatoire");
            contentTypeMapping.put("min", "plageMin");
            contentTypeMapping.put("max", "plageMax");
            this._mappingByContentType.put("org.ametys.plugins.odf.Content.courseList", contentTypeMapping);
            contentTypeMapping = new HashMap();
            contentTypeMapping.put("title", "libelle");
            contentTypeMapping.put("pegaseCode", "code");
            contentTypeMapping.put("ects", "ects");
            contentTypeMapping.put("description", "description");
            contentTypeMapping.put("courseType", "typeObjetFormation");
            this._mappingByContentType.put("org.ametys.plugins.odf.Content.course", contentTypeMapping);
        }
    }

    protected void configureSearchModel() {
        List<String> sortableColumns = List.of("code", "libelle");
        this._searchModelConfiguration.addCriterion("libelle", new I18nizableText("plugin.odf-sync", "PLUGINS_ODF_SYNC_PEGASE_CRITERION_LIBELLE"), "string");
        this._searchModelConfiguration.addCriterion("validee", new I18nizableText("plugin.odf-sync", "PLUGINS_ODF_SYNC_PEGASE_CRITERION_VALIDEE"), "boolean", "edition.boolean-combobox");
        for (String keptField : this._searchFields) {
            if (sortableColumns.contains(keptField)) {
                this._searchModelConfiguration.addColumn(keptField, new I18nizableText(keptField), true);
                continue;
            }
            this._searchModelConfiguration.addColumn(keptField, new I18nizableText(keptField), false);
        }
    }

    protected String getCatalog() {
        return Optional.of(this.getParameterValues()).map(params -> params.get("catalog")).map(String.class::cast).filter(StringUtils::isNotBlank).orElseGet(() -> this._catalogsManager.getDefaultCatalogName());
    }

    protected Map<String, Map<String, Object>> internalSearch(Map<String, Object> parameters, int offset, int limit, List<Object> sort, Logger logger) {
        LinkedHashMap<String, Map<String, Object>> results = new LinkedHashMap<String, Map<String, Object>>();
        try {
            List programs;
            ObjetsMaquetteExterneApi objetsMaquetteApi = this._pegaseApiManager.getObjetsMaquetteExterneApi();
            PagedObjetMaquetteSummaries pagedPrograms = this._getPagedProgramsSummaries(parameters, offset, limit, sort, objetsMaquetteApi);
            Long total = pagedPrograms.getTotalElements();
            if (total != null) {
                parameters.put("totalCount", (long)total);
            }
            if ((programs = pagedPrograms.getItems()) != null) {
                for (ObjetMaquetteSummary programSummary : programs) {
                    String pegaseSyncCode = programSummary.getId().toString();
                    Map result = results.computeIfAbsent(pegaseSyncCode, __ -> new HashMap());
                    Map<String, String> fields = this._getSummaryFields(programSummary);
                    for (String keptField : this._searchFields) {
                        String field = fields.get(keptField);
                        result.put(keptField, field);
                    }
                    result.put("scc$uniqueid", pegaseSyncCode);
                }
            }
        }
        catch (ApiException | IOException e) {
            throw new RuntimeException("Error while getting remote values", e);
        }
        return results;
    }

    public int getTotalCount(Map<String, Object> searchParameters, Logger logger) {
        Long totalCount = (Long)searchParameters.get("totalCount");
        if (totalCount != null) {
            return totalCount.intValue();
        }
        return super.getTotalCount(searchParameters, logger);
    }

    private PagedObjetMaquetteSummaries _getPagedProgramsSummaries(Map<String, Object> parameters, int offset, int limit, List<Object> sort, ObjetsMaquetteExterneApi objetsMaquetteApi) throws ApiException {
        Pageable pageable = new Pageable();
        int pageNumber = offset / 50;
        pageable.setPage(Integer.valueOf(pageNumber));
        pageable.setTaille(Integer.valueOf(limit));
        if (sort == null) {
            pageable.setTri(List.of());
        } else {
            String jsonSortParameters = this._jsonUtils.convertObjectToJson(sort.get(0));
            Map sortParameters = this._jsonUtils.convertJsonToMap(jsonSortParameters);
            ArrayList<String> sortParametersArray = new ArrayList<String>();
            StringBuilder stringBuilder = new StringBuilder();
            String property = (String)sortParameters.get("property");
            if (!"code".equals(property) && !"libelle".equals(property)) {
                if ("libelle".equals(property)) {
                    stringBuilder.append("libelle,").append((String)sortParameters.get("direction"));
                    sortParametersArray.add(stringBuilder.toString());
                }
            } else {
                stringBuilder.append(property).append(",").append((String)sortParameters.get("direction"));
                sortParametersArray.add(stringBuilder.toString());
            }
            pageable.setTri(sortParametersArray);
        }
        String searchLabel = (String)parameters.get("libelle");
        List<TypeObjetMaquette> typeObjets = List.of(TypeObjetMaquette.FORMATION);
        Boolean validated = (Boolean)parameters.get("validee");
        return objetsMaquetteApi.rechercherObjetMaquette(this._structureCode, pageable, searchLabel, null, typeObjets, null, null, null, null, null, validated, null);
    }

    private Map<String, String> _getSummaryFields(ObjetMaquetteSummary objectSummary) {
        return Map.of("id", objectSummary.getId().toString(), "code", StringUtils.defaultString((String)objectSummary.getCode()), "libelle", StringUtils.defaultString((String)objectSummary.getLibelle()), "espace", StringUtils.defaultString((String)objectSummary.getEspaceLibelle()));
    }

    protected Map<String, Map<String, List<Object>>> getRemoteValues(Map<String, Object> parameters, Logger logger) {
        LinkedHashMap<String, Map<String, List<Object>>> results = new LinkedHashMap<String, Map<String, List<Object>>>();
        List pegaseSyncCodeValues = parameters.getOrDefault(this.getIdColumn(), new ArrayList());
        ArrayList<String> idValues = new ArrayList<String>();
        try {
            ObjetsMaquetteExterneApi objetsMaquetteApi = this._pegaseApiManager.getObjetsMaquetteExterneApi();
            MaquettesExterneApi maquettesApi = this._pegaseApiManager.getMaquettesExterneApi();
            if (!pegaseSyncCodeValues.isEmpty()) {
                idValues.addAll(pegaseSyncCodeValues);
            } else {
                PagedObjetMaquetteSummaries pagedPrograms = this._getPagedProgramsSummaries(parameters, 0, Integer.MAX_VALUE, null, objetsMaquetteApi);
                for (ObjetMaquetteSummary programDetails : pagedPrograms.getItems()) {
                    idValues.add(programDetails.getId().toString());
                }
            }
            results.putAll(this._getObjectDetailsForImport(idValues, objetsMaquetteApi, maquettesApi, logger));
        }
        catch (ApiException | IOException e) {
            throw new RuntimeException("Error while getting remote values", e);
        }
        return results;
    }

    Map<String, Map<String, List<Object>>> _getObjectDetailsForImport(List<String> idValues, ObjetsMaquetteExterneApi objetsMaquetteApi, MaquettesExterneApi maquettesApi, Logger logger) throws ApiException {
        LinkedHashMap<String, Map<String, List<Object>>> results = new LinkedHashMap<String, Map<String, List<Object>>>();
        HashSet<UUID> alreadyHandledObjects = new HashSet<UUID>();
        for (String idValue : idValues) {
            MaquetteStructure maquette = maquettesApi.lireStructureMaquette(this._structureCode, UUID.fromString(idValue));
            ObjetMaquetteStructure racine = maquette.getRacine();
            results.putAll(this._getObjectDetailsForImport(racine, null, alreadyHandledObjects, objetsMaquetteApi, logger));
        }
        return results;
    }

    private Map<String, Map<String, List<Object>>> _getObjectDetailsForImport(ObjetMaquetteStructure item, EnfantsStructure structure, Set<UUID> alreadyHandledObjects, ObjetsMaquetteExterneApi objetsMaquetteApi, Logger logger) throws ApiException {
        LinkedHashMap<String, Map<String, List<Object>>> results = new LinkedHashMap<String, Map<String, List<Object>>>();
        UUID id = item.getId();
        if (alreadyHandledObjects.add(id)) {
            ObjetMaquetteDetail detail = objetsMaquetteApi.lireObjetMaquette(this._structureCode, id);
            Map<String, List<Object>> objectData = this._getObjectFields(detail, structure, item);
            ComputedChildren children = this._computeChildren(item);
            objectData.put("children", children.childrenIds());
            results.put(id.toString(), objectData);
            results.putAll(children.newObjects());
            for (EnfantsStructure child : children.nextObjects()) {
                results.putAll(this._getObjectDetailsForImport(child.getObjetMaquette(), child, alreadyHandledObjects, objetsMaquetteApi, logger));
            }
        }
        return results;
    }

    private ComputedChildren _computeChildren(ObjetMaquetteStructure item) {
        List enfants = item.getEnfants();
        ArrayList<Object> childrenIds = new ArrayList<Object>();
        ArrayList<EnfantsStructure> nextObjects = new ArrayList<EnfantsStructure>();
        HashMap<String, Map<String, List<Object>>> newObjects = new HashMap<String, Map<String, List<Object>>>();
        if (this._isProgramPart(item)) {
            List<EnfantsStructure> programPartChildren = enfants.stream().filter(e -> this._isProgramPart(e.getObjetMaquette())).toList();
            childrenIds.addAll(programPartChildren.stream().map(e -> e.getObjetMaquette().getId().toString()).toList());
            nextObjects.addAll(programPartChildren);
            this._computeIntermediateLists(item, enfants, childrenIds, nextObjects, newObjects);
            List<EnfantsStructure> listChildren = enfants.stream().filter(e -> this._isCourseList(e.getObjetMaquette())).toList();
            childrenIds.addAll(listChildren.stream().map(e -> e.getObjetMaquette().getId().toString()).toList());
            nextObjects.addAll(listChildren);
        } else if (this._isCourseList(item)) {
            List<EnfantsStructure> courseChildren = enfants.stream().filter(e -> this._isCourse(e.getObjetMaquette())).toList();
            childrenIds.addAll(courseChildren.stream().map(e -> e.getObjetMaquette().getId().toString()).toList());
            nextObjects.addAll(courseChildren);
        } else if (this._isCourse(item)) {
            this._computeIntermediateLists(item, enfants, childrenIds, nextObjects, newObjects);
            List<EnfantsStructure> listChildren = enfants.stream().filter(e -> this._isCourseList(e.getObjetMaquette())).toList();
            childrenIds.addAll(listChildren.stream().map(e -> e.getObjetMaquette().getId().toString()).toList());
            nextObjects.addAll(listChildren);
        }
        return new ComputedChildren(childrenIds, newObjects, nextObjects);
    }

    private String _getContentType(ObjetMaquetteStructure item) {
        String type = item.getType();
        if (item.getClasse().equals("F")) {
            type = "FORMATION";
        } else if (item.getClasse().equals("G")) {
            type = "GROUPEMENT";
        }
        return Optional.ofNullable(type).map(this._pegaseSccMappingHelper::getAmetysType).orElse("org.ametys.plugins.odf.Content.course");
    }

    private boolean _isProgramPart(ObjetMaquetteStructure item) {
        String contentType = this._getContentType(item);
        return contentType.equals("org.ametys.plugins.odf.Content.program") || contentType.equals("org.ametys.plugins.odf.Content.subProgram") || contentType.equals("org.ametys.plugins.odf.Content.container");
    }

    private boolean _isCourse(ObjetMaquetteStructure item) {
        return this._getContentType(item).equals("org.ametys.plugins.odf.Content.course");
    }

    private boolean _isCourseList(ObjetMaquetteStructure item) {
        return this._getContentType(item).equals("org.ametys.plugins.odf.Content.courseList");
    }

    private void _computeIntermediateLists(ObjetMaquetteStructure item, List<EnfantsStructure> enfants, List<Object> childrenIds, List<EnfantsStructure> nextObjects, Map<String, Map<String, List<Object>>> newObjects) {
        List<EnfantsStructure> courseChildren = enfants.stream().filter(e -> this._isCourse(e.getObjetMaquette()) && e.getObligatoire() != false).toList();
        this._computeIntermediateList(item, courseChildren, true, childrenIds, nextObjects, newObjects);
        courseChildren = enfants.stream().filter(e -> this._isCourse(e.getObjetMaquette()) && e.getObligatoire() == false).toList();
        this._computeIntermediateList(item, courseChildren, false, childrenIds, nextObjects, newObjects);
    }

    private void _computeIntermediateList(ObjetMaquetteStructure item, List<EnfantsStructure> courseChildren, boolean mandatory, List<Object> childrenIds, List<EnfantsStructure> nextObjects, Map<String, Map<String, List<Object>>> newObjects) {
        if (!courseChildren.isEmpty()) {
            String listId = String.valueOf(item.getId()) + __INSERTED_GROUPEMENT_SUFFIX + (mandatory ? "O" : "F");
            childrenIds.add(listId);
            HashMap<String, List<Object>> listData = new HashMap<String, List<Object>>();
            listData.put("workflowDescription", List.of(ContentWorkflowDescription.COURSELIST_WF_DESCRIPTION));
            listData.put(this.getIdField(), List.of(listId));
            listData.put("title", List.of(item.getLibelle() + " - Liste " + (mandatory ? "O" : "F")));
            listData.put("obligatoire", List.of(String.valueOf(mandatory)));
            listData.put("plageDeChoix", List.of("false"));
            listData.put("children", courseChildren.stream().map(e -> e.getObjetMaquette().getId().toString()).collect(Collectors.toList()));
            newObjects.put(listId, listData);
            nextObjects.addAll(courseChildren);
        }
    }

    private Map<String, List<Object>> _getObjectFields(ObjetMaquetteDetail objectDetails, EnfantsStructure structure, ObjetMaquetteStructure item) {
        HashMap<String, List<Object>> result = new HashMap<String, List<Object>>();
        String contentTypeId = this._getContentType(item);
        ContentWorkflowDescription wfDescription = ContentWorkflowDescription.getByContentType(contentTypeId);
        result.put("workflowDescription", List.of(wfDescription));
        Map<String, String> contentTypeMapping = this._mappingByContentType.get(contentTypeId);
        Map<String, Object> fields = this._getFields(objectDetails, structure);
        Iterator<String> iterator = contentTypeMapping.keySet().iterator();
        while (iterator.hasNext()) {
            String attribute;
            String jsonKey = contentTypeMapping.get(attribute = iterator.next());
            Object value = fields.get(jsonKey);
            result.put(attribute, value != null ? List.of(value) : null);
        }
        result.put(this.getIdField(), List.of(objectDetails.getId().toString()));
        return result;
    }

    private Map<String, Object> _getFields(ObjetMaquetteDetail objectDetails, EnfantsStructure structure) {
        DescripteursSise sise;
        HashMap<String, Object> fields = new HashMap<String, Object>();
        fields.put("id", objectDetails.getId().toString());
        fields.put("code", StringUtils.trimToNull((String)objectDetails.getCode()));
        DescripteursObjetMaquette descripteursObjetMaquette = objectDetails.getDescripteursObjetMaquette();
        String libelle = StringUtils.trimToNull((String)descripteursObjetMaquette.getLibelle());
        fields.put("libelle", libelle);
        fields.put("libelleLong", StringUtils.trimToNull((String)descripteursObjetMaquette.getLibelleLong()));
        if (descripteursObjetMaquette instanceof DescripteursFormation) {
            DescripteursFormation descripteursFormation = (DescripteursFormation)descripteursObjetMaquette;
            fields.put("ects", descripteursFormation.getEcts());
            fields.put("orgUnit", StringUtils.trimToNull((String)descripteursFormation.getStructurePrincipale()));
        } else if (descripteursObjetMaquette instanceof DescripteursGroupement) {
            DescripteursGroupement descripteursGroupement = (DescripteursGroupement)descripteursObjetMaquette;
            fields.put("obligatoire", String.valueOf(structure.getObligatoire()));
            PlageDeChoix plageDeChoix = descripteursGroupement.getPlageDeChoix();
            if (plageDeChoix != null) {
                fields.put("plageDeChoix", "true");
                fields.put("plageMin", descripteursGroupement.getPlageDeChoix().getMin());
                fields.put("plageMax", descripteursGroupement.getPlageDeChoix().getMax());
            }
        } else if (descripteursObjetMaquette instanceof DescripteursObjetFormation) {
            DescripteursObjetFormation descripteursObjetFormation = (DescripteursObjetFormation)descripteursObjetMaquette;
            fields.put("ects", descripteursObjetFormation.getEcts());
            fields.put("orgUnit", StringUtils.trimToNull((String)descripteursObjetFormation.getStructurePrincipale()));
            String type = this._getNomenclature(descripteursObjetFormation.getType());
            fields.put("typeObjetFormation", type);
        }
        DescripteursSyllabus syllabus = objectDetails.getDescripteursSyllabus();
        if (syllabus != null) {
            fields.put("description", StringUtils.trimToNull((String)syllabus.getDescription()));
            fields.put("langueEnseignement", StringUtils.trimToNull((String)syllabus.getLangueEnseignement()));
            fields.put("objectif", StringUtils.trimToNull((String)syllabus.getObjectif()));
            fields.put("prerequis", StringUtils.trimToNull((String)syllabus.getPrerequisPedagogique()));
        }
        if ((sise = objectDetails.getDescripteursEnquete().getDescripteursSise()) != null) {
            fields.put("codeTypeDiplome", this._getNomenclature(sise.getTypeDiplome()));
            fields.put("codeMention", this._getNomenclature(sise.getMention()));
            fields.put("codeNiveauDiplome", this._getNomenclature(sise.getNiveauDiplome()));
            fields.put("codeChampFormation", this._getNomenclature(sise.getChampFormation()));
            fields.put("codeDomaineFormation", this._getNomenclature(sise.getDomaineFormation()));
        }
        return fields;
    }

    private String _getNomenclature(Nomenclature nomenclature) {
        return nomenclature != null ? StringUtils.trimToNull((String)nomenclature.getCode()) : null;
    }

    public List<ModifiableContent> importContent(String idValue, Map<String, Object> importParams, Logger logger) throws Exception {
        Map<String, Object> parameters = this.putIdParameter(idValue);
        return this._importOrSynchronizeContents(parameters, true, logger);
    }

    public void synchronizeContent(ModifiableContent content, Logger logger) throws Exception {
        String idValue = (String)content.getValue(this.getIdField());
        Map<String, Object> parameters = this.putIdParameter(idValue);
        this._importOrSynchronizeContents(parameters, true, logger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<ModifiableContent> _importOrSynchronizeContents(Map<String, Object> searchParams, boolean forceImport, Logger logger, ContainerProgressionTracker progressionTracker) {
        this._importedContents = new HashMap<String, Integer>();
        this._synchronizedContents = new HashSet<String>();
        this._updatedRelationContents = new HashSet<String>();
        this._contentsChildren = new HashMap<String, Set<String>>();
        try {
            this._cdmfrHandler.suspendCDMFRObserver();
            List contents = super._importOrSynchronizeContents(searchParams, forceImport, logger, progressionTracker);
            this._updateRelations(logger);
            this._updateWorkflowStatus(logger);
            List list = contents;
            return list;
        }
        finally {
            this._cdmfrHandler.unsuspendCDMFRObserver(this._synchronizedContents);
            this._importedContents = null;
            this._synchronizedContents = null;
            this._updatedRelationContents = null;
            this._contentsChildren = null;
        }
    }

    protected ModifiableContent _getOrCreateContent(String lang, String idValue, Map<String, List<Object>> remoteValues, boolean forceImport, Logger logger) throws Exception {
        ModifiableContent content;
        block6: {
            Map resultMap;
            ContentWorkflowDescription wfDescription;
            block7: {
                wfDescription = (ContentWorkflowDescription)((Object)remoteValues.get("workflowDescription").get(0));
                content = this._getContent(lang, idValue, wfDescription.getContentType());
                if (content != null) break block6;
                if (forceImport) break block7;
                if (this.synchronizeExistingContentsOnly()) break block6;
            }
            String contentTitle = Optional.of(remoteValues).map(v -> (List)v.get("title")).map(Collection::stream).orElseGet(Stream::empty).filter(String.class::isInstance).map(String.class::cast).filter(StringUtils::isNotEmpty).findFirst().orElse(idValue);
            String contentName = NameHelper.filterName((String)(this._contentPrefix + "-" + contentTitle + "-" + lang));
            HashMap<String, String> inputs = new HashMap<String, String>();
            String catalog = this.getCatalog();
            if (catalog != null) {
                inputs.put(AbstractCreateODFContentFunction.CONTENT_CATALOG_KEY, catalog);
            }
            if ((resultMap = this._contentWorkflowHelper.createContent(wfDescription.getWorkflowName(), wfDescription.getInitialActionId(), contentName, contentTitle, new String[]{wfDescription.getContentType()}, null, lang, inputs)).getOrDefault("error", false).booleanValue()) {
                ++this._nbError;
            }
            if ((content = (ModifiableContent)resultMap.get(Content.class.getName())) != null) {
                this._sccHelper.updateSCCProperty((Content)content, this.getId());
                content.setValue(this.getIdField(), (Object)idValue);
                content.saveChanges();
                this._importedContents.put(content.getId(), wfDescription.getValidationActionId());
                ++this._nbCreatedContents;
            }
        }
        return content;
    }

    protected ModifiableContent _getContent(String lang, String syncCode, String contentType) {
        String xPathQuery = this._getContentPathQuery(lang, syncCode, contentType, false);
        AmetysObjectIterable contents = this._resolver.query(xPathQuery);
        if (contents.getSize() > 0L) {
            return (ModifiableContent)contents.iterator().next();
        }
        return null;
    }

    protected Optional<ModifiableContent> _importOrSynchronizeContent(String idValue, String lang, Map<String, List<Object>> remoteValues, boolean forceImport, Logger logger) {
        try {
            ModifiableContent content = this._getOrCreateContent(lang, idValue, remoteValues, forceImport, logger);
            if (content != null) {
                return Optional.of(this._synchronizeContent(content, remoteValues, logger));
            }
        }
        catch (Exception e) {
            ++this._nbError;
            logger.error("An error occurred while importing or synchronizing content", (Throwable)e);
        }
        return Optional.empty();
    }

    protected ModifiableContent _synchronizeContent(ModifiableContent content, Map<String, List<Object>> remoteValues, Logger logger) throws Exception {
        super._synchronizeContent(content, remoteValues, logger);
        if (remoteValues.containsKey("children")) {
            Set children = this._contentsChildren.computeIfAbsent(content.getId(), __ -> new LinkedHashSet());
            children.addAll(remoteValues.get("children"));
        }
        return content;
    }

    protected boolean _fillContent(Map<String, List<Object>> remoteValues, ModifiableContent content, Map<String, Object> additionalParameters, boolean create, Logger logger) throws Exception {
        this._synchronizedContents.add(content.getId());
        return super._fillContent(remoteValues, content, additionalParameters, create, logger);
    }

    public List<String> getLanguages() {
        return List.of(this._odfLang);
    }

    protected List<Expression> _getExpressionsList(String lang, String idValue, String contentType, boolean forceStrictCheck) {
        List expList = super._getExpressionsList(lang, idValue, contentType, forceStrictCheck);
        String catalog = this.getCatalog();
        if (catalog != null) {
            expList.add(new StringExpression("catalog", Expression.Operator.EQ, catalog));
        }
        return expList;
    }

    protected Map<String, Object> _transformRemoteValuesCardinality(Map<String, List<Object>> remoteValues, String obsoleteContentTypeId) {
        String realContentTypeId = Optional.of(remoteValues).map(v -> (List)v.get("workflowDescription")).map(l -> l.get(0)).map(ContentWorkflowDescription.class::cast).map(ContentWorkflowDescription::getContentType).orElse(null);
        return super._transformRemoteValuesCardinality(remoteValues, realContentTypeId);
    }

    private void _updateRelations(Logger logger) {
        for (String contentId : this._contentsChildren.keySet()) {
            WorkflowAwareContent content = (WorkflowAwareContent)this._resolver.resolveById(contentId);
            Set<String> childrenCodes = this._contentsChildren.get(contentId);
            String contentLanguage = content.getLanguage();
            String contentCatalog = (String)content.getValue("catalog");
            HashMap<String, Set<String>> childrenByAttributeName = new HashMap<String, Set<String>>();
            for (String childCode : childrenCodes) {
                AndExpression expression = new AndExpression(new Expression[]{this._sccHelper.getCollectionExpression(this.getId()), new StringExpression(this.getIdField(), Expression.Operator.EQ, childCode), new StringExpression("catalog", Expression.Operator.EQ, contentCatalog), new LanguageExpression(Expression.Operator.EQ, contentLanguage)});
                ModifiableContent childContent = this._resolver.query(ContentQueryHelper.getContentXPathQuery((Expression)expression)).stream().findFirst().orElse(null);
                if (childContent == null) {
                    logger.warn("Content with code '{}' in {} on catalog '{}' was not found in the repository to update relations with content [{}] '{}' ({}).", new Object[]{childCode, contentLanguage, contentCatalog, content.getValue(this.getIdField()), content.getTitle(), contentCatalog});
                    continue;
                }
                String attributesName = this._getChildAttributeName((Content)content, (Content)childContent);
                if (attributesName != null) {
                    Set children = childrenByAttributeName.computeIfAbsent(attributesName, __ -> new LinkedHashSet());
                    children.add(childContent.getId());
                    continue;
                }
                logger.warn("The child content [{}] '{}' of type '{}' is not compatible with parent content [{}] '{}' of type '{}'.", new Object[]{childCode, childContent.getTitle(), childContent.getTypes()[0], content.getValue(this.getIdField()), content.getTitle(), content.getTypes()[0]});
            }
            this._updateRelations(content, childrenByAttributeName, logger);
        }
    }

    private String _getChildAttributeName(Content parentContent, Content childContent) {
        if (childContent instanceof Course && parentContent instanceof CourseList) {
            return "courses";
        }
        if (parentContent instanceof Course && childContent instanceof CourseList) {
            return "courseLists";
        }
        if (parentContent instanceof TraversableProgramPart && childContent instanceof ProgramPart) {
            return "childProgramParts";
        }
        return null;
    }

    private void _updateRelations(WorkflowAwareContent content, Map<String, Set<String>> contentRelationsByAttribute, Logger logger) {
        View view = View.of((Collection)content.getModel(), (String[])contentRelationsByAttribute.keySet().toArray(new String[contentRelationsByAttribute.size()]));
        HashMap<String, String[]> values = new HashMap<String, String[]>();
        for (String attributeName : contentRelationsByAttribute.keySet()) {
            List<String> attributeValue = this._getContentAttributeValue((Content)content, attributeName);
            contentRelationsByAttribute.get(attributeName).stream().filter(id -> !attributeValue.contains(id)).forEach(attributeValue::add);
            values.put(attributeName, attributeValue.toArray(new String[attributeValue.size()]));
        }
        Set notSynchronizedContentIds = contentRelationsByAttribute.values().stream().flatMap(Collection::stream).filter(id -> !this._synchronizedContents.contains(id)).collect(Collectors.toSet());
        try {
            this._editContent(content, Optional.of(view), values, Map.of(), false, notSynchronizedContentIds, logger);
        }
        catch (WorkflowException e) {
            ++this._nbError;
            logger.error("The content '{}' cannot be links edited (workflow action)", (Object)content, (Object)e);
        }
    }

    private List<String> _getContentAttributeValue(Content content, String attributeName) {
        return Optional.of(attributeName).map(arg_0 -> ((Content)content).getValue(arg_0)).map(Stream::of).orElseGet(Stream::empty).map(ContentValue::getContentId).collect(Collectors.toList());
    }

    private void _updateWorkflowStatus(Logger logger) {
        if (this.validateAfterImport()) {
            for (String contentId : this._importedContents.keySet()) {
                WorkflowAwareContent content = (WorkflowAwareContent)this._resolver.resolveById(contentId);
                Integer validationActionId = this._importedContents.get(contentId);
                if (validationActionId <= 0) continue;
                this.validateContent(content, validationActionId, logger);
            }
        }
    }

    public boolean handleRightAssignmentContext() {
        return false;
    }

    public ContentSynchronizationResult additionalCommonOperations(ModifiableContent content, Map<String, Object> additionalParameters, Logger logger) {
        this._setPeriod(content);
        return super.additionalCommonOperations(content, additionalParameters, logger);
    }

    private void _setPeriod(ModifiableContent content) {
        OdfReferenceTableEntry entry;
        String period;
        Container container;
        if (content instanceof Container && "semestre".equals(((Content)this._resolver.resolveById((container = (Container)content).getNature())).getValue("code")) && (period = this._getPeriodFromTitle((Content)content)) != null && (entry = this._refTableHelper.getItemFromCode("odf-enumeration.Period", period)) != null) {
            content.setExternalValue("period", (Object)entry.getId());
        }
    }

    private String _getPeriodFromTitle(Content content) {
        String string;
        String string2 = content.getTitle();
        Objects.requireNonNull(string2);
        String string3 = string2;
        int n = 0;
        block8: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{String.class, String.class, String.class, String.class, String.class, String.class}, (Object)string3, n)) {
                case 0: {
                    String title = string3;
                    if (!StringUtils.containsIgnoreCase((CharSequence)title, (CharSequence)"Semestre 1") && !StringUtils.containsIgnoreCase((CharSequence)title, (CharSequence)"S1")) {
                        n = 1;
                        continue block8;
                    }
                    string = "s1";
                    break block8;
                }
                case 1: {
                    String title = string3;
                    if (!StringUtils.containsIgnoreCase((CharSequence)title, (CharSequence)"Semestre 2") && !StringUtils.containsIgnoreCase((CharSequence)title, (CharSequence)"S2")) {
                        n = 2;
                        continue block8;
                    }
                    string = "s2";
                    break block8;
                }
                case 2: {
                    String title = string3;
                    if (!StringUtils.containsIgnoreCase((CharSequence)title, (CharSequence)"Semestre 3") && !StringUtils.containsIgnoreCase((CharSequence)title, (CharSequence)"S3")) {
                        n = 3;
                        continue block8;
                    }
                    string = "s3";
                    break block8;
                }
                case 3: {
                    String title = string3;
                    if (!StringUtils.containsIgnoreCase((CharSequence)title, (CharSequence)"Semestre 4") && !StringUtils.containsIgnoreCase((CharSequence)title, (CharSequence)"S4")) {
                        n = 4;
                        continue block8;
                    }
                    string = "s4";
                    break block8;
                }
                case 4: {
                    String title = string3;
                    if (!StringUtils.containsIgnoreCase((CharSequence)title, (CharSequence)"Semestre 5") && !StringUtils.containsIgnoreCase((CharSequence)title, (CharSequence)"S5")) {
                        n = 5;
                        continue block8;
                    }
                    string = "s5";
                    break block8;
                }
                case 5: {
                    String title = string3;
                    if (!StringUtils.containsIgnoreCase((CharSequence)title, (CharSequence)"Semestre 6") && !StringUtils.containsIgnoreCase((CharSequence)title, (CharSequence)"S6")) {
                        n = 6;
                        continue block8;
                    }
                    string = "s6";
                    break block8;
                }
                default: {
                    string = null;
                    break block8;
                }
            }
            break;
        }
        return string;
    }

    private record ComputedChildren(List<Object> childrenIds, Map<String, Map<String, List<Object>>> newObjects, List<EnfantsStructure> nextObjects) {
    }
}

