/*
 *  Copyright 2021 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
 
// This script get the higher version from JCR data
// If this version is lower than the version number link to ODF-2995 (20210929T0000)
// - if the project does not contain Apogée SCC, the manual migration 20210929T0000 is skipped
// - else if the version is null, force upgrades (but no initializations)
// Else return current version.
 
const sccDAO = Ametys.serviceManager.lookup(org.ametys.plugins.contentio.synchronize.SynchronizableContentsCollectionDAO.ROLE);

const migrationEngine = Ametys.serviceManager.lookup(org.ametys.core.migration.MigrationEngine.ROLE);

const versionStorageEP = Ametys.serviceManager.lookup(org.ametys.core.migration.version.storage.VersionStorageExtensionPoint.ROLE);
const versionStorage = versionStorageEP.getExtension('jcr');

let versions = versionStorage.getVersions(componentId, null, component);
let currentVersion = migrationEngine.getLatestVersion(versions);

// If the current version is before the manuel migration version for ODF-2995
if (currentVersion != null && org.apache.commons.lang3.StringUtils.compare(currentVersion.getVersionNumber(), "20210929T0000") < 0)
{
    // If there are no Apogée SCC
    if (!containsApogeeSCC_ODF2995())
    {
        // Create new version to ignore manual migration for ODF-2995
        const version = Migration.addVersion(componentId, null, null, "20210929T0000", "Ignore manual migration for ODF-2995 because there are no Apogee SCC defined.");
        logger.info("Version 20210929T0000 added by script for component " + componentId);
        
        return version;
    }
}

return {
    "id": componentId,
    "versions": versions,
    "componentId": componentId,
    "versionConfiguration": null,
    "additionalValues": {}
};

function containsApogeeSCC_ODF2995()
{
    for (let scc of sccDAO.getSynchronizableContentsCollections())
    {
        if (scc instanceof org.ametys.plugins.odfsync.apogee.scc.ApogeeSynchronizableContentsCollection)
        {
            return true;
        }
    }
    
    return false;
}  
