/*
 *  Copyright 2017 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.odfsync.apogee.scc;

import java.util.List;
import java.util.Map;

import org.slf4j.Logger;

import org.ametys.cms.repository.ModifiableContent;

/**
 * Interface for Apogée specific methods.
 */
public interface ApogeeSynchronizableContentsCollection
{
    /**
     * Method used to import the structure of an ODF content or its dependencies, import or synchronize each child recursively.
     * @param searchParams Search parameters
     * @param logger The logger
     * @return The {@link List} of {@link ModifiableContent} of children (imported or synchronized)
     */
    public List<ModifiableContent> importOrSynchronizeContents(Map<String, Object> searchParams, Logger logger);
}
