/*
 *  Copyright 2017 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.odfsync.apogee.scc.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.slf4j.Logger;

import org.ametys.cms.repository.Content;
import org.ametys.cms.repository.ModifiableContent;
import org.ametys.odf.ProgramItem;
import org.ametys.odf.program.TraversableProgramPart;
import org.ametys.plugins.contentio.synchronize.SynchronizableContentsCollection;
import org.ametys.plugins.odfsync.apogee.scc.AbstractApogeeSynchronizableContentsWithCatalogCollection;
import org.ametys.plugins.odfsync.apogee.scc.ApogeeSynchronizableContentsCollection;

/**
 * SCC for program contents.
 */
public class ProgramSynchronizableContentsCollection extends AbstractApogeeSynchronizableContentsWithCatalogCollection
{
    /** SCC model id */
    public static final String MODEL_ID = "org.ametys.plugins.odfsync.apogee.scc.program";
    
    @Override
    protected List<Map<String, Object>> _search(Map<String, Object> searchParameters, Logger logger)
    {
        String dataSourceId = getDataSourceId();
        
        List<Map<String, Object>> requestValues = _convertBigDecimal(_apogeeDAO.searchPrograms(dataSourceId, getParameterValues(), searchParameters));
        if (!searchParameters.containsKey("__count") && (searchParameters.containsKey("apogeeSyncCode") || searchParameters.containsKey("parentCode") || searchParameters.containsKey("isGlobalSync")))
        {
            for (Map<String, Object> values : requestValues)
            {
                String idValue = values.get(getIdColumn()).toString();
                
                Map<String, Object> parameters = new HashMap<>();
                parameters.put(getIdField(), idValue);
                
                // Get the joint orgunits
                values.putAll(_transformListOfMap2MapOfList(_apogeeDAO.getJointOrgUnits(dataSourceId, getParameterValues(), parameters)));
                
                // Get the modalities
                values.putAll(_transformListOfMap2MapOfList(_apogeeDAO.getFormOfTeachingOrg(dataSourceId, getParameterValues(), parameters)));
                
                // Get the add elements
                values.putAll(_transformListOfMap2MapOfList(_apogeeDAO.getAddElements(dataSourceId, getParameterValues(), parameters)));
                
                // Get the domains
                values.putAll(_transformListOfMap2MapOfList(_apogeeDAO.getDomains(dataSourceId, getParameterValues(), parameters)));
            }
        }
        return requestValues;
    }
    
    @Override
    protected String getMappingName()
    {
        return "program";
    }
    
    @Override
    protected Map<String, Object> getAdditionalAttributeValues(String idValue, Content content, Map<String, Object> additionalParameters, boolean create, Logger logger)
    {
        Map<String, Object> result = super.getAdditionalAttributeValues(idValue, content, additionalParameters, create, logger);
        
        // Synchonize org unit and add it to the values
        SynchronizableContentsCollection scc = _sccHelper.getSCCFromModelId(OrgUnitSynchronizableContentsCollection.MODEL_ID);
        if (scc != null && scc instanceof ApogeeSynchronizableContentsCollection apogeeSCC)
        {
            List<ModifiableContent> children = apogeeSCC.importOrSynchronizeContents(Map.of("id_program", idValue), logger);
            result.put(ProgramItem.ORG_UNITS_REFERENCES, children.toArray(new ModifiableContent[children.size()]));
        }
        
        return result;
    }
    
    @Override
    protected Set<String> getClobColumns()
    {
        return Set.of("EXI_PRG", "ORG_ETUDE", "LNG_CRS_EXM", "CND_ACC");
    }
    
    @Override
    protected String getChildrenAttributeName()
    {
        return TraversableProgramPart.CHILD_PROGRAM_PARTS;
    }
}
