/*
 *  Copyright 2018 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.odfsync.cdmfr.components.impl;

import java.util.List;
import java.util.Map;

import org.apache.commons.lang3.StringUtils;

import org.ametys.plugins.odfsync.cdmfr.ImportCDMFrContext;
import org.ametys.plugins.odfsync.cdmfr.components.AbstractImportCDMFrComponent;
import org.ametys.plugins.repository.query.expression.Expression;

/**
 * Component to import a CDM-fr input stream in SCC context.
 */
public class SCCImportCDMFrComponent extends AbstractImportCDMFrComponent
{
    /** The collectionID */
    protected String _collectionId;
    
    /** Validate after import */
    protected boolean _validateAfterImport;

    /** True if removal sync */
    protected boolean _removalSync;
    
    @Override
    protected void additionalParameters(Map<String, Object> parameters)
    {
        _collectionId = (String) parameters.get("collectionId");
        _validateAfterImport = (boolean) parameters.getOrDefault("validateAfterImport", false);
        _removalSync = (boolean) parameters.getOrDefault("removalSync", false);
    }
    
    @Override
    public List<Expression> _getExpressionsList(String contentType, String idValue, ImportCDMFrContext context)
    {
        List<Expression> expList = super._getExpressionsList(contentType, idValue, context);
        
        if (StringUtils.isNotBlank(_collectionId))
        {
            expList.add(_sccHelper.getCollectionExpression(_collectionId));
        }
        
        return expList;
    }

    @Override
    protected boolean validateAfterImport()
    {
        return _validateAfterImport;
    }

    @Override
    protected boolean removalSync()
    {
        return _removalSync;
    }
}
