/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfsync.cdmfr;

import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ametys.cms.repository.ModifiableContent;
import org.ametys.plugins.contentio.synchronize.SynchronizableContentsCollection;
import org.ametys.plugins.odfsync.cdmfr.AbstractCDMFrSynchronizableContentsCollection;
import org.ametys.plugins.odfsync.cdmfr.components.ImportCDMFrComponent;
import org.ametys.plugins.odfsync.cdmfr.components.impl.RemoteImportCDMFrComponent;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.slf4j.Logger;

public class RemoteCDMFrSynchronizableContentsCollection
extends AbstractCDMFrSynchronizableContentsCollection {
    public static final String PARAM_SHARED_WITH_TYPE = "shared.subprogram.type";
    public static final String PARAM_CDMFR_IMPORTER_ROLE = "remote.implementation";
    public static final String PARAM_CDMFR_CATALOG = "remote.catalog";
    public static final String PARAM_CDMFR_VALIDATE_AFTER_IMPORT = "remote.validate.after.import";
    protected ServiceManager _manager;

    @Override
    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._manager = manager;
    }

    protected void configureStaticParams(Configuration configuration) throws ConfigurationException {
        super.configureStaticParams(configuration);
        try {
            this._importCDMFrComponent = (ImportCDMFrComponent)this._manager.lookup(this.getImportCDMFrRole());
        }
        catch (ServiceException e) {
            throw new ConfigurationException("An error occurred getting the CDM-fr importer", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ModifiableContent> importContent(String idValue, Map<String, Object> additionalParameters, Logger logger) throws Exception {
        if (additionalParameters.containsKey("cdmfr-input-stream")) {
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            try {
                this._startHandleCDMFR();
                parameters.put(PARAM_SHARED_WITH_TYPE, this.getSharedWithType());
                parameters.put(PARAM_CDMFR_CATALOG, this.getCatalog());
                parameters.put(PARAM_CDMFR_VALIDATE_AFTER_IMPORT, this.validateAfterImport());
                InputStream is = (InputStream)additionalParameters.get("cdmfr-input-stream");
                Map<String, Object> resultMap = this._importCDMFrComponent.handleInputStream(is, parameters, (SynchronizableContentsCollection)this, logger);
                List list = (List)resultMap.get("importedPrograms");
                return list;
            }
            catch (ProcessingException e) {
                logger.error("An error occurred. Can't import remote program.", (Throwable)e);
            }
            finally {
                this._endHandleCDMFR((Set)parameters.get("updatedContents"));
            }
        } else {
            logger.error("An error occurred because no input stream has been sent");
        }
        return null;
    }

    protected String getSharedWithType() {
        return (String)this.getParameterValues().get(PARAM_SHARED_WITH_TYPE);
    }

    protected String getImportCDMFrRole() {
        return this.getParameterValues().getOrDefault(PARAM_CDMFR_IMPORTER_ROLE, RemoteImportCDMFrComponent.ROLE);
    }

    protected String getCatalog() {
        return (String)this.getParameterValues().get(PARAM_CDMFR_CATALOG);
    }
}

