/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfsync.cdmfr.components;

import com.opensymphony.workflow.InvalidActionException;
import com.opensymphony.workflow.WorkflowException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.ametys.cms.contenttype.ContentType;
import org.ametys.cms.contenttype.ContentTypeExtensionPoint;
import org.ametys.cms.data.ContentSynchronizationResult;
import org.ametys.cms.repository.Content;
import org.ametys.cms.repository.ContentQueryHelper;
import org.ametys.cms.repository.ContentTypeExpression;
import org.ametys.cms.repository.LanguageExpression;
import org.ametys.cms.repository.ModifiableContent;
import org.ametys.cms.repository.WorkflowAwareContent;
import org.ametys.cms.workflow.ContentWorkflowHelper;
import org.ametys.core.observation.Event;
import org.ametys.core.observation.ObservationManager;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.population.UserPopulationDAO;
import org.ametys.odf.ODFHelper;
import org.ametys.odf.ProgramItem;
import org.ametys.odf.catalog.CatalogsManager;
import org.ametys.odf.course.Course;
import org.ametys.odf.course.ShareableCourseHelper;
import org.ametys.odf.courselist.CourseList;
import org.ametys.odf.enumeration.OdfReferenceTableHelper;
import org.ametys.odf.orgunit.OrgUnit;
import org.ametys.odf.orgunit.RootOrgUnitProvider;
import org.ametys.odf.program.Program;
import org.ametys.odf.translation.TranslationHelper;
import org.ametys.odf.workflow.AbstractCreateODFContentFunction;
import org.ametys.plugins.contentio.synchronize.SynchronizableContentsCollection;
import org.ametys.plugins.contentio.synchronize.SynchronizableContentsCollectionHelper;
import org.ametys.plugins.contentio.synchronize.workflow.EditSynchronizedContentFunction;
import org.ametys.plugins.odfsync.cdmfr.CDMFrSyncExtensionPoint;
import org.ametys.plugins.odfsync.cdmfr.ImportCDMFrContext;
import org.ametys.plugins.odfsync.cdmfr.components.ImportCDMFrComponent;
import org.ametys.plugins.odfsync.cdmfr.extractor.ImportCDMFrValuesExtractorFactory;
import org.ametys.plugins.odfsync.cdmfr.transformers.CDMFrSyncTransformer;
import org.ametys.plugins.odfsync.utils.ContentWorkflowDescription;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.data.external.ExternalizableDataProvider;
import org.ametys.plugins.repository.data.extractor.ModelAwareValuesExtractor;
import org.ametys.plugins.repository.data.holder.values.SynchronizationContext;
import org.ametys.plugins.repository.jcr.NameHelper;
import org.ametys.plugins.repository.lock.LockAwareAmetysObject;
import org.ametys.plugins.repository.query.expression.AndExpression;
import org.ametys.plugins.repository.query.expression.Expression;
import org.ametys.plugins.repository.query.expression.OrExpression;
import org.ametys.plugins.repository.query.expression.StringExpression;
import org.ametys.plugins.workflow.AbstractWorkflowComponent;
import org.ametys.plugins.workflow.component.CheckRightsCondition;
import org.ametys.runtime.config.Config;
import org.ametys.runtime.model.View;
import org.ametys.runtime.model.ViewItemAccessor;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfigurationBuilder;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.Context;
import org.apache.commons.lang3.StringUtils;
import org.apache.excalibur.xml.dom.DOMParser;
import org.apache.excalibur.xml.xpath.XPathProcessor;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class AbstractImportCDMFrComponent
implements ImportCDMFrComponent,
Serviceable,
Initializable,
Contextualizable,
Configurable,
Component {
    protected static final String _TAG_PROGRAM = "program";
    protected static final String _TAG_SUBPROGRAM = "subProgram";
    protected static final String _TAG_CONTAINER = "container";
    protected static final String _TAG_COURSELIST = "coursesReferences";
    protected static final String _TAG_COURSEPART = "coursePart";
    protected static final int _SYNCHRONIZE_WORKFLOW_ACTION_ID = 800;
    protected Context _cocoonContext;
    protected DOMParser _domParser;
    protected XPathProcessor _xPathProcessor;
    protected CDMFrSyncExtensionPoint _cdmFrSyncExtensionPoint;
    protected String _odfLang;
    protected CatalogsManager _catalogsManager;
    protected AmetysObjectResolver _resolver;
    protected OdfReferenceTableHelper _odfRefTableHelper;
    protected ContentTypeExtensionPoint _contentTypeEP;
    protected CurrentUserProvider _currentUserProvider;
    protected ObservationManager _observationManager;
    protected RootOrgUnitProvider _rootOUProvider;
    protected ODFHelper _odfHelper;
    protected SynchronizableContentsCollectionHelper _sccHelper;
    protected ContentWorkflowHelper _contentWorkflowHelper;
    protected ShareableCourseHelper _shareableCourseHelper;
    protected ImportCDMFrValuesExtractorFactory _valuesExtractorFactory;
    protected Map<String, Integer> _importedContents;
    protected Set<String> _synchronizedContents;
    protected int _nbError;
    protected String _contentPrefix;
    protected Map<String, Set<String>> _syncFieldsByContentType;

    public void initialize() throws Exception {
        this._odfLang = (String)Config.getInstance().getValue("odf.programs.lang");
    }

    public void contextualize(org.apache.avalon.framework.context.Context context) throws ContextException {
        this._cocoonContext = (Context)context.get((Object)"environment-context");
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this._parseSynchronizedFields();
    }

    public void service(ServiceManager manager) throws ServiceException {
        this._resolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
        this._domParser = (DOMParser)manager.lookup(DOMParser.ROLE);
        this._xPathProcessor = (XPathProcessor)manager.lookup(XPathProcessor.ROLE);
        this._cdmFrSyncExtensionPoint = (CDMFrSyncExtensionPoint)((Object)manager.lookup(CDMFrSyncExtensionPoint.ROLE));
        this._catalogsManager = (CatalogsManager)manager.lookup(CatalogsManager.ROLE);
        this._odfRefTableHelper = (OdfReferenceTableHelper)manager.lookup(OdfReferenceTableHelper.ROLE);
        this._contentTypeEP = (ContentTypeExtensionPoint)manager.lookup(ContentTypeExtensionPoint.ROLE);
        this._currentUserProvider = (CurrentUserProvider)manager.lookup(CurrentUserProvider.ROLE);
        this._observationManager = (ObservationManager)manager.lookup(ObservationManager.ROLE);
        this._rootOUProvider = (RootOrgUnitProvider)manager.lookup(RootOrgUnitProvider.ROLE);
        this._odfHelper = (ODFHelper)manager.lookup(ODFHelper.ROLE);
        this._sccHelper = (SynchronizableContentsCollectionHelper)manager.lookup(SynchronizableContentsCollectionHelper.ROLE);
        this._contentWorkflowHelper = (ContentWorkflowHelper)manager.lookup(ContentWorkflowHelper.ROLE);
        this._shareableCourseHelper = (ShareableCourseHelper)manager.lookup(ShareableCourseHelper.ROLE);
        this._valuesExtractorFactory = (ImportCDMFrValuesExtractorFactory)manager.lookup(ImportCDMFrValuesExtractorFactory.ROLE);
    }

    @Override
    public String getIdField() {
        return "cdmfrSyncCode";
    }

    private void _parseSynchronizedFields() throws ConfigurationException {
        this._syncFieldsByContentType = new HashMap<String, Set<String>>();
        File cdmfrMapping = new File(this._cocoonContext.getRealPath("/WEB-INF/param/odf-synchro.xml"));
        try (InputStream is = !cdmfrMapping.isFile() ? this.getClass().getResourceAsStream("/org/ametys/plugins/odfsync/cdmfr/odf-synchro.xml") : new FileInputStream(cdmfrMapping);){
            Configuration[] cTypesConf;
            Configuration cfg = new DefaultConfigurationBuilder().build(is);
            for (Configuration cTypeConf : cTypesConf = cfg.getChildren("content-type")) {
                String contentType = cTypeConf.getAttribute("id");
                Set<String> syncAttributes = this._configureSynchronizedFields(cTypeConf, "");
                this._syncFieldsByContentType.put(contentType, syncAttributes);
            }
        }
        catch (Exception e) {
            throw new ConfigurationException("Error while parsing odf-synchro.xml", (Throwable)e);
        }
    }

    private Set<String> _configureSynchronizedFields(Configuration configuration, String prefix) throws ConfigurationException {
        HashSet<String> syncAttributes = new HashSet<String>();
        Configuration[] attributesConf = configuration.getChildren("attribute");
        if (attributesConf.length > 0) {
            for (Configuration attributeConf : attributesConf) {
                if (attributeConf.getChildren("attribute").length > 0) {
                    syncAttributes.addAll(this._configureSynchronizedFields(attributeConf, prefix + attributeConf.getAttribute("name") + "/"));
                    continue;
                }
                syncAttributes.add(prefix + attributeConf.getAttribute("name"));
            }
        } else if (configuration.getAttribute("name", null) != null) {
            syncAttributes.add(prefix + configuration.getAttribute("name"));
        }
        return syncAttributes;
    }

    @Override
    public synchronized Map<String, Object> handleInputStream(InputStream input, Map<String, Object> parameters, SynchronizableContentsCollection scc, Logger logger) throws ProcessingException {
        ArrayList<ModifiableContent> importedPrograms = new ArrayList<ModifiableContent>();
        this._importedContents = new HashMap<String, Integer>();
        this._synchronizedContents = parameters.getOrDefault("updatedContents", new HashSet());
        int nbCreatedContents = (Integer)parameters.getOrDefault("nbCreatedContents", 0);
        int nbSynchronizedContents = (Integer)parameters.getOrDefault("nbSynchronizedContents", 0);
        this._nbError = (Integer)parameters.getOrDefault("nbError", 0);
        this._contentPrefix = (String)parameters.getOrDefault("contentPrefix", "cdmfr-");
        this.additionalParameters(parameters);
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        try {
            Document doc = this._domParser.parseDocument(new InputSource(input));
            doc = this.transformDocument(doc, new HashMap<String, Object>(), logger);
            if (doc != null) {
                String defaultLang = this._getXPathString(doc, "CDM/@language", this._odfLang);
                NodeList nodes = doc.getElementsByTagName(_TAG_PROGRAM);
                for (int i = 0; i < nodes.getLength(); ++i) {
                    Element contentElement = (Element)nodes.item(i);
                    String syncCode = this._xPathProcessor.evaluateAsString((Node)contentElement, "@CDMid");
                    String contentLang = this._getXPathString(contentElement, "@language", defaultLang);
                    contentLang = StringUtils.substring((String)contentLang, (int)0, (int)2).toLowerCase();
                    String catalog = this.getCatalogName(contentElement);
                    ImportCDMFrContext context = new ImportCDMFrContext(scc, doc, contentLang, catalog, logger);
                    importedPrograms.add(this.importOrSynchronizeContent(contentElement, ContentWorkflowDescription.PROGRAM_WF_DESCRIPTION, syncCode, syncCode, context));
                }
                if (this.validateAfterImport()) {
                    for (String contentId : this._importedContents.keySet()) {
                        WorkflowAwareContent content = (WorkflowAwareContent)this._resolver.resolveById(contentId);
                        Integer validationActionId = this._importedContents.get(contentId);
                        if (validationActionId <= 0) continue;
                        this.validateContent(content, validationActionId, logger);
                    }
                }
            }
        }
        catch (IOException | ProcessingException e) {
            throw new ProcessingException("An error occured while transforming the stream.", e);
        }
        catch (SAXException e) {
            throw new ProcessingException("An error occured while parsing the stream.", (Throwable)e);
        }
        catch (Exception e) {
            throw new ProcessingException("An error occured while synchronizing values on contents.", (Throwable)e);
        }
        resultMap.put("importedContents", this._importedContents.keySet());
        resultMap.put("nbCreatedContents", nbCreatedContents + this._importedContents.size());
        resultMap.put("updatedContents", this._synchronizedContents);
        resultMap.put("nbSynchronizedContents", nbSynchronizedContents + this._synchronizedContents.size());
        resultMap.put("nbError", this._nbError);
        resultMap.put("importedPrograms", importedPrograms);
        return resultMap;
    }

    protected abstract boolean validateAfterImport();

    protected abstract boolean removalSync();

    protected abstract void additionalParameters(Map<String, Object> var1);

    protected Document transformDocument(Document document, Map<String, Object> parameters, Logger logger) throws IOException, SAXException, ProcessingException {
        Optional transformer = this._cdmFrSyncExtensionPoint.getFirstSupportingExtension(document);
        if (transformer.isEmpty()) {
            logger.error("Cannot match a CDM-fr transformer to this file structure.");
            return null;
        }
        return ((CDMFrSyncTransformer)transformer.get()).transform(document, parameters);
    }

    @Override
    public String getCatalogName(Element contentElement) {
        String defaultCatalog = this._catalogsManager.getDefaultCatalogName();
        String contentCatalog = this._getXPathString(contentElement, "catalog", defaultCatalog);
        if (this._catalogsManager.getCatalog(contentCatalog) == null) {
            return defaultCatalog;
        }
        return contentCatalog;
    }

    @Override
    public ModifiableContent importOrSynchronizeContent(Element contentElement, ContentWorkflowDescription wfDescription, String title, String syncCode, ImportCDMFrContext context) {
        ModifiableContent content = this._getOrCreateContent(wfDescription, title, syncCode, context);
        if (content != null) {
            try {
                this._sccHelper.updateLastSynchronizationProperties((Content)content);
                content.saveChanges();
                this._synchronizeContent(contentElement, content, wfDescription.getContentType(), syncCode, context);
            }
            catch (Exception e) {
                ++this._nbError;
                context.getLogger().error("Failed to synchronize data for content {} and language {}.", new Object[]{content, context.getLang(), e});
            }
        }
        return content;
    }

    protected ModifiableContent _getOrCreateContent(ContentWorkflowDescription wfDescription, String title, String syncCode, ImportCDMFrContext context) {
        ModifiableContent receivedContent = this.getContent(wfDescription.getContentType(), syncCode, context);
        if (receivedContent != null) {
            return receivedContent;
        }
        try {
            context.getLogger().info("Creating content '{}' with the content type '{}' for language {}", new Object[]{title, wfDescription.getContentType(), context.getLang()});
            ModifiableContent content = this._createContent(wfDescription, title, context);
            if (content != null) {
                this._sccHelper.updateSCCProperty((Content)content, context.getSCC().getId());
                content.setValue(this.getIdField(), (Object)syncCode);
                content.saveChanges();
                this._importedContents.put(content.getId(), wfDescription.getValidationActionId());
            }
            return content;
        }
        catch (WorkflowException e) {
            context.getLogger().error("Failed to initialize workflow for content {} and language {}", new Object[]{title, context.getLang(), e});
            ++this._nbError;
            return null;
        }
    }

    @Override
    public ModifiableContent getContent(String contentType, String syncCode, ImportCDMFrContext context) {
        List<Expression> expList = this._getExpressionsList(contentType, syncCode, context);
        AndExpression andExp = new AndExpression(expList.toArray(new Expression[expList.size()]));
        String xPathQuery = ContentQueryHelper.getContentXPathQuery((Expression)andExp);
        AmetysObjectIterable contents = this._resolver.query(xPathQuery);
        if (contents.getSize() > 0L) {
            return (ModifiableContent)contents.iterator().next();
        }
        return null;
    }

    protected ModifiableContent _createContent(ContentWorkflowDescription wfDescription, String title, ImportCDMFrContext context) throws WorkflowException {
        String contentName = NameHelper.filterName((String)(this._contentPrefix + "-" + title + "-" + context.getLang()));
        Map<String, Object> inputs = this._getInputsForContentCreation(wfDescription, context);
        Map result = this._contentWorkflowHelper.createContent(wfDescription.getWorkflowName(), wfDescription.getInitialActionId(), contentName, title, new String[]{wfDescription.getContentType()}, null, context.getLang(), inputs);
        return (ModifiableContent)this._resolver.resolveById((String)result.get("contentId"));
    }

    protected Map<String, Object> _getInputsForContentCreation(ContentWorkflowDescription wfDescription, ImportCDMFrContext context) {
        HashMap<String, Object> inputs = new HashMap<String, Object>();
        ContentType contentType = (ContentType)this._contentTypeEP.getExtension(wfDescription.getContentType());
        if (contentType.hasModelItem("catalog") || contentType.hasModelItem("catalog")) {
            inputs.put(AbstractCreateODFContentFunction.CONTENT_CATALOG_KEY, context.getCatalog());
        }
        return inputs;
    }

    protected void _synchronizeContent(Element contentElement, ModifiableContent content, String contentTypeId, String syncCode, ImportCDMFrContext context) throws Exception {
        Logger logger = context.getLogger();
        if (this._synchronizedContents.add(content.getId())) {
            logger.info("Synchronization of the content '{}' with the content type '{}'", (Object)content.getTitle(), (Object)contentTypeId);
            if (content instanceof LockAwareAmetysObject && ((LockAwareAmetysObject)content).isLocked()) {
                logger.warn("The content '{}' ({}) is currently locked by user {}: it cannot be synchronized", new Object[]{content.getTitle(), content.getId(), ((LockAwareAmetysObject)content).getLockOwner()});
            } else if (content instanceof WorkflowAwareContent) {
                ContentType contentType = (ContentType)this._contentTypeEP.getExtension(contentTypeId);
                ModelAwareValuesExtractor valuesExtractor = this._valuesExtractorFactory.getValuesExtractor(contentElement, this, (Content)content, contentType, syncCode, context);
                Map values = valuesExtractor.extractValues();
                values.putAll(this._getAdditionalValuesToSynchronize(content, syncCode, context));
                boolean create = this._importedContents.containsKey(content.getId());
                Set<String> notSynchronizedContentIds = this._getNotSynchronizedRelatedContentIds(content, syncCode, context);
                this._editContent((WorkflowAwareContent)content, Optional.empty(), values, create, notSynchronizedContentIds, context);
                if (content instanceof OrgUnit) {
                    this._setOrgUnitParent((WorkflowAwareContent)content, context);
                }
                this._linkTranslationsIfExist(content, contentTypeId, context);
            }
        }
    }

    protected Map<String, Object> _getAdditionalValuesToSynchronize(ModifiableContent content, String syncCode, ImportCDMFrContext context) {
        HashMap<String, Object> additionalValues = new HashMap<String, Object>();
        additionalValues.put(this.getIdField(), syncCode);
        return additionalValues;
    }

    protected Set<String> _getNotSynchronizedRelatedContentIds(ModifiableContent content, String syncCode, ImportCDMFrContext context) {
        return new HashSet<String>();
    }

    protected void _editContent(WorkflowAwareContent content, Optional<View> view, Map<String, Object> values, boolean create, Set<String> notSynchronizedContentIds, ImportCDMFrContext context) throws WorkflowException {
        SynchronizationContext synchronizationContext = SynchronizationContext.newInstance().withStatus(ExternalizableDataProvider.ExternalizableDataStatus.EXTERNAL).withExternalizableDataContextEntry("sccId", (Object)context.getSCC().getId()).withIncompatibleValuesIgnored(true);
        if (view.map(v -> content.hasDifferences((ViewItemAccessor)v, values, synchronizationContext)).orElseGet(() -> content.hasDifferences(values, synchronizationContext)).booleanValue()) {
            context.getLogger().info("Some changes were detected for content '{}' and language {}", (Object)content.getTitle(), (Object)context.getLang());
            HashMap<String, Object> inputs = new HashMap<String, Object>();
            inputs.put(EditSynchronizedContentFunction.SCC_KEY, context.getSCC());
            inputs.put(EditSynchronizedContentFunction.SCC_LOGGER_KEY, context.getLogger());
            inputs.put(EditSynchronizedContentFunction.NOT_SYNCHRONIZED_RELATED_CONTENT_IDS_KEY, notSynchronizedContentIds);
            if (this.ignoreRights()) {
                inputs.put(CheckRightsCondition.FORCE, true);
            }
            HashMap<String, Object> params = new HashMap<String, Object>();
            values.remove("catalog");
            params.put("typedValues", values);
            view.ifPresent(v -> params.put("view", v));
            params.put("quit", true);
            params.put("import", create);
            inputs.put(AbstractWorkflowComponent.CONTEXT_PARAMETERS_KEY, params);
            this._contentWorkflowHelper.doAction(content, 800, inputs);
        } else {
            context.getLogger().info("No changes detected for content '{}' and language {}", (Object)content.getTitle(), (Object)context.getLang());
        }
    }

    @Override
    public ContentSynchronizationResult additionalOperations(ModifiableContent content, Map<String, Object> additionalParameters, Logger logger) {
        ContentSynchronizationResult result = new ContentSynchronizationResult();
        if (content instanceof Program) {
            List<ModifiableContent> modifiedContents = this._initializeShareableCoursesFields((ProgramItem)((Program)content));
            result.addModifiedContents(modifiedContents);
            result.setHasChanged(!modifiedContents.isEmpty());
        }
        return result;
    }

    protected List<ModifiableContent> _initializeShareableCoursesFields(ProgramItem programItem) {
        ArrayList<ModifiableContent> modifiedContents = new ArrayList<ModifiableContent>();
        List children = this._odfHelper.getChildProgramItems(programItem);
        for (ProgramItem child : children) {
            if (child instanceof Course && programItem instanceof CourseList && this._shareableCourseHelper.initializeShareableFields((Course)child, (CourseList)programItem, UserPopulationDAO.SYSTEM_USER_IDENTITY, true)) {
                modifiedContents.add((ModifiableContent)((Course)child));
            }
            modifiedContents.addAll(this._initializeShareableCoursesFields(child));
        }
        return modifiedContents;
    }

    protected void _linkTranslationsIfExist(ModifiableContent importedContent, String contentType, ImportCDMFrContext context) {
        if (importedContent instanceof ProgramItem) {
            Expression expression = this._getTranslationExpression(importedContent, contentType);
            String xPathQuery = ContentQueryHelper.getContentXPathQuery((Expression)expression);
            AmetysObjectIterable contents = this._resolver.query(xPathQuery);
            HashMap<String, String> translations = new HashMap<String, String>();
            for (ModifiableContent content : contents) {
                translations.put(content.getLanguage(), content.getId());
            }
            for (ModifiableContent content : contents) {
                TranslationHelper.setTranslations((ModifiableContent)content, translations);
                HashMap<String, Object> eventParams = new HashMap<String, Object>();
                eventParams.put("content", content);
                eventParams.put("content.id", content.getId());
                this._observationManager.notify(new Event("odf.content.translated", this._currentUserProvider.getUser(), eventParams));
            }
        }
    }

    private Expression _getTranslationExpression(ModifiableContent content, String contentType) {
        String catalog;
        ArrayList<Object> expList = new ArrayList<Object>();
        if (StringUtils.isNotBlank((CharSequence)contentType)) {
            expList.add(new ContentTypeExpression(Expression.Operator.EQ, new String[]{contentType}));
        }
        if (StringUtils.isNotBlank((CharSequence)(catalog = (String)content.getValue("catalog")))) {
            expList.add(new StringExpression("catalog", Expression.Operator.EQ, catalog));
        }
        ArrayList<StringExpression> codeExpressionList = new ArrayList<StringExpression>();
        String syncValue = (String)content.getValue(this.getIdField());
        if (StringUtils.isNotBlank((CharSequence)syncValue)) {
            codeExpressionList.add(new StringExpression(this.getIdField(), Expression.Operator.EQ, syncValue));
        }
        String code = (String)content.getValue("code");
        if (StringUtils.isNotBlank((CharSequence)syncValue)) {
            codeExpressionList.add(new StringExpression("code", Expression.Operator.EQ, code));
        }
        if (!codeExpressionList.isEmpty()) {
            expList.add(new OrExpression((Expression[])codeExpressionList.toArray(Expression[]::new)));
        }
        return new AndExpression((Expression[])expList.toArray(Expression[]::new));
    }

    protected void _setOrgUnitParent(WorkflowAwareContent orgUnit, ImportCDMFrContext context) throws Exception {
        if (!orgUnit.hasValue("parentOrgUnit")) {
            OrgUnit rootOrgUnit = this._rootOUProvider.getRoot();
            HashMap<String, Object> values = new HashMap<String, Object>();
            values.put("parentOrgUnit", rootOrgUnit);
            this._editContent(orgUnit, Optional.empty(), values, false, Set.of(rootOrgUnit.getId()), context);
        }
    }

    protected void validateContent(WorkflowAwareContent content, int validationActionId, Logger logger) {
        HashMap<String, Object> inputs = new HashMap<String, Object>();
        if (this.ignoreRights()) {
            inputs.put(CheckRightsCondition.FORCE, true);
        }
        try {
            this._contentWorkflowHelper.doAction(content, validationActionId, inputs);
            logger.info("The content {} has been validated after import", (Object)content);
        }
        catch (InvalidActionException | WorkflowException e) {
            String failuresAsString = this._getActionFailuresAsString(inputs);
            logger.error("The content {} cannot be validated after import{}", new Object[]{content, failuresAsString, e});
        }
    }

    private String _getActionFailuresAsString(Map<String, Object> actionInputs) {
        List failures;
        Object failuresAsString = "";
        if (actionInputs.containsKey(AbstractWorkflowComponent.FAIL_CONDITIONS_KEY) && !(failures = (List)actionInputs.get(AbstractWorkflowComponent.FAIL_CONDITIONS_KEY)).isEmpty()) {
            failuresAsString = ", due to the following error(s):\n" + String.join((CharSequence)"\n", failures.stream().map(AbstractWorkflowComponent.ConditionFailure::text).toList());
        }
        return failuresAsString;
    }

    private String _getXPathString(Node metadataNode, String xPath, String defaultValue) {
        String value = this._xPathProcessor.evaluateAsString(metadataNode, xPath);
        if (StringUtils.isEmpty((CharSequence)value)) {
            value = defaultValue;
        }
        return value;
    }

    protected boolean ignoreRights() {
        return false;
    }

    protected List<Expression> _getExpressionsList(String contentTypeId, String syncCode, ImportCDMFrContext context) {
        ArrayList<Expression> expList = new ArrayList<Expression>();
        if (StringUtils.isNotBlank((CharSequence)contentTypeId)) {
            ContentType contentType;
            expList.add((Expression)new ContentTypeExpression(Expression.Operator.EQ, new String[]{contentTypeId}));
            if (StringUtils.isNotBlank((CharSequence)context.getCatalog()) && ((contentType = (ContentType)this._contentTypeEP.getExtension(contentTypeId)).hasModelItem("catalog") || contentType.hasModelItem("catalog"))) {
                expList.add((Expression)new StringExpression("catalog", Expression.Operator.EQ, context.getCatalog()));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)syncCode)) {
            expList.add((Expression)new StringExpression(this.getIdField(), Expression.Operator.EQ, syncCode));
        }
        if (StringUtils.isNotBlank((CharSequence)context.getLang())) {
            expList.add((Expression)new LanguageExpression(Expression.Operator.EQ, context.getLang()));
        }
        return expList;
    }

    @Override
    public Set<String> getLocalAndExternalFields(Map<String, Object> additionalParameters) {
        if (additionalParameters == null || !additionalParameters.containsKey("contentTypes")) {
            throw new IllegalArgumentException("Content types shouldn't be null.");
        }
        List contentTypeIds = (List)additionalParameters.get("contentTypes");
        HashSet<String> allSyncFields = new HashSet<String>();
        for (String contentTypeId : contentTypeIds) {
            Set syncFields = this._syncFieldsByContentType.computeIfAbsent(contentTypeId, k -> new HashSet());
            allSyncFields.addAll(syncFields);
        }
        return allSyncFields;
    }
}

