/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfsync.cdmfr.extractor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.ametys.cms.repository.Content;
import org.ametys.cms.repository.ModifiableContent;
import org.ametys.core.util.StringUtils;
import org.ametys.core.util.dom.DOMUtils;
import org.ametys.plugins.odfsync.cdmfr.ImportCDMFrContext;
import org.ametys.plugins.odfsync.cdmfr.components.ImportCDMFrComponent;
import org.ametys.plugins.odfsync.cdmfr.extractor.ImportCDMFrValuesExtractor;
import org.ametys.plugins.odfsync.cdmfr.extractor.ImportCDMFrValuesExtractorFactory;
import org.ametys.plugins.odfsync.utils.ContentWorkflowDescription;
import org.ametys.runtime.model.ElementDefinition;
import org.ametys.runtime.model.Model;
import org.ametys.runtime.model.ModelHelper;
import org.ametys.runtime.model.ModelItem;
import org.ametys.runtime.model.ModelItemContainer;
import org.apache.commons.collections4.CollectionUtils;
import org.w3c.dom.Element;

public class ImportCourseValuesExtractor
extends ImportCDMFrValuesExtractor {
    protected static final String _TAG_COURSEPART = "coursePart";
    protected String _synchronizationCode;

    public ImportCourseValuesExtractor(Element element, ImportCDMFrValuesExtractorFactory factory, ImportCDMFrComponent component, String synchronizationCode, ImportCDMFrContext context, Model ... models) {
        this(element, factory, component, synchronizationCode, context, Arrays.asList(models));
    }

    public ImportCourseValuesExtractor(Element element, ImportCDMFrValuesExtractorFactory factory, ImportCDMFrComponent component, String synchronizationCode, ImportCDMFrContext context, Collection<? extends ModelItemContainer> modelItemContainers) {
        super(element, factory, component, context, modelItemContainers);
        this._synchronizationCode = synchronizationCode;
    }

    protected Optional<ModelItem> _getModelItemFromNodeName(Element parent, String nodeName, Collection<? extends ModelItemContainer> modelItemContainers) {
        if ("coursesReferences".equals(nodeName)) {
            return Optional.of(ModelHelper.getModelItem((String)"courseLists", modelItemContainers));
        }
        if (_TAG_COURSEPART.equals(nodeName)) {
            return Optional.of(ModelHelper.getModelItem((String)"courseParts", modelItemContainers));
        }
        return super._getModelItemFromNodeName(parent, nodeName, modelItemContainers);
    }

    protected boolean _hasChildForAttribute(Element element, String attributeName) {
        if ("courseLists".equals(attributeName)) {
            return DOMUtils.hasChildElement((Element)element, (String)"coursesReferences");
        }
        if ("courseParts".equals(attributeName)) {
            return DOMUtils.hasChildElement((Element)element, (String)_TAG_COURSEPART);
        }
        return super._hasChildForAttribute(element, attributeName);
    }

    @Override
    protected <T> Object _extractElementValue(Element parent, ElementDefinition<T> definition, Optional<Object> additionalData) throws Exception {
        String attributePath = definition.getPath();
        if ("courseLists".equals(attributePath)) {
            ArrayList courseLists = new ArrayList();
            List children = DOMUtils.getChildElementsByTagName((Element)parent, (String)"coursesReferences");
            int courseListPosition = 0;
            for (Element child : children) {
                String title = this._getAttributeOrDefault(child, "name", "Liste d'\u00e9l\u00e9ments p\u00e9dagogiques");
                String subContentSyncCode = this._getAttributeOrDefault(child, "code", this._synchronizationCode + "-" + ++courseListPosition);
                ModifiableContent subContent = this._component.importOrSynchronizeContent(child, ContentWorkflowDescription.COURSELIST_WF_DESCRIPTION, title, subContentSyncCode, this._context);
                CollectionUtils.addIgnoreNull(courseLists, (Object)subContent);
            }
            return courseLists.toArray(new Content[courseLists.size()]);
        }
        if ("courseParts".equals(attributePath)) {
            ArrayList courseParts = new ArrayList();
            List children = DOMUtils.getChildElementsByTagName((Element)parent, (String)_TAG_COURSEPART);
            for (Element child : children) {
                String title = DOMUtils.getChildElementByTagName((Element)child, (String)"title").getTextContent();
                Element subContentSyncCodeElement = DOMUtils.getChildElementByTagName((Element)child, (String)"code");
                String subContentSyncCode = subContentSyncCodeElement != null ? subContentSyncCodeElement.getTextContent() : StringUtils.generateKey().toUpperCase();
                ModifiableContent subContent = this._component.importOrSynchronizeContent(child, ContentWorkflowDescription.COURSEPART_WF_DESCRIPTION, title, subContentSyncCode, this._context);
                CollectionUtils.addIgnoreNull(courseParts, (Object)subContent);
            }
            return courseParts.toArray(new Content[courseParts.size()]);
        }
        return super._extractElementValue(parent, definition, additionalData);
    }
}

