/*
 *  Copyright 2017 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * This tool allows to see items from an external datasource, in order to import them.
 */
Ext.define('Ametys.plugins.odfsync.apogee.ApogeeFilledSearchTool', {
    extend: 'Ametys.plugins.odfsync.apogee.ApogeeSCCSearchTool',
    
    _initSearchForm: function(params)
    {
        this.callParent(arguments);
        
        if (this._parent != null)
        {
            Ametys.data.ServerComm.callMethod({
                role: "org.ametys.plugins.contentio.synchronize.search.SCCSearchToolHelper",
                methodName: "getSyncCode",
                parameters: [this.getParams().controllerId, this._parent.getParameters().id, this._collectionId],
                callback: {
                    handler: this._fillSearchFields,
                    scope: this
                },
                errorMessage: {
                    msg: "{{i18n plugin.odf-sync:PLUGINS_ODF_SYNC_UITOOL_GET_SYNC_PARENT_ERROR}}",
                    category: Ext.getClassName(this)
                }
            });
        }
    },
    
    /**
     * @protected
     * Callback function after getting the parent sync code
     * @param {Object} result The server result
     */
    _fillSearchFields: function(result)
    {
        throw new Error("This method is not implemented in " + this.self.getName());
    }
});
