<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2018 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:cdm="http://cdm-fr.fr/2013/CDM"
    xmlns:cdmfr="http://cdm-fr.fr/2013/CDM-frSchema"
    xmlns:ametys-cdm="http://www.ametys.org/cdm/1.0"
    exclude-result-prefixes="cdm cdmfr ametys-cdm">
    
    <!-- Identifiant CDM -->
    <xsl:template name="container-CDMid">
        <xsl:attribute name="CDMid"><xsl:value-of select="@id"/></xsl:attribute>
    </xsl:template>
    
    <!-- Code -->
    <xsl:template name="container-code">
        <xsl:if test="cdm:programID">
            <code><xsl:value-of select="cdm:programID"/></code>
        </xsl:if>
    </xsl:template>
    
    <!-- Titre -->
    <xsl:template name="container-title">
        <xsl:if test="cdmfr:programName/cdmfr:text">
            <title><xsl:value-of select="cdmfr:programName/cdmfr:text"/></title>
        </xsl:if>
    </xsl:template>
    
    <!-- Container - période -->
    <xsl:template name="container-period">
        <xsl:if test="cdm:infoBlock[@userDefined = 'ametys-extension']/cdm:extension/ametys-cdm:period">
            <period><xsl:value-of select="cdm:infoBlock[@userDefined = 'ametys-extension']/cdm:extension/ametys-cdm:period/@code"/></period>
        </xsl:if>
    </xsl:template>
    
    <!-- Organisation -->
    <xsl:template name="container-teachingOrganization">
        <teachingOrganization>
            <xsl:if test="cdmfr:programStructure[not(cdmfr:refCourse)]/cdm:infoBlock/*">
                <xsl:apply-templates select="cdmfr:programStructure[not(cdmfr:refCourse)]/cdm:infoBlock[*]" mode="infoblock"/>
            </xsl:if>
        </teachingOrganization>
    </xsl:template>
    
    <!-- Crédits ECTS -->
    <xsl:template name="container-ects">
       <ects><xsl:value-of select="cdm:qualification/cdmfr:credits/@ECTScredits"/></ects>
    </xsl:template>
    
    <!-- Nature -->
    <xsl:template name="container-nature">
        <nature><xsl:value-of select="cdmfr:programDescription/@nature"/></nature>
    </xsl:template>

    <xsl:template name="container-subProgram">
        <xsl:for-each select="cdm:subProgram[cdm:infoBlock/@userDefined = 'subProgram']">
            <subProgram>
                <xsl:call-template name="program-parse"/>
            </subProgram>
        </xsl:for-each>
        <xsl:for-each select="cdm:subProgram[cdm:infoBlock/@userDefined = 'container']">
            <container>
                <xsl:call-template name="container-parse"/>
            </container>
        </xsl:for-each>
    </xsl:template>
    
    <!-- Structure -->
    <xsl:template name="container-structure">
        <!-- Courses lists -->
        <xsl:for-each select="cdmfr:programStructure[cdmfr:refCourse]">
            <coursesReferences name="{cdm:infoBlock[@userDefined = 'listName']}" code="{cdm:infoBlock[@userDefined = 'listCode']}" choiceType="{cdm:infoBlock[@userDefined = 'listChoiceType']}">
                <xsl:if test="cdm:infoBlock[@userDefined = 'listMinNumberOfCourses']">
                    <xsl:attribute name="min"><xsl:value-of select="cdm:infoBlock[@userDefined = 'listMinNumberOfCourses']"/></xsl:attribute>
                </xsl:if>
                <xsl:if test="cdm:infoBlock[@userDefined = 'listMaxNumberOfCourses']">
                    <xsl:attribute name="max"><xsl:value-of select="cdm:infoBlock[@userDefined = 'listMaxNumberOfCourses']"/></xsl:attribute>
                </xsl:if>
                <xsl:for-each select="cdmfr:refCourse">
                    <item><xsl:value-of select="@idRef"/></item>
                </xsl:for-each>
            </coursesReferences>
        </xsl:for-each>
    </xsl:template>
        
    <!-- Template to override in order to add customized fields -->
    <xsl:template name="container-additionalFields"/>
</xsl:stylesheet>
