<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2012 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:cdm="http://cdm-fr.fr/2012/CDM"
	xmlns:cdmfr="http://cdm-fr.fr/2012/CDM-frSchema"
	exclude-result-prefixes="cdm cdmfr">

	<xsl:import href="../cdm11/orgunit2content.xsl"/>
	
	<!-- @Override OrgUnit ID -->
	<xsl:template name="orgunit-CDMid">
		<xsl:attribute name="CDMid"><xsl:value-of select="cdm:orgUnitID"/></xsl:attribute>
	</xsl:template>
	
	<!-- @Override Titre -->
	<xsl:template name="orgunit-title">
		<xsl:if test="cdm:orgUnitName">
			<title><xsl:value-of select="cdm:orgUnitName"/></title>
		</xsl:if>
	</xsl:template>
	
	<!-- @Override RNE Code -->
	<xsl:template name="orgunit-rneCode">
		<xsl:if test="cdm:orgUnitCode[@codeSet='codeUAI']">
			<rneCode><xsl:value-of select="cdm:orgUnitCode[@codeSet='codeUAI']"/></rneCode>
		</xsl:if>
	</xsl:template>
	
	<!-- @Override Contacts -->
	<xsl:template name="orgunit-contactsReferences">
		<contactsReferences>
			<xsl:for-each select="cdm:contacts/cdm:refPerson">
				<item><xsl:value-of select="@ref"/></item>
			</xsl:for-each>
		</contactsReferences>
	</xsl:template>
	
</xsl:stylesheet>