/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfsync.cdmfr.extractor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.ametys.cms.contenttype.ContentAttributeDefinition;
import org.ametys.cms.contenttype.ContentType;
import org.ametys.cms.repository.Content;
import org.ametys.cms.repository.ModifiableContent;
import org.ametys.core.util.dom.DOMUtils;
import org.ametys.odf.enumeration.OdfReferenceTableEntry;
import org.ametys.plugins.odfsync.cdmfr.ImportCDMFrContext;
import org.ametys.plugins.odfsync.cdmfr.components.ImportCDMFrComponent;
import org.ametys.plugins.odfsync.cdmfr.extractor.ImportCDMFrValuesExtractorFactory;
import org.ametys.plugins.odfsync.utils.ContentWorkflowDescription;
import org.ametys.plugins.repository.data.extractor.xml.ModelAwareXMLValuesExtractor;
import org.ametys.runtime.model.ElementDefinition;
import org.ametys.runtime.model.Model;
import org.ametys.runtime.model.ModelItemContainer;
import org.ametys.runtime.model.type.ElementType;
import org.apache.commons.lang3.StringUtils;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ImportCDMFrValuesExtractor
extends ModelAwareXMLValuesExtractor {
    protected static final String _TAG_COURSELIST = "coursesReferences";
    protected static final String _MULTIPLE_DATA_ITEM_TAG = "item";
    protected ImportCDMFrValuesExtractorFactory _factory;
    protected ImportCDMFrComponent _component;
    protected ImportCDMFrContext _context;

    public ImportCDMFrValuesExtractor(Element element, ImportCDMFrValuesExtractorFactory factory, ImportCDMFrComponent component, ImportCDMFrContext context, Model ... models) {
        this(element, factory, component, context, Arrays.asList(models));
    }

    public ImportCDMFrValuesExtractor(Element element, ImportCDMFrValuesExtractorFactory factory, ImportCDMFrComponent component, ImportCDMFrContext context, Collection<? extends ModelItemContainer> modelItemContainers) {
        super(element, modelItemContainers);
        this._factory = factory;
        this._component = component;
        this._context = context;
    }

    protected <T> Object _extractElementValue(Element parent, ElementDefinition<T> definition, Optional<Object> additionalData) throws Exception {
        if (definition instanceof ContentAttributeDefinition) {
            String contentTypeId = ((ContentAttributeDefinition)definition).getContentTypeId();
            if ("org.ametys.plugins.odf.Content.person".equals(contentTypeId)) {
                return this._extractContentValues(parent, definition, "person", ContentWorkflowDescription.PERSON_WF_DESCRIPTION);
            }
            if ("org.ametys.plugins.odf.Content.orgunit".equals(contentTypeId)) {
                return this._extractContentValues(parent, definition, "orgunit", ContentWorkflowDescription.ORGUNIT_WF_DESCRIPTION);
            }
            ContentType contentType = (ContentType)this._factory.getContentTypeExtensionPoint().getExtension(contentTypeId);
            if (contentType.isReferenceTable() && this._factory.getODFReferenceTableHelper().isTableReference(contentTypeId)) {
                return this._extractTableRefValues(parent, definition, contentTypeId);
            }
        }
        if (definition.isMultiple()) {
            ElementType type = definition.getType();
            String dataName = definition.getName();
            Element child = DOMUtils.getChildElementByTagName((Element)parent, (String)dataName);
            return type.valueFromXML(child, _MULTIPLE_DATA_ITEM_TAG, additionalData);
        }
        return super._extractElementValue(parent, definition, additionalData);
    }

    protected Object _extractContentValues(Element parent, ElementDefinition definition, String contentTagName, ContentWorkflowDescription workflowDescription) throws Exception {
        Element child = DOMUtils.getChildElementByTagName((Element)parent, (String)definition.getName());
        if (definition.isMultiple()) {
            ArrayList contents = new ArrayList();
            List items = DOMUtils.getChildElementsByTagName((Element)child, (String)_MULTIPLE_DATA_ITEM_TAG);
            for (Element item : items) {
                this._extractContentValue(item, contentTagName, workflowDescription).ifPresent(contents::add);
            }
            return contents.toArray(new Content[contents.size()]);
        }
        return this._extractContentValue(child, contentTagName, workflowDescription).orElse(null);
    }

    protected Optional<Content> _extractContentValue(Element item, String contentTagName, ContentWorkflowDescription workflowDescription) throws Exception {
        String syncCode = item.getTextContent().trim();
        Element contentElement = (Element)XPathAPI.selectSingleNode((Node)this._context.getDocument().getFirstChild(), (String)(contentTagName + "[@CDMid = '" + syncCode + "']"));
        if (contentElement != null) {
            Element titleElement = DOMUtils.getChildElementByTagName((Element)contentElement, (String)"title");
            String title = titleElement != null ? titleElement.getTextContent() : syncCode;
            ModifiableContent content = this._component.importOrSynchronizeContent(contentElement, workflowDescription, title, syncCode, this._context);
            return Optional.ofNullable(content);
        }
        this._context.getLogger().warn("There is no {} tag corresponding to the CDM ID '{}'.", (Object)contentTagName, (Object)syncCode);
        return Optional.empty();
    }

    protected Object _extractTableRefValues(Element parent, ElementDefinition definition, String contentTypeId) throws Exception {
        Element child = DOMUtils.getChildElementByTagName((Element)parent, (String)definition.getName());
        if (definition.isMultiple()) {
            ArrayList contents = new ArrayList();
            List items = DOMUtils.getChildElementsByTagName((Element)child, (String)_MULTIPLE_DATA_ITEM_TAG);
            for (Element item : items) {
                this._extractTableRefValue(item, contentTypeId).ifPresent(contents::add);
            }
            return contents.toArray(new Content[contents.size()]);
        }
        return this._extractTableRefValue(child, contentTypeId).orElse(null);
    }

    protected Optional<Content> _extractTableRefValue(Element item, String contentTypeId) throws Exception {
        String syncCode = item.getTextContent().trim();
        if (StringUtils.isNotEmpty((CharSequence)syncCode)) {
            Optional<Content> content = Optional.ofNullable(this._factory.getODFReferenceTableHelper().getItemFromCDM(contentTypeId, syncCode)).map(OdfReferenceTableEntry::getContent);
            if (content.isEmpty()) {
                this._context.getLogger().warn("There is no entry corresponding to the CDM-fr or Ametys code '{}' in the reference table '{}'.", (Object)syncCode, (Object)contentTypeId);
            }
            return content;
        }
        return Optional.empty();
    }

    protected String _getAttributeOrDefault(Element element, String attributeName, String defaultValue) {
        String attributeValue = element.getAttribute(attributeName);
        return StringUtils.isNotEmpty((CharSequence)attributeValue) ? attributeValue : defaultValue;
    }
}

