/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfsync.cdmfr.extractor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.ametys.cms.repository.Content;
import org.ametys.cms.repository.ModifiableContent;
import org.ametys.core.util.dom.DOMUtils;
import org.ametys.plugins.odfsync.cdmfr.ImportCDMFrContext;
import org.ametys.plugins.odfsync.cdmfr.components.ImportCDMFrComponent;
import org.ametys.plugins.odfsync.cdmfr.extractor.ImportCDMFrValuesExtractor;
import org.ametys.plugins.odfsync.cdmfr.extractor.ImportCDMFrValuesExtractorFactory;
import org.ametys.plugins.odfsync.utils.ContentWorkflowDescription;
import org.ametys.runtime.model.ElementDefinition;
import org.ametys.runtime.model.Model;
import org.ametys.runtime.model.ModelHelper;
import org.ametys.runtime.model.ModelItem;
import org.ametys.runtime.model.ModelItemContainer;
import org.apache.commons.collections4.CollectionUtils;
import org.w3c.dom.Element;

public class ImportTraversableProgramPartValuesExtractor
extends ImportCDMFrValuesExtractor {
    protected static final String _TAG_SUBPROGRAM = "subProgram";
    protected static final String _TAG_CONTAINER = "container";
    protected String _synchronizationCode;

    public ImportTraversableProgramPartValuesExtractor(Element element, ImportCDMFrValuesExtractorFactory factory, ImportCDMFrComponent component, String synchronizationCode, ImportCDMFrContext context, Model ... models) {
        this(element, factory, component, synchronizationCode, context, Arrays.asList(models));
    }

    public ImportTraversableProgramPartValuesExtractor(Element element, ImportCDMFrValuesExtractorFactory factory, ImportCDMFrComponent component, String synchronizationCode, ImportCDMFrContext context, Collection<? extends ModelItemContainer> modelItemContainers) {
        super(element, factory, component, context, modelItemContainers);
        this._synchronizationCode = synchronizationCode;
    }

    protected Optional<ModelItem> _getModelItemFromNodeName(Element parent, String nodeName, Collection<? extends ModelItemContainer> modelItemContainers) {
        if (_TAG_SUBPROGRAM.equals(nodeName) || _TAG_CONTAINER.equals(nodeName) || "coursesReferences".equals(nodeName)) {
            return Optional.of(ModelHelper.getModelItem((String)"childProgramParts", modelItemContainers));
        }
        return super._getModelItemFromNodeName(parent, nodeName, modelItemContainers);
    }

    protected boolean _hasChildForAttribute(Element element, String attributeName) {
        if ("childProgramParts".equals(attributeName)) {
            return DOMUtils.hasChildElement((Element)element, (String)_TAG_SUBPROGRAM) || DOMUtils.hasChildElement((Element)element, (String)_TAG_CONTAINER) || DOMUtils.hasChildElement((Element)element, (String)"coursesReferences");
        }
        return super._hasChildForAttribute(element, attributeName);
    }

    @Override
    protected <T> Object _extractElementValue(Element parent, ElementDefinition<T> definition, Optional<Object> additionalData) throws Exception {
        String attributePath = definition.getPath();
        if ("childProgramParts".equals(attributePath)) {
            ArrayList childProgramParts = new ArrayList();
            List children = DOMUtils.getChildElements((Element)parent);
            int courseListPosition = 0;
            for (Element child : children) {
                String subContentSyncCode;
                String title;
                String tagName = child.getNodeName();
                if (_TAG_SUBPROGRAM.equals(tagName) || _TAG_CONTAINER.equals(tagName)) {
                    title = DOMUtils.getChildElementByTagName((Element)child, (String)"title").getTextContent();
                    subContentSyncCode = child.getAttribute("CDMid");
                    ContentWorkflowDescription workflowDescription = _TAG_SUBPROGRAM.equals(tagName) ? ContentWorkflowDescription.SUBPROGRAM_WF_DESCRIPTION : ContentWorkflowDescription.CONTAINER_WF_DESCRIPTION;
                    ModifiableContent subContent = this._component.importOrSynchronizeContent(child, workflowDescription, title, subContentSyncCode, this._context);
                    CollectionUtils.addIgnoreNull(childProgramParts, (Object)subContent);
                    continue;
                }
                if (!"coursesReferences".equals(tagName)) continue;
                title = this._getAttributeOrDefault(child, "name", "Liste d'\u00e9l\u00e9ments p\u00e9dagogiques");
                subContentSyncCode = this._getAttributeOrDefault(child, "code", this._synchronizationCode + "-" + ++courseListPosition);
                ModifiableContent subContent = this._component.importOrSynchronizeContent(child, ContentWorkflowDescription.COURSELIST_WF_DESCRIPTION, title, subContentSyncCode, this._context);
                CollectionUtils.addIgnoreNull(childProgramParts, (Object)subContent);
            }
            return childProgramParts.toArray(new Content[childProgramParts.size()]);
        }
        return super._extractElementValue(parent, definition, additionalData);
    }
}

