/*
 *  Copyright 2017 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.odfsync.apogee.scc;

import org.ametys.runtime.i18n.I18nizableText;

/**
 * Criterion for Apogee.
 */
public class ApogeeCriterion
{
    private String _id;
    private I18nizableText _label;
    private String _type;
    
    /**
     * Constructor.
     * @param id the id
     * @param label the label
     * @param type the type
     */
    public ApogeeCriterion(String id, I18nizableText label, String type)
    {
        this._id = id;
        this._label = label;
        this._type = type;
    }
    
    /**
     * Get the id.
     * @return the id
     */
    public String getId()
    {
        return _id;
    }
    
    /**
     * Get the label.
     * @return the label
     */
    public I18nizableText getLabel()
    {
        return _label;
    }
    
    /**
     * Get the type.
     * @return the type
     */
    public String getType()
    {
        return _type;
    }
}
