/*
 *  Copyright 2019 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.odfsync.cdmfr;

import java.util.List;
import java.util.Map;
import java.util.Set;

import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.slf4j.Logger;

import org.ametys.cms.data.ContentSynchronizationResult;
import org.ametys.cms.repository.ModifiableContent;
import org.ametys.core.schedule.progression.ContainerProgressionTracker;
import org.ametys.odf.cdmfr.CDMFRHandler;
import org.ametys.plugins.contentio.synchronize.AbstractSynchronizableContentsCollection;
import org.ametys.plugins.odfsync.cdmfr.components.ImportCDMFrComponent;
import org.ametys.plugins.repository.AmetysObjectIterable;

/**
 * Abstract class to import CDMFr contents
 */
public abstract class AbstractCDMFrSynchronizableContentsCollection extends AbstractSynchronizableContentsCollection
{
    /** The import CDMFr component */
    protected ImportCDMFrComponent _importCDMFrComponent;
    
    /** The CDM-fr handler */
    protected CDMFRHandler _cdmfrHandler;
    
    @Override
    public void service(ServiceManager manager) throws ServiceException
    {
        super.service(manager);
        _importCDMFrComponent = (ImportCDMFrComponent) manager.lookup(ImportCDMFrComponent.ROLE);
        _cdmfrHandler = (CDMFRHandler) manager.lookup(CDMFRHandler.ROLE);
    }
    
    @Override
    public String getIdField()
    {
        return _importCDMFrComponent.getIdField();
    }

    public Set<String> getLocalAndExternalFields(Map<String, Object> additionalParameters)
    {
        return _importCDMFrComponent.getLocalAndExternalFields(additionalParameters);
    }
    
    public ContentSynchronizationResult additionalCommonOperations(ModifiableContent content, Map<String, Object> additionalParameters, Logger logger)
    {
        return _importCDMFrComponent.additionalOperations(content, additionalParameters, logger);
    }

    @Override
    protected void configureDataSource(Configuration configuration) throws ConfigurationException
    {
        // Do Nothing
    }
    
    @Override
    protected void configureSearchModel()
    {
        // Do Nothing
    }
    
    @Override
    public void synchronizeContent(ModifiableContent content, Logger logger) throws Exception
    {
        throw new UnsupportedOperationException("synchronizeContent() method is not supported for CDM-fr synchronizable contents collections.");
    }

    @Override
    public ModifiableContent getContent(String lang, String idValue, boolean forceStrictCheck)
    {
        throw new UnsupportedOperationException("getContent() method is not supported for CDM-fr synchronizable contents collections.");
    }

    @Override
    public Map<String, Map<String, Object>> search(Map<String, Object> searchParameters, int offset, int limit, List<Object> sort, Logger logger)
    {
        throw new UnsupportedOperationException("search() method is not supported for CDM-fr synchronizable contents collections.");
    }

    @Override
    public void updateSyncInformations(ModifiableContent content, String syncCode, Logger logger) throws Exception
    {
        throw new UnsupportedOperationException("updateSyncInformations() method is not supported for CDM-fr synchronizable contents collections.");
    }

    @Override
    public int getTotalCount(Map<String, Object> searchParameters, Logger logger)
    {
        throw new UnsupportedOperationException("getTotalCount() method is not supported for CDM-fr synchronizable contents collections.");
    }

    @Override
    protected List<ModifiableContent> _getContentsToRemove(AmetysObjectIterable<ModifiableContent> contents)
    {
        throw new UnsupportedOperationException("_getContentsToRemove() method is not supported for CDM-fr synchronizable contents collections.");
    }

    @Override
    protected List<ModifiableContent> _internalPopulate(Logger logger, ContainerProgressionTracker progressionTracker)
    {
        throw new UnsupportedOperationException("_internalPopulate() method is not supported for CDM-fr synchronizable contents collections.");
    }
    
    /**
     * Start handle CDM-fr treatments
     */
    protected void _startHandleCDMFR()
    {
        _cdmfrHandler.suspendCDMFRObserver();
    }
    
    /**
     * End handle CDM-fr treatments
     * @param udpatedContentIds the updated contents ids
     */
    protected void _endHandleCDMFR(Set<String> udpatedContentIds)
    {
        _cdmfrHandler.unsuspendCDMFRObserver(udpatedContentIds);
    }
}
