/*
 *  Copyright 2022 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.odfsync.pegase.scc;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.apache.avalon.framework.activity.Initializable;

import org.ametys.plugins.odfsync.GlobalSynchronizationClientSideElement;
import org.ametys.runtime.config.Config;

/**
 * SCC client side element to activate or not buttons from the general configuration.
 */
public class PegaseGlobalSynchronizationClientSideElement extends GlobalSynchronizationClientSideElement implements Initializable
{
    private boolean _isActive;
    
    public void initialize() throws Exception
    {
        _isActive = Config.getInstance().getValue("pegase.activate", true, false);
    }
    
    @Override
    public List<Script> getScripts(boolean ignoreRights, Map<String, Object> contextParameters)
    {
        if (_isActive)
        {
            return super.getScripts(ignoreRights, contextParameters);
        }
        return new ArrayList<>();
    }
}
