/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfsync.cdmfr;

import java.io.File;
import java.io.FileFilter;
import java.util.Date;

public class CDMFrFileFilter
implements FileFilter {
    private Date _lastModifiedAfter;
    private Date _lastModifiedBefore;
    private String _fileName;

    public CDMFrFileFilter(String fileName, Date lastModifiedAfter, Date lastModifiedBefore) {
        this._fileName = fileName;
        this._lastModifiedAfter = lastModifiedAfter;
        this._lastModifiedBefore = lastModifiedBefore;
    }

    @Override
    public boolean accept(File pathname) {
        if (pathname.isDirectory()) {
            return false;
        }
        String fileName = pathname.getName().toLowerCase();
        if (!fileName.endsWith(".xml")) {
            return false;
        }
        if (this._fileName != null && !fileName.contains(this._fileName.toLowerCase())) {
            return false;
        }
        Date lastModified = new Date(pathname.lastModified());
        if (this._lastModifiedAfter != null && lastModified.before(this._lastModifiedAfter)) {
            return false;
        }
        return this._lastModifiedBefore == null || !lastModified.after(this._lastModifiedBefore);
    }
}

