/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfsync.cdmfr.extractor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.ametys.cms.repository.Content;
import org.ametys.cms.repository.ModifiableContent;
import org.ametys.core.util.dom.DOMUtils;
import org.ametys.plugins.odfsync.cdmfr.ImportCDMFrContext;
import org.ametys.plugins.odfsync.cdmfr.components.ImportCDMFrComponent;
import org.ametys.plugins.odfsync.cdmfr.extractor.ImportCDMFrValuesExtractor;
import org.ametys.plugins.odfsync.cdmfr.extractor.ImportCDMFrValuesExtractorFactory;
import org.ametys.plugins.odfsync.utils.ContentWorkflowDescription;
import org.ametys.runtime.model.ElementDefinition;
import org.ametys.runtime.model.Model;
import org.ametys.runtime.model.ModelHelper;
import org.ametys.runtime.model.ModelItem;
import org.ametys.runtime.model.ModelItemContainer;
import org.ametys.runtime.model.ViewElement;
import org.ametys.runtime.model.ViewItem;
import org.ametys.runtime.model.ViewItemContainer;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class ImportCourseListValuesExtractor
extends ImportCDMFrValuesExtractor {
    public ImportCourseListValuesExtractor(Element element, ImportCDMFrValuesExtractorFactory factory, ImportCDMFrComponent component, ImportCDMFrContext context, Model ... models) {
        this(element, factory, component, context, Arrays.asList(models));
    }

    public ImportCourseListValuesExtractor(Element element, ImportCDMFrValuesExtractorFactory factory, ImportCDMFrComponent component, ImportCDMFrContext context, Collection<? extends ModelItemContainer> modelItemContainers) {
        super(element, factory, component, context, modelItemContainers);
    }

    protected void _fillViewItemContainerFromXML(Element element, ViewItemContainer viewItemContainer, Collection<? extends ModelItemContainer> modelItemContainers) throws Exception {
        NamedNodeMap attributes = element.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node attribute = attributes.item(i);
            Optional optionalModelItem = this._getModelItemFromNodeName(element, attribute.getNodeName(), modelItemContainers);
            if (!optionalModelItem.isPresent()) continue;
            ModelItem modelItem = (ModelItem)optionalModelItem.get();
            ViewElement modelViewItem = new ViewElement();
            modelViewItem.setDefinition(modelItem);
            viewItemContainer.addViewItem((ViewItem)modelViewItem);
        }
        if (DOMUtils.hasChildElement((Element)element, (String)"item")) {
            ModelItem childCoursesModelItem = ModelHelper.getModelItem((String)"courses", modelItemContainers);
            ViewElement modelViewItem = new ViewElement();
            modelViewItem.setDefinition(childCoursesModelItem);
            viewItemContainer.addViewItem((ViewItem)modelViewItem);
        }
    }

    protected boolean _hasChildForAttribute(Element element, String attributeName) {
        return "courses".equals(attributeName) ? DOMUtils.hasChildElement((Element)element, (String)"item") : element.hasAttribute(attributeName);
    }

    @Override
    protected <T> Object _extractElementValue(Element parent, ElementDefinition<T> definition, Optional<Object> additionalData) throws Exception {
        String attributePath = definition.getPath();
        if ("courses".equals(attributePath)) {
            Document doc = this._context.getDocument();
            String lang = this._context.getLang();
            ArrayList courses = new ArrayList();
            List children = DOMUtils.getChildElementsByTagName((Element)parent, (String)"item");
            for (Element child : children) {
                String courseSyncCode = child.getTextContent().trim();
                Element courseElement = (Element)XPathAPI.selectSingleNode((Node)doc.getFirstChild(), (String)("course[@CDMid = '" + courseSyncCode + "' and @language = '" + lang + "']"));
                if (courseElement == null) {
                    courseElement = (Element)XPathAPI.selectSingleNode((Node)doc.getFirstChild(), (String)("course[@CDMid = '" + courseSyncCode + "']"));
                }
                if (courseElement == null) continue;
                String courseCatalog = this._component.getCatalogName(courseElement);
                if (courseCatalog != null && !courseCatalog.equals(this._context.getCatalog())) {
                    String cdmCode = DOMUtils.getChildElementByTagName((Element)courseElement, (String)"cdmCode").getTextContent();
                    this._context.getLogger().error("The course '{}' belongs to a different catalog than the one from the imported/synchronized program : '{}' vs '{}'. No synchronization will be done on this course.", new Object[]{cdmCode, courseCatalog, this._context.getCatalog()});
                    continue;
                }
                ImportCDMFrContext courseContext = new ImportCDMFrContext(this._context);
                String elpLang = courseElement.getAttribute("language");
                if (StringUtils.isNotEmpty((CharSequence)elpLang)) {
                    courseContext.setLang(elpLang);
                }
                String title = DOMUtils.getChildElementByTagName((Element)courseElement, (String)"title").getTextContent();
                ModifiableContent course = this._component.importOrSynchronizeContent(courseElement, ContentWorkflowDescription.COURSE_WF_DESCRIPTION, title, courseSyncCode, courseContext);
                CollectionUtils.addIgnoreNull(courses, (Object)course);
            }
            return courses.toArray(new Content[courses.size()]);
        }
        String attribute = parent.getAttribute(attributePath);
        if (StringUtils.isNotEmpty((CharSequence)attribute)) {
            return "choiceType".equals(attributePath) ? attribute.toUpperCase() : definition.getType().castValue((Object)attribute);
        }
        return null;
    }
}

